/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class Gcj
extends DefaultCompilerAdapter {
    private static final String[] CONFLICT_WITH_DASH_C = new String[]{"-o", "--main=", "-D", "-fjni", "-L"};

    public boolean execute() throws BuildException {
        this.attributes.log("Using gcj compiler", 3);
        Commandline commandline = this.setupGCJCommand();
        int n = commandline.size();
        this.logAndAddFilesToCompile(commandline);
        return this.executeExternalCompile(commandline.getCommandline(), n) == 0;
    }

    protected Commandline setupGCJCommand() {
        Commandline commandline = new Commandline();
        Path path = new Path(this.project);
        if (this.bootclasspath != null) {
            path.append(this.bootclasspath);
        }
        path.addExtdirs(this.extdirs);
        if (this.bootclasspath == null || this.bootclasspath.size() == 0) {
            this.includeJavaRuntime = true;
        }
        path.append(this.getCompileClasspath());
        if (this.compileSourcepath != null) {
            path.append(this.compileSourcepath);
        } else {
            path.append(this.src);
        }
        String string = this.getJavac().getExecutable();
        commandline.setExecutable(string == null ? "gcj" : string);
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir);
            if (!this.destDir.exists() && !this.destDir.mkdirs()) {
                throw new BuildException("Can't make output directories. Maybe permission is wrong. ");
            }
        }
        commandline.createArgument().setValue("-classpath");
        commandline.createArgument().setPath(path);
        if (this.encoding != null) {
            commandline.createArgument().setValue("--encoding=" + this.encoding);
        }
        if (this.debug) {
            commandline.createArgument().setValue("-g1");
        }
        if (this.optimize) {
            commandline.createArgument().setValue("-O");
        }
        if (!this.isNativeBuild()) {
            commandline.createArgument().setValue("-C");
        }
        this.addCurrentCompilerArgs(commandline);
        return commandline;
    }

    public boolean isNativeBuild() {
        boolean bl = false;
        String[] stringArray = this.getJavac().getCurrentCompilerArgs();
        int n = 0;
        while (!bl && n < stringArray.length) {
            int n2 = 0;
            while (!bl && n2 < CONFLICT_WITH_DASH_C.length) {
                bl = stringArray[n].startsWith(CONFLICT_WITH_DASH_C[n2]);
                ++n2;
            }
            ++n;
        }
        return bl;
    }
}

