/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.taskdefs.cvslib.CvsTagEntry;
import org.apache.tools.ant.util.FileUtils;

public class CvsTagDiff
extends AbstractCvsTask {
    static final String FILE_STRING = "File ";
    static final String TO_STRING = " to ";
    static final String FILE_IS_NEW = " is new;";
    static final String REVISION = "revision ";
    static final String FILE_HAS_CHANGED = " changed from revision ";
    static final String FILE_WAS_REMOVED = " is removed";
    private String mypackage;
    private String mystartTag;
    private String myendTag;
    private String mystartDate;
    private String myendDate;
    private File mydestfile;
    private FileUtils myfileUtils = FileUtils.newFileUtils();

    public void setPackage(String string) {
        this.mypackage = string;
    }

    public void setStartTag(String string) {
        this.mystartTag = string;
    }

    public void setStartDate(String string) {
        this.mystartDate = string;
    }

    public void setEndTag(String string) {
        this.myendTag = string;
    }

    public void setEndDate(String string) {
        this.myendDate = string;
    }

    public void setDestFile(File file) {
        this.mydestfile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block8: {
            this.validate();
            this.addCommandArgument("rdiff");
            this.addCommandArgument("-s");
            if (this.mystartTag != null) {
                this.addCommandArgument("-r");
                this.addCommandArgument(this.mystartTag);
            } else {
                this.addCommandArgument("-D");
                this.addCommandArgument(this.mystartDate);
            }
            if (this.myendTag != null) {
                this.addCommandArgument("-r");
                this.addCommandArgument(this.myendTag);
            } else {
                this.addCommandArgument("-D");
                this.addCommandArgument(this.myendDate);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.mypackage);
            while (stringTokenizer.hasMoreTokens()) {
                this.addCommandArgument(stringTokenizer.nextToken());
            }
            this.setCommand("");
            File file = null;
            try {
                file = this.myfileUtils.createTempFile("cvstagdiff", ".log", null);
                file.deleteOnExit();
                this.setOutput(file);
                super.execute();
                CvsTagEntry[] cvsTagEntryArray = this.parseRDiff(file);
                this.writeTagDiff(cvsTagEntryArray);
                Object var5_4 = null;
                if (file == null) break block8;
                file.delete();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (file != null) {
                    file.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CvsTagEntry[] parseRDiff(File file) throws BuildException {
        Object[] objectArray;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = FILE_STRING + this.mypackage + "/";
            int n = string.length();
            Vector<CvsTagEntry> vector = new Vector<CvsTagEntry>();
            String string2 = bufferedReader.readLine();
            CvsTagEntry cvsTagEntry = null;
            while (true) {
                Object object;
                if (null == string2) {
                    object = new CvsTagEntry[vector.size()];
                    vector.copyInto((Object[])object);
                    objectArray = object;
                    if (bufferedReader == null) return objectArray;
                    break;
                }
                if (string2.length() > n) {
                    int n2 = (string2 = string2.startsWith(string) ? string2.substring(n) : string2.substring(FILE_STRING.length())).indexOf(FILE_IS_NEW);
                    if (n2 != -1) {
                        object = string2.substring(0, n2);
                        String string3 = null;
                        int n3 = -1;
                        n3 = string2.indexOf(REVISION, n2);
                        if (n3 != -1) {
                            string3 = string2.substring(n3 + REVISION.length());
                        }
                        cvsTagEntry = new CvsTagEntry((String)object, string3);
                        vector.addElement(cvsTagEntry);
                        this.log(cvsTagEntry.toString(), 3);
                    } else {
                        n2 = string2.indexOf(FILE_HAS_CHANGED);
                        if (n2 != -1) {
                            object = string2.substring(0, n2);
                            int n4 = string2.indexOf(TO_STRING, n2);
                            String string4 = string2.substring(n2 + FILE_HAS_CHANGED.length(), n4);
                            String string5 = string2.substring(n4 + TO_STRING.length());
                            cvsTagEntry = new CvsTagEntry((String)object, string5, string4);
                            vector.addElement(cvsTagEntry);
                            this.log(cvsTagEntry.toString(), 3);
                        } else {
                            n2 = string2.indexOf(FILE_WAS_REMOVED);
                            if (n2 != -1) {
                                object = string2.substring(0, n2);
                                String string6 = null;
                                int n5 = -1;
                                n5 = string2.indexOf(REVISION, n2);
                                if (n5 != -1) {
                                    string6 = string2.substring(n5 + REVISION.length());
                                }
                                cvsTagEntry = new CvsTagEntry((String)object, null, string6);
                                vector.addElement(cvsTagEntry);
                                this.log(cvsTagEntry.toString(), 3);
                            }
                        }
                    }
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            try {
                throw new BuildException("Error in parsing", iOException);
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    this.log(iOException2.toString(), 0);
                    throw throwable;
                }
            }
        }
        try {
            bufferedReader.close();
            return objectArray;
        }
        catch (IOException iOException) {
            this.log(iOException.toString(), 0);
        }
        return objectArray;
    }

    private void writeTagDiff(CvsTagEntry[] cvsTagEntryArray) throws BuildException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.mydestfile);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.print("<tagdiff ");
            if (this.mystartTag != null) {
                printWriter.print("startTag=\"" + this.mystartTag + "\" ");
            } else {
                printWriter.print("startDate=\"" + this.mystartDate + "\" ");
            }
            if (this.myendTag != null) {
                printWriter.print("endTag=\"" + this.myendTag + "\" ");
            } else {
                printWriter.print("endDate=\"" + this.myendDate + "\" ");
            }
            printWriter.print("cvsroot=\"" + this.getCvsRoot() + "\" ");
            printWriter.print("package=\"" + this.mypackage + "\" ");
            printWriter.println(">");
            int n = 0;
            int n2 = cvsTagEntryArray.length;
            while (n < n2) {
                this.writeTagEntry(printWriter, cvsTagEntryArray[n]);
                ++n;
            }
            printWriter.println("</tagdiff>");
            printWriter.flush();
            printWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.log(unsupportedEncodingException.toString(), 0);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.toString(), iOException);
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.log(iOException.toString(), 0);
                }
            }
        }
    }

    private void writeTagEntry(PrintWriter printWriter, CvsTagEntry cvsTagEntry) {
        printWriter.println("\t<entry>");
        printWriter.println("\t\t<file>");
        printWriter.println("\t\t\t<name>" + cvsTagEntry.getFile() + "</name>");
        if (cvsTagEntry.getRevision() != null) {
            printWriter.println("\t\t\t<revision>" + cvsTagEntry.getRevision() + "</revision>");
        }
        if (cvsTagEntry.getPreviousRevision() != null) {
            printWriter.println("\t\t\t<prevrevision>" + cvsTagEntry.getPreviousRevision() + "</prevrevision>");
        }
        printWriter.println("\t\t</file>");
        printWriter.println("\t</entry>");
    }

    private void validate() throws BuildException {
        if (null == this.mypackage) {
            throw new BuildException("Package/module must be set.");
        }
        if (null == this.mydestfile) {
            throw new BuildException("Destfile must be set.");
        }
        if (null == this.mystartTag && null == this.mystartDate) {
            throw new BuildException("Start tag or start date must be set.");
        }
        if (null != this.mystartTag && null != this.mystartDate) {
            throw new BuildException("Only one of start tag and start date must be set.");
        }
        if (null == this.myendTag && null == this.myendDate) {
            throw new BuildException("End tag or end date must be set.");
        }
        if (null != this.myendTag && null != this.myendDate) {
            throw new BuildException("Only one of end tag and end date must be set.");
        }
    }
}

