/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class Assertions
extends DataType
implements Cloneable {
    private Boolean enableSystemAssertions;
    private ArrayList assertionList = new ArrayList();

    public void addEnable(EnabledAssertion enabledAssertion) {
        this.checkChildrenAllowed();
        this.assertionList.add(enabledAssertion);
    }

    public void addDisable(DisabledAssertion disabledAssertion) {
        this.checkChildrenAllowed();
        this.assertionList.add(disabledAssertion);
    }

    public void setEnableSystemAssertions(Boolean bl) {
        this.checkAttributesAllowed();
        this.enableSystemAssertions = bl;
    }

    public void setRefid(Reference reference) {
        if (this.assertionList.size() > 0 || this.enableSystemAssertions != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    private Assertions getFinalReference() {
        if (this.getRefid() == null) {
            return this;
        }
        Object object = this.getRefid().getReferencedObject(this.getProject());
        if (!(object instanceof Assertions)) {
            throw new BuildException("reference is of wrong type");
        }
        return (Assertions)object;
    }

    public int size() {
        Assertions assertions = this.getFinalReference();
        return assertions.getFinalSize();
    }

    private int getFinalSize() {
        return this.assertionList.size() + (this.enableSystemAssertions != null ? 1 : 0);
    }

    public void applyAssertions(List list) {
        this.getProject().log("Applying assertions", 4);
        Assertions assertions = this.getFinalReference();
        if (Boolean.TRUE.equals(assertions.enableSystemAssertions)) {
            this.getProject().log("Enabling system assertions", 4);
            list.add("-enablesystemassertions");
        } else if (Boolean.FALSE.equals(assertions.enableSystemAssertions)) {
            this.getProject().log("disabling system assertions", 4);
            list.add("-disablesystemassertions");
        }
        Iterator iterator = assertions.assertionList.iterator();
        while (iterator.hasNext()) {
            BaseAssertion baseAssertion = (BaseAssertion)iterator.next();
            String string = baseAssertion.toCommand();
            this.getProject().log("adding assertion " + string, 4);
            list.add(string);
        }
    }

    public void applyAssertions(CommandlineJava commandlineJava) {
        Assertions assertions = this.getFinalReference();
        if (Boolean.TRUE.equals(assertions.enableSystemAssertions)) {
            Assertions.addVmArgument(commandlineJava, "-enablesystemassertions");
        } else if (Boolean.FALSE.equals(assertions.enableSystemAssertions)) {
            Assertions.addVmArgument(commandlineJava, "-disablesystemassertions");
        }
        Iterator iterator = assertions.assertionList.iterator();
        while (iterator.hasNext()) {
            BaseAssertion baseAssertion = (BaseAssertion)iterator.next();
            String string = baseAssertion.toCommand();
            Assertions.addVmArgument(commandlineJava, string);
        }
    }

    public void applyAssertions(ListIterator listIterator) {
        this.getProject().log("Applying assertions", 4);
        Assertions assertions = this.getFinalReference();
        if (Boolean.TRUE.equals(assertions.enableSystemAssertions)) {
            this.getProject().log("Enabling system assertions", 4);
            listIterator.add("-enablesystemassertions");
        } else if (Boolean.FALSE.equals(assertions.enableSystemAssertions)) {
            this.getProject().log("disabling system assertions", 4);
            listIterator.add("-disablesystemassertions");
        }
        Iterator iterator = assertions.assertionList.iterator();
        while (iterator.hasNext()) {
            BaseAssertion baseAssertion = (BaseAssertion)iterator.next();
            String string = baseAssertion.toCommand();
            this.getProject().log("adding assertion " + string, 4);
            listIterator.add(string);
        }
    }

    private static void addVmArgument(CommandlineJava commandlineJava, String string) {
        Commandline.Argument argument = commandlineJava.createVmArgument();
        argument.setValue(string);
    }

    public Object clone() throws CloneNotSupportedException {
        Assertions assertions = (Assertions)super.clone();
        assertions.assertionList = (ArrayList)this.assertionList.clone();
        return assertions;
    }

    public static abstract class BaseAssertion {
        private String packageName;
        private String className;

        public void setClass(String string) {
            this.className = string;
        }

        public void setPackage(String string) {
            this.packageName = string;
        }

        protected String getClassName() {
            return this.className;
        }

        protected String getPackageName() {
            return this.packageName;
        }

        public abstract String getCommandPrefix();

        public String toCommand() {
            if (this.getPackageName() != null && this.getClassName() != null) {
                throw new BuildException("Both package and class have been set");
            }
            StringBuffer stringBuffer = new StringBuffer(this.getCommandPrefix());
            if (this.getPackageName() != null) {
                stringBuffer.append(':');
                stringBuffer.append(this.getPackageName());
                if (!stringBuffer.toString().endsWith("...")) {
                    stringBuffer.append("...");
                }
            } else if (this.getClassName() != null) {
                stringBuffer.append(':');
                stringBuffer.append(this.getClassName());
            }
            return stringBuffer.toString();
        }
    }

    public static class DisabledAssertion
    extends BaseAssertion {
        public String getCommandPrefix() {
            return "-da";
        }
    }

    public static class EnabledAssertion
    extends BaseAssertion {
        public String getCommandPrefix() {
            return "-ea";
        }
    }
}

