/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.JavaEnvUtils;

public class CommandlineJava
implements Cloneable {
    private Commandline vmCommand = new Commandline();
    private Commandline javaCommand = new Commandline();
    private SysProperties sysProperties = new SysProperties();
    private Path classpath = null;
    private Path bootclasspath = null;
    private String vmVersion;
    private String maxMemory = null;
    private Assertions assertions = null;
    private boolean executeJar = false;

    public CommandlineJava() {
        this.setVm(JavaEnvUtils.getJreExecutable("java"));
        this.setVmversion(JavaEnvUtils.getJavaVersion());
    }

    public Commandline.Argument createArgument() {
        return this.javaCommand.createArgument();
    }

    public Commandline.Argument createVmArgument() {
        return this.vmCommand.createArgument();
    }

    public void addSysproperty(Environment.Variable variable) {
        this.sysProperties.addVariable(variable);
    }

    public void addSyspropertyset(PropertySet propertySet) {
        this.sysProperties.addSyspropertyset(propertySet);
    }

    public void setVm(String string) {
        this.vmCommand.setExecutable(string);
    }

    public void setVmversion(String string) {
        this.vmVersion = string;
    }

    public Assertions getAssertions() {
        return this.assertions;
    }

    public void setAssertions(Assertions assertions) {
        this.assertions = assertions;
    }

    public void setJar(String string) {
        this.javaCommand.setExecutable(string);
        this.executeJar = true;
    }

    public String getJar() {
        if (this.executeJar) {
            return this.javaCommand.getExecutable();
        }
        return null;
    }

    public void setClassname(String string) {
        this.javaCommand.setExecutable(string);
        this.executeJar = false;
    }

    public String getClassname() {
        if (!this.executeJar) {
            return this.javaCommand.getExecutable();
        }
        return null;
    }

    public Path createClasspath(Project project) {
        if (this.classpath == null) {
            this.classpath = new Path(project);
        }
        return this.classpath;
    }

    public Path createBootclasspath(Project project) {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(project);
        }
        return this.bootclasspath;
    }

    public String getVmversion() {
        return this.vmVersion;
    }

    public String[] getCommandline() {
        LinkedList linkedList = new LinkedList();
        ListIterator listIterator = linkedList.listIterator();
        this.addCommandsToList(listIterator);
        return linkedList.toArray(new String[0]);
    }

    private void addCommandsToList(ListIterator listIterator) {
        this.getActualVMCommand().addCommandToList(listIterator);
        this.sysProperties.addDefinitionsToList(listIterator);
        if (this.haveBootclasspath(true)) {
            listIterator.add("-Xbootclasspath:" + this.bootclasspath.toString());
        }
        if (this.haveClasspath()) {
            listIterator.add("-classpath");
            listIterator.add(this.classpath.concatSystemClasspath("ignore").toString());
        }
        if (this.getAssertions() != null) {
            this.getAssertions().applyAssertions(listIterator);
        }
        if (this.executeJar) {
            listIterator.add("-jar");
        }
        this.javaCommand.addCommandToList(listIterator);
    }

    public void setMaxmemory(String string) {
        this.maxMemory = string;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public String describeCommand() {
        return Commandline.describeCommand(this.getCommandline());
    }

    public String describeJavaCommand() {
        return Commandline.describeCommand(this.getJavaCommand());
    }

    protected Commandline getActualVMCommand() {
        Commandline commandline = (Commandline)this.vmCommand.clone();
        if (this.maxMemory != null) {
            if (this.vmVersion.startsWith("1.1")) {
                commandline.createArgument().setValue("-mx" + this.maxMemory);
            } else {
                commandline.createArgument().setValue("-Xmx" + this.maxMemory);
            }
        }
        return commandline;
    }

    public int size() {
        int n = this.getActualVMCommand().size() + this.javaCommand.size() + this.sysProperties.size();
        if (this.haveClasspath()) {
            n += 2;
        }
        if (this.haveBootclasspath(true)) {
            ++n;
        }
        if (this.executeJar) {
            ++n;
        }
        if (this.getAssertions() != null) {
            n += this.getAssertions().size();
        }
        return n;
    }

    public Commandline getJavaCommand() {
        return this.javaCommand;
    }

    public Commandline getVmCommand() {
        return this.getActualVMCommand();
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public void setSystemProperties() throws BuildException {
        this.sysProperties.setSystem();
    }

    public void restoreSystemProperties() throws BuildException {
        this.sysProperties.restoreSystem();
    }

    public SysProperties getSystemProperties() {
        return this.sysProperties;
    }

    public Object clone() {
        try {
            CommandlineJava commandlineJava = (CommandlineJava)super.clone();
            commandlineJava.vmCommand = (Commandline)this.vmCommand.clone();
            commandlineJava.javaCommand = (Commandline)this.javaCommand.clone();
            commandlineJava.sysProperties = (SysProperties)this.sysProperties.clone();
            if (this.classpath != null) {
                commandlineJava.classpath = (Path)this.classpath.clone();
            }
            if (this.bootclasspath != null) {
                commandlineJava.bootclasspath = (Path)this.bootclasspath.clone();
            }
            if (this.assertions != null) {
                commandlineJava.assertions = (Assertions)this.assertions.clone();
            }
            return commandlineJava;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    public void clearJavaArgs() {
        this.javaCommand.clearArgs();
    }

    protected boolean haveClasspath() {
        Path path = this.classpath != null ? this.classpath.concatSystemClasspath("ignore") : null;
        return path != null && path.toString().trim().length() > 0;
    }

    protected boolean haveBootclasspath(boolean bl) {
        if (this.bootclasspath != null && this.bootclasspath.toString().trim().length() > 0) {
            if (!this.bootclasspath.toString().equals(this.bootclasspath.concatSystemClasspath("ignore").toString())) {
                if (bl) {
                    System.out.println("Ignoring bootclasspath as build.sysclasspath has been set.");
                }
            } else if (this.vmVersion.startsWith("1.1")) {
                if (bl) {
                    System.out.println("Ignoring bootclasspath as the target VM doesn't support it.");
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static class SysProperties
    extends Environment
    implements Cloneable {
        Properties sys = null;
        private Vector propertySets = new Vector();

        public String[] getVariables() throws BuildException {
            LinkedList linkedList = new LinkedList();
            ListIterator listIterator = linkedList.listIterator();
            this.addDefinitionsToList(listIterator);
            if (linkedList.size() == 0) {
                return null;
            }
            return linkedList.toArray(new String[0]);
        }

        public void addDefinitionsToList(ListIterator listIterator) {
            String[] stringArray = super.getVariables();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    listIterator.add("-D" + stringArray[n]);
                    ++n;
                }
            }
            Properties properties = this.mergePropertySets();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                listIterator.add("-D" + string + "=" + string2);
            }
        }

        public int size() {
            Properties properties = this.mergePropertySets();
            return this.variables.size() + properties.size();
        }

        public void setSystem() throws BuildException {
            try {
                Enumeration enumeration;
                this.sys = System.getProperties();
                Properties properties = new Properties();
                Enumeration<Object> enumeration2 = this.sys.keys();
                while (enumeration2.hasMoreElements()) {
                    enumeration = enumeration2.nextElement();
                    properties.put(enumeration, this.sys.get(enumeration));
                }
                properties.putAll((Map<?, ?>)this.mergePropertySets());
                enumeration = this.variables.elements();
                while (enumeration.hasMoreElements()) {
                    Environment.Variable variable = (Environment.Variable)enumeration.nextElement();
                    properties.put(variable.getKey(), variable.getValue());
                }
                System.setProperties(properties);
            }
            catch (SecurityException securityException) {
                throw new BuildException("Cannot modify system properties", securityException);
            }
        }

        public void restoreSystem() throws BuildException {
            if (this.sys == null) {
                throw new BuildException("Unbalanced nesting of SysProperties");
            }
            try {
                System.setProperties(this.sys);
                this.sys = null;
            }
            catch (SecurityException securityException) {
                throw new BuildException("Cannot modify system properties", securityException);
            }
        }

        public Object clone() {
            try {
                SysProperties sysProperties = (SysProperties)super.clone();
                sysProperties.variables = (Vector)this.variables.clone();
                sysProperties.propertySets = (Vector)this.propertySets.clone();
                return sysProperties;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void addSyspropertyset(PropertySet propertySet) {
            this.propertySets.addElement(propertySet);
        }

        private Properties mergePropertySets() {
            Properties properties = new Properties();
            Enumeration enumeration = this.propertySets.elements();
            while (enumeration.hasMoreElements()) {
                PropertySet propertySet = (PropertySet)enumeration.nextElement();
                properties.putAll((Map<?, ?>)propertySet.getProperties());
            }
            return properties;
        }
    }
}

