/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Reference;

public abstract class DataType
extends ProjectComponent {
    protected String description;
    protected Reference ref;
    protected boolean checked = true;

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReference() {
        return this.ref != null;
    }

    public void setRefid(Reference reference) {
        this.ref = reference;
        this.checked = false;
    }

    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.checked || !this.isReference()) {
            return;
        }
        Object object = this.ref.getReferencedObject(project);
        if (object instanceof DataType) {
            if (stack.contains(object)) {
                throw this.circularReference();
            }
            stack.push(object);
            ((DataType)object).dieOnCircularReference(stack, project);
            stack.pop();
        }
        this.checked = true;
    }

    protected Object getCheckedRef(Class clazz, String string) {
        Object object;
        if (!this.checked) {
            object = new Stack<DataType>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, this.getProject());
        }
        if (!clazz.isAssignableFrom((object = this.ref.getReferencedObject(this.getProject())).getClass())) {
            String string2 = this.ref.getRefId() + " doesn't denote a " + string;
            throw new BuildException(string2);
        }
        return object;
    }

    protected BuildException tooManyAttributes() {
        return new BuildException("You must not specify more than one attribute when using refid");
    }

    protected BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested elements when using refid");
    }

    protected BuildException circularReference() {
        return new BuildException("This data type contains a circular reference.");
    }

    protected boolean isChecked() {
        return this.checked;
    }

    protected void setChecked(boolean bl) {
        this.checked = bl;
    }

    protected Reference getRefid() {
        return this.ref;
    }

    protected void checkAttributesAllowed() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
    }

    protected void checkChildrenAllowed() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
    }
}

