/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ZipScanner
extends DirectoryScanner {
    protected File srcFile;
    private Resource lastScannedResource;
    private Hashtable myentries;
    private String encoding;

    public void setSrc(File file) {
        this.srcFile = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String[] getIncludedFiles() {
        if (this.srcFile != null) {
            Object object;
            Vector<String> vector = new Vector<String>();
            this.scanme();
            Enumeration enumeration = this.myentries.elements();
            while (enumeration.hasMoreElements()) {
                object = (Resource)enumeration.nextElement();
                if (((Resource)object).isDirectory() || !this.match(((Resource)object).getName())) continue;
                vector.addElement(((Resource)object).getName());
            }
            object = new String[vector.size()];
            vector.copyInto((Object[])object);
            Arrays.sort((Object[])object);
            return object;
        }
        return super.getIncludedFiles();
    }

    public String[] getIncludedDirectories() {
        if (this.srcFile != null) {
            Object object;
            Vector<String> vector = new Vector<String>();
            this.scanme();
            Enumeration enumeration = this.myentries.elements();
            while (enumeration.hasMoreElements()) {
                object = (Resource)enumeration.nextElement();
                if (!((Resource)object).isDirectory() || !this.match(((Resource)object).getName())) continue;
                vector.addElement(((Resource)object).getName());
            }
            object = new String[vector.size()];
            vector.copyInto((Object[])object);
            Arrays.sort((Object[])object);
            return object;
        }
        return super.getIncludedDirectories();
    }

    public void init() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    public boolean match(String string) {
        String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return this.isIncluded(string2) && !this.isExcluded(string2);
    }

    public Resource getResource(String string) {
        if (this.srcFile == null) {
            return super.getResource(string);
        }
        if (string.equals("")) {
            return new Resource("", true, Long.MAX_VALUE, true);
        }
        this.scanme();
        if (this.myentries.containsKey(string)) {
            return (Resource)this.myentries.get(string);
        }
        if (this.myentries.containsKey(string + "/")) {
            return (Resource)this.myentries.get(string + "/");
        }
        return new Resource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanme() {
        Resource resource;
        block11: {
            resource = new Resource(this.srcFile.getAbsolutePath(), this.srcFile.exists(), this.srcFile.lastModified());
            if (this.lastScannedResource != null && this.lastScannedResource.getName().equals(resource.getName()) && this.lastScannedResource.getLastModified() == resource.getLastModified()) {
                return;
            }
            ZipEntry zipEntry = null;
            ZipFile zipFile = null;
            this.myentries = new Hashtable();
            try {
                try {
                    zipFile = new ZipFile(this.srcFile, this.encoding);
                }
                catch (ZipException zipException) {
                    throw new BuildException("problem reading " + this.srcFile, zipException);
                }
                catch (IOException iOException) {
                    throw new BuildException("problem opening " + this.srcFile, iOException);
                }
                Enumeration enumeration = zipFile.getEntries();
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        Object var7_7 = null;
                        if (zipFile == null) break block11;
                        break;
                    }
                    zipEntry = (ZipEntry)enumeration.nextElement();
                    this.myentries.put(new String(zipEntry.getName()), new Resource(zipEntry.getName(), true, zipEntry.getTime(), zipEntry.isDirectory()));
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            zipFile.close();
        }
        this.lastScannedResource = resource;
    }
}

