/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.DifferentSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SelectorContainer;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.TypeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

public abstract class BaseSelectorContainer
extends BaseSelector
implements SelectorContainer {
    private Vector selectorsList = new Vector();

    public boolean hasSelectors() {
        return !this.selectorsList.isEmpty();
    }

    public int selectorCount() {
        return this.selectorsList.size();
    }

    public FileSelector[] getSelectors(Project project) {
        Object[] objectArray = new FileSelector[this.selectorsList.size()];
        this.selectorsList.copyInto(objectArray);
        return objectArray;
    }

    public Enumeration selectorElements() {
        return this.selectorsList.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.selectorElements();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement().toString());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public void appendSelector(FileSelector fileSelector) {
        this.selectorsList.addElement(fileSelector);
    }

    public void validate() {
        this.verifySettings();
        String string = this.getError();
        if (string != null) {
            throw new BuildException(string);
        }
        Enumeration enumeration = this.selectorElements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof BaseSelector)) continue;
            ((BaseSelector)e).validate();
        }
    }

    public abstract boolean isSelected(File var1, String var2, File var3);

    public void addSelector(SelectSelector selectSelector) {
        this.appendSelector(selectSelector);
    }

    public void addAnd(AndSelector andSelector) {
        this.appendSelector(andSelector);
    }

    public void addOr(OrSelector orSelector) {
        this.appendSelector(orSelector);
    }

    public void addNot(NotSelector notSelector) {
        this.appendSelector(notSelector);
    }

    public void addNone(NoneSelector noneSelector) {
        this.appendSelector(noneSelector);
    }

    public void addMajority(MajoritySelector majoritySelector) {
        this.appendSelector(majoritySelector);
    }

    public void addDate(DateSelector dateSelector) {
        this.appendSelector(dateSelector);
    }

    public void addSize(SizeSelector sizeSelector) {
        this.appendSelector(sizeSelector);
    }

    public void addFilename(FilenameSelector filenameSelector) {
        this.appendSelector(filenameSelector);
    }

    public void addCustom(ExtendSelector extendSelector) {
        this.appendSelector(extendSelector);
    }

    public void addContains(ContainsSelector containsSelector) {
        this.appendSelector(containsSelector);
    }

    public void addPresent(PresentSelector presentSelector) {
        this.appendSelector(presentSelector);
    }

    public void addDepth(DepthSelector depthSelector) {
        this.appendSelector(depthSelector);
    }

    public void addDepend(DependSelector dependSelector) {
        this.appendSelector(dependSelector);
    }

    public void addDifferent(DifferentSelector differentSelector) {
        this.appendSelector(differentSelector);
    }

    public void addType(TypeSelector typeSelector) {
        this.appendSelector(typeSelector);
    }

    public void addContainsRegexp(ContainsRegexpSelector containsRegexpSelector) {
        this.appendSelector(containsRegexpSelector);
    }

    public void addModified(ModifiedSelector modifiedSelector) {
        this.appendSelector(modifiedSelector);
    }

    public void add(FileSelector fileSelector) {
        this.appendSelector(fileSelector);
    }
}

