/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.util.regexp.Regexp;

public class ContainsRegexpSelector
extends BaseExtendSelector {
    private String userProvidedExpression = null;
    private RegularExpression myRegExp = null;
    private Regexp myExpression = null;
    public static final String EXPRESSION_KEY = "expression";

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{containsregexpselector expression: ");
        stringBuffer.append(this.userProvidedExpression);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setExpression(String string) {
        this.userProvidedExpression = string;
    }

    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                String string = parameterArray[n].getName();
                if (EXPRESSION_KEY.equalsIgnoreCase(string)) {
                    this.setExpression(parameterArray[n].getValue());
                } else {
                    this.setError("Invalid parameter " + string);
                }
                ++n;
            }
        }
    }

    public void verifySettings() {
        if (this.userProvidedExpression == null) {
            this.setError("The expression attribute is required");
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        String string2 = null;
        BufferedReader bufferedReader = null;
        this.validate();
        if (file2.isDirectory()) {
            return true;
        }
        if (this.myRegExp == null) {
            this.myRegExp = new RegularExpression();
            this.myRegExp.setPattern(this.userProvidedExpression);
            this.myExpression = this.myRegExp.getRegexp(this.getProject());
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (this.myExpression.matches(string2)) {
                    boolean bl = true;
                    return bl;
                }
                string2 = bufferedReader.readLine();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw new BuildException("Could not read file " + string);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    throw new BuildException("Could not close file " + string);
                }
            }
        }
    }
}

