/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class ContainsSelector
extends BaseExtendSelector {
    private String contains = null;
    private boolean casesensitive = true;
    private boolean ignorewhitespace = false;
    public static final String EXPRESSION_KEY = "expression";
    public static final String CONTAINS_KEY = "text";
    public static final String CASE_KEY = "casesensitive";
    public static final String WHITESPACE_KEY = "ignorewhitespace";

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{containsselector text: ");
        stringBuffer.append(this.contains);
        stringBuffer.append(" casesensitive: ");
        if (this.casesensitive) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append(" ignorewhitespace: ");
        if (this.ignorewhitespace) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setText(String string) {
        this.contains = string;
    }

    public void setCasesensitive(boolean bl) {
        this.casesensitive = bl;
    }

    public void setIgnorewhitespace(boolean bl) {
        this.ignorewhitespace = bl;
    }

    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                String string = parameterArray[n].getName();
                if (CONTAINS_KEY.equalsIgnoreCase(string)) {
                    this.setText(parameterArray[n].getValue());
                } else if (CASE_KEY.equalsIgnoreCase(string)) {
                    this.setCasesensitive(Project.toBoolean(parameterArray[n].getValue()));
                } else if (WHITESPACE_KEY.equalsIgnoreCase(string)) {
                    this.setIgnorewhitespace(Project.toBoolean(parameterArray[n].getValue()));
                } else {
                    this.setError("Invalid parameter " + string);
                }
                ++n;
            }
        }
    }

    public void verifySettings() {
        if (this.contains == null) {
            this.setError("The text attribute is required");
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        if (file2.isDirectory()) {
            return true;
        }
        String string2 = this.contains;
        if (!this.casesensitive) {
            string2 = this.contains.toLowerCase();
        }
        if (this.ignorewhitespace) {
            string2 = SelectorUtils.removeWhitespace(string2);
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (!this.casesensitive) {
                    string3 = string3.toLowerCase();
                }
                if (this.ignorewhitespace) {
                    string3 = SelectorUtils.removeWhitespace(string3);
                }
                if (string3.indexOf(string2) > -1) {
                    boolean bl = true;
                    return bl;
                }
                string3 = bufferedReader.readLine();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw new BuildException("Could not read file " + string);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    throw new BuildException("Could not close file " + string);
                }
            }
        }
    }
}

