/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors.modifiedselector;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.types.selectors.modifiedselector.Cache;

public class PropertiesfileCache
implements Cache {
    private File cachefile = null;
    private Properties cache = new Properties();
    private boolean cacheLoaded = false;
    private boolean cacheDirty = true;

    public PropertiesfileCache() {
    }

    public PropertiesfileCache(File file) {
        this.cachefile = file;
    }

    public void setCachefile(File file) {
        this.cachefile = file;
    }

    public File getCachefile() {
        return this.cachefile;
    }

    public boolean isValid() {
        return this.cachefile != null;
    }

    public void load() {
        if (this.cachefile != null && this.cachefile.isFile() && this.cachefile.canRead()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.cachefile));
                this.cache.load(bufferedInputStream);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.cacheLoaded = true;
        this.cacheDirty = false;
    }

    public void save() {
        if (!this.cacheDirty) {
            return;
        }
        if (this.cachefile != null && this.cache.propertyNames().hasMoreElements()) {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.cachefile));
                this.cache.store(bufferedOutputStream, null);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.cacheDirty = false;
    }

    public void delete() {
        this.cache = new Properties();
        this.cachefile.delete();
        this.cacheLoaded = true;
        this.cacheDirty = false;
    }

    public Object get(Object object) {
        if (!this.cacheLoaded) {
            this.load();
        }
        try {
            return this.cache.getProperty(String.valueOf(object));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public void put(Object object, Object object2) {
        this.cache.put(String.valueOf(object), String.valueOf(object2));
        this.cacheDirty = true;
    }

    public Iterator iterator() {
        Vector vector = new Vector();
        Enumeration<?> enumeration = this.cache.propertyNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<PropertiesfileCache:");
        stringBuffer.append("cachefile=").append(this.cachefile);
        stringBuffer.append(";noOfEntries=").append(this.cache.size());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

