/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateUtils {
    public static final String ISO8601_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String ISO8601_DATE_PATTERN = "yyyy-MM-dd";
    public static final String ISO8601_TIME_PATTERN = "HH:mm:ss";
    public static final DateFormat DATE_HEADER_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
    private static final MessageFormat MINUTE_SECONDS = new MessageFormat("{0}{1}");
    private static final double[] LIMITS = new double[]{0.0, 1.0, 2.0};
    private static final String[] MINUTES_PART = new String[]{"", "1 minute ", "{0,number} minutes "};
    private static final String[] SECONDS_PART = new String[]{"0 seconds", "1 second", "{1,number} seconds"};
    private static final ChoiceFormat MINUTES_FORMAT = new ChoiceFormat(LIMITS, MINUTES_PART);
    private static final ChoiceFormat SECONDS_FORMAT = new ChoiceFormat(LIMITS, SECONDS_PART);

    private DateUtils() {
    }

    public static String format(long l, String string) {
        return DateUtils.format(new Date(l), string);
    }

    public static String format(Date date, String string) {
        DateFormat dateFormat = DateUtils.createDateFormat(string);
        return dateFormat.format(date);
    }

    public static String formatElapsedTime(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        Object[] objectArray = new Object[]{new Long(l3), new Long(l2 % 60L)};
        return MINUTE_SECONDS.format(objectArray);
    }

    private static DateFormat createDateFormat(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        simpleDateFormat.setTimeZone(timeZone);
        simpleDateFormat.setLenient(true);
        return simpleDateFormat;
    }

    public static int getPhaseOfMoon(Calendar calendar) {
        int n = calendar.get(6);
        int n2 = (calendar.get(1) - 1900) % 19 + 1;
        int n3 = (11 * n2 + 18) % 30;
        if (n3 == 25 && n2 > 11 || n3 == 24) {
            ++n3;
        }
        return ((n + n3) * 6 + 11) % 177 / 22 & 7;
    }

    public static String getDateForHeader() {
        Calendar calendar = Calendar.getInstance();
        TimeZone timeZone = calendar.getTimeZone();
        int n = timeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        StringBuffer stringBuffer = new StringBuffer(n < 0 ? "-" : "+");
        n = Math.abs(n);
        int n2 = n / 3600000;
        int n3 = n / 60000 - 60 * n2;
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        return DATE_HEADER_FORMAT.format(calendar.getTime()) + stringBuffer.toString();
    }

    public static Date parseIso8601DateTime(String string) throws ParseException {
        return new SimpleDateFormat(ISO8601_DATETIME_PATTERN).parse(string);
    }

    public static Date parseIso8601Date(String string) throws ParseException {
        return new SimpleDateFormat(ISO8601_DATE_PATTERN).parse(string);
    }

    public static Date parseIso8601DateTimeOrDate(String string) throws ParseException {
        try {
            return DateUtils.parseIso8601DateTime(string);
        }
        catch (ParseException parseException) {
            return DateUtils.parseIso8601Date(string);
        }
    }

    static {
        MINUTE_SECONDS.setFormat(0, MINUTES_FORMAT);
        MINUTE_SECONDS.setFormat(1, SECONDS_FORMAT);
    }
}

