/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LineTokenizer;

public class FileUtils {
    private static Random rand = new Random(System.currentTimeMillis());
    private static Object lockReflection = new Object();
    private static Method setLastModified = null;
    private boolean onNetWare = Os.isFamily("netware");
    private static boolean[] isSpecial = new boolean[256];
    private static char[] escapedChar1 = new char[256];
    private static char[] escapedChar2 = new char[256];
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    static /* synthetic */ Class class$java$io$File;

    public static FileUtils newFileUtils() {
        return new FileUtils();
    }

    protected FileUtils() {
    }

    public URL getFileURL(File file) throws MalformedURLException {
        return new URL(this.toURI(file.getAbsolutePath()));
    }

    public void copyFile(String string, String string2) throws IOException {
        this.copyFile(new File(string), new File(string2), null, false, false);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, false, false);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, boolean bl) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, bl, false);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, boolean bl, boolean bl2) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, bl, bl2);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, boolean bl, boolean bl2, String string3) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, bl, bl2, string3);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string3, Project project) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, vector, bl, bl2, string3, project);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string3, String string4, Project project) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, vector, bl, bl2, string3, string4, project);
    }

    public void copyFile(File file, File file2) throws IOException {
        this.copyFile(file, file2, null, false, false);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection) throws IOException {
        this.copyFile(file, file2, filterSetCollection, false, false);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, boolean bl) throws IOException {
        this.copyFile(file, file2, filterSetCollection, bl, false);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, boolean bl, boolean bl2) throws IOException {
        this.copyFile(file, file2, filterSetCollection, bl, bl2, null);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, boolean bl, boolean bl2, String string) throws IOException {
        this.copyFile(file, file2, filterSetCollection, null, bl, bl2, string, null);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string, Project project) throws IOException {
        this.copyFile(file, file2, filterSetCollection, vector, bl, bl2, string, string, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string, String string2, Project project) throws IOException {
        if (bl || !file2.exists() || file2.lastModified() < file.lastModified()) {
            block33: {
                boolean bl3;
                File file3;
                if (file2.exists() && file2.isFile()) {
                    file2.delete();
                }
                if ((file3 = this.getParentFile(file2)) != null && !file3.exists()) {
                    file3.mkdirs();
                }
                boolean bl4 = filterSetCollection != null && filterSetCollection.hasFilters();
                boolean bl5 = bl3 = vector != null && vector.size() > 0;
                if (bl4) {
                    BufferedReader bufferedReader = null;
                    BufferedWriter bufferedWriter = null;
                    try {
                        Object object;
                        Object object2;
                        if (string == null) {
                            bufferedReader = new BufferedReader(new FileReader(file));
                        } else {
                            object2 = new InputStreamReader((InputStream)new FileInputStream(file), string);
                            bufferedReader = new BufferedReader((Reader)object2);
                        }
                        if (string2 == null) {
                            bufferedWriter = new BufferedWriter(new FileWriter(file2));
                        } else {
                            object2 = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string2);
                            bufferedWriter = new BufferedWriter((Writer)object2);
                        }
                        if (bl3) {
                            object2 = new ChainReaderHelper();
                            ((ChainReaderHelper)object2).setBufferSize(8192);
                            ((ChainReaderHelper)object2).setPrimaryReader(bufferedReader);
                            ((ChainReaderHelper)object2).setFilterChains(vector);
                            ((ChainReaderHelper)object2).setProject(project);
                            object = ((ChainReaderHelper)object2).getAssembledReader();
                            bufferedReader = new BufferedReader((Reader)object);
                        }
                        object2 = new LineTokenizer();
                        ((LineTokenizer)object2).setIncludeDelims(true);
                        object = null;
                        String string3 = ((LineTokenizer)object2).getToken(bufferedReader);
                        while (string3 != null) {
                            if (string3.length() == 0) {
                                bufferedWriter.newLine();
                            } else {
                                object = filterSetCollection.replaceTokens(string3);
                                bufferedWriter.write((String)object);
                            }
                            string3 = ((LineTokenizer)object2).getToken(bufferedReader);
                        }
                    }
                    finally {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                }
                if (bl3 || string != null && !string.equals(string2) || string == null && string2 != null) {
                    BufferedReader bufferedReader = null;
                    BufferedWriter bufferedWriter = null;
                    try {
                        Object object;
                        bufferedReader = string == null ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
                        bufferedWriter = string2 == null ? new BufferedWriter(new FileWriter(file2)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string2));
                        if (bl3) {
                            object = new ChainReaderHelper();
                            ((ChainReaderHelper)object).setBufferSize(8192);
                            ((ChainReaderHelper)object).setPrimaryReader(bufferedReader);
                            ((ChainReaderHelper)object).setFilterChains(vector);
                            ((ChainReaderHelper)object).setProject(project);
                            Reader reader = ((ChainReaderHelper)object).getAssembledReader();
                            bufferedReader = new BufferedReader(reader);
                        }
                        object = new char[8192];
                        while (true) {
                            int n;
                            if ((n = bufferedReader.read((char[])object, 0, ((Object)object).length)) == -1) {
                                break block33;
                            }
                            bufferedWriter.write((char[])object, 0, n);
                        }
                    }
                    finally {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                }
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    do {
                        fileOutputStream.write(byArray, 0, n);
                    } while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1);
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            if (bl2) {
                this.setFileLastModified(file2, file.lastModified());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Method getSetLastModified() {
        if (JavaEnvUtils.isJavaVersion("1.1")) {
            return null;
        }
        Object object = lockReflection;
        synchronized (object) {
            if (setLastModified == null) {
                try {
                    setLastModified = (class$java$io$File == null ? (class$java$io$File = FileUtils.class$("java.io.File")) : class$java$io$File).getMethod("setLastModified", Long.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new BuildException("File.setlastModified not in JDK > 1.1?", noSuchMethodException);
                }
            }
        }
        return setLastModified;
    }

    public void setFileLastModified(File file, long l) throws BuildException {
        if (JavaEnvUtils.isJavaVersion("1.1")) {
            return;
        }
        Object[] objectArray = new Long[]{l < 0L ? new Long(System.currentTimeMillis()) : new Long(l)};
        try {
            this.getSetLastModified().invoke((Object)file, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new BuildException("Exception setting the modification time of " + file, throwable);
        }
        catch (Throwable throwable) {
            throw new BuildException("Exception setting the modification time of " + file, throwable);
        }
    }

    public File resolveFile(File file, String string) {
        string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (!this.onNetWare) {
            if (string.startsWith(File.separator) || string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
                return this.normalize(string);
            }
        } else {
            int n = string.indexOf(":");
            if (string.startsWith(File.separator) || n > -1) {
                return this.normalize(string);
            }
        }
        if (file == null) {
            return new File(string);
        }
        File file2 = new File(file.getAbsolutePath());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("..")) {
                if ((file2 = this.getParentFile(file2)) != null) continue;
                String string3 = "The file or path you specified (" + string + ") is invalid relative to " + file.getPath();
                throw new BuildException(string3);
            }
            if (string2.equals(".")) continue;
            file2 = new File(file2, string2);
        }
        return new File(file2.getAbsolutePath());
    }

    public File normalize(String string) {
        Object object;
        Object object2;
        String string2 = string;
        string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int n = string.indexOf(":");
        if (!this.onNetWare) {
            if (!(string.startsWith(File.separator) || string.length() >= 2 && Character.isLetter(string.charAt(0)) && n == 1)) {
                String string3 = string + " is not an absolute path";
                throw new BuildException(string3);
            }
        } else if (!string.startsWith(File.separator) && n == -1) {
            String string4 = string + " is not an absolute path";
            throw new BuildException(string4);
        }
        boolean bl = false;
        String string5 = null;
        if (!this.onNetWare && string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' || this.onNetWare && n > -1) {
            bl = true;
            object2 = string.replace('/', '\\').toCharArray();
            object = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                ((StringBuffer)object).append(Character.toUpperCase((char)object2[n2]));
                ++n2;
            }
            ((StringBuffer)object).append(':');
            if (n + 1 < string.length()) {
                ((StringBuffer)object).append(File.separatorChar);
            }
            string5 = ((StringBuffer)object).toString();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = n + 1;
            while (n3 < ((Object)object2).length) {
                if (object2[n3] != 92 || object2[n3] == 92 && object2[n3 - 1] != 92) {
                    stringBuffer.append((char)object2[n3]);
                }
                ++n3;
            }
            string = stringBuffer.toString().replace('\\', File.separatorChar);
        } else if (string.length() == 1) {
            string5 = File.separator;
            string = "";
        } else if (string.charAt(1) == File.separatorChar) {
            string5 = File.separator + File.separator;
            string = string.substring(2);
        } else {
            string5 = File.separator;
            string = string.substring(1);
        }
        object2 = new Stack();
        ((Stack)object2).push(string5);
        object = new StringTokenizer(string, File.separator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string6 = ((StringTokenizer)object).nextToken();
            if (".".equals(string6)) continue;
            if ("..".equals(string6)) {
                if (((Vector)object2).size() < 2) {
                    throw new BuildException("Cannot resolve path " + string2);
                }
                ((Stack)object2).pop();
                continue;
            }
            ((Stack)object2).push(string6);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < ((Vector)object2).size()) {
            if (n4 > 1) {
                stringBuffer.append(File.separatorChar);
            }
            stringBuffer.append(((Vector)object2).elementAt(n4));
            ++n4;
        }
        string = stringBuffer.toString();
        if (bl) {
            string = string.replace('/', '\\');
        }
        return new File(string);
    }

    public String toVMSPath(File file) {
        String string = this.normalize(file.getAbsolutePath()).getPath();
        String string2 = file.getName();
        boolean bl = string.charAt(0) == File.separatorChar;
        boolean bl2 = file.isDirectory() && !string2.regionMatches(true, string2.length() - 4, ".DIR", 0, 4);
        String string3 = null;
        StringBuffer stringBuffer = null;
        String string4 = null;
        int n = 0;
        if (bl) {
            n = string.indexOf(File.separatorChar, 1);
            if (n == -1) {
                return string.substring(1) + ":[000000]";
            }
            string3 = string.substring(1, n++);
        }
        if (bl2) {
            stringBuffer = new StringBuffer(string.substring(n).replace(File.separatorChar, '.'));
        } else {
            int n2 = string.lastIndexOf(File.separatorChar, string.length());
            if (n2 == -1 || n2 < n) {
                string4 = string.substring(n);
            } else {
                stringBuffer = new StringBuffer(string.substring(n, n2).replace(File.separatorChar, '.'));
                n = n2 + 1;
                if (string.length() > n) {
                    string4 = string.substring(n);
                }
            }
        }
        if (!bl && stringBuffer != null) {
            stringBuffer.insert(0, '.');
        }
        String string5 = (string3 != null ? string3 + ":" : "") + (stringBuffer != null ? "[" + stringBuffer + "]" : "") + (string4 != null ? string4 : "");
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String string, String string2, File file) {
        File file2 = null;
        String string3 = System.getProperty("java.io.tmpdir");
        if (file != null) {
            string3 = file.getPath();
        }
        DecimalFormat decimalFormat = new DecimalFormat("#####");
        Random random = rand;
        synchronized (random) {
            while ((file2 = new File(string3, string + decimalFormat.format(Math.abs(rand.nextInt())) + string2)).exists()) {
            }
        }
        return file2;
    }

    /*
     * Exception decompiling
     */
    public boolean contentEquals(File var1_1, File var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File getParentFile(File file) {
        String string;
        if (file != null && (string = file.getParent()) != null) {
            return new File(string);
        }
        return null;
    }

    public static final String readFully(Reader reader) throws IOException {
        return FileUtils.readFully(reader, 8192);
    }

    public static final String readFully(Reader reader, int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] cArray = new char[n];
        int n2 = 0;
        String string = null;
        StringBuffer stringBuffer = null;
        while (n2 != -1) {
            n2 = reader.read(cArray);
            if (n2 == -1) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(new String(cArray, 0, n2));
                continue;
            }
            stringBuffer.append(new String(cArray, 0, n2));
        }
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createNewFile(File file) throws IOException {
        if (file == null) return false;
        if (file.exists()) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(new byte[0]);
            Object var4_3 = null;
            if (fileOutputStream == null) return true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
        return true;
    }

    public boolean isSymbolicLink(File file, String string) throws IOException {
        File file2 = new File(file.getCanonicalPath());
        File file3 = new File(file2, string);
        return !file3.getAbsolutePath().equals(file3.getCanonicalPath());
    }

    public String removeLeadingPath(File file, File file2) {
        String string;
        String string2 = this.normalize(file.getAbsolutePath()).getAbsolutePath();
        if (string2.equals(string = this.normalize(file2.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public String toURI(String string) {
        boolean bl = new File(string).isDirectory();
        StringBuffer stringBuffer = new StringBuffer("file:");
        try {
            string = this.normalize(string).getAbsolutePath();
            stringBuffer.append("//");
            if (!string.startsWith(File.separator)) {
                stringBuffer.append("/");
            }
        }
        catch (BuildException buildException) {
            // empty catch block
        }
        string = string.replace('\\', '/');
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c < '\u0100' && isSpecial[c]) {
                stringBuffer.append('%');
                stringBuffer.append(escapedChar1[c]);
                stringBuffer.append(escapedChar2[c]);
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        if (bl && !string.endsWith("/")) {
            stringBuffer.append('/');
        }
        return stringBuffer.toString();
    }

    public String fromURI(String string) {
        String string2 = Locator.fromURI((String)string);
        try {
            string2 = this.normalize(string2).getAbsolutePath();
        }
        catch (BuildException buildException) {}
        return string2;
    }

    public boolean fileNameEquals(File file, File file2) {
        return this.normalize(file.getAbsolutePath()).equals(this.normalize(file2.getAbsolutePath()));
    }

    public void rename(File file, File file2) throws IOException {
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Failed to delete " + file2 + " while trying to rename " + file);
        }
        File file3 = this.getParentFile(file2);
        if (file3 != null && !file3.exists() && !file3.mkdirs()) {
            throw new IOException("Failed to create directory " + file3 + " while trying to rename " + file);
        }
        if (!file.renameTo(file2)) {
            this.copyFile(file, file2);
            if (!file.delete()) {
                throw new IOException("Failed to delete " + file + " while trying to rename it.");
            }
        }
    }

    public long getFileTimestampGranularity() {
        if (Os.isFamily("dos")) {
            return 2000L;
        }
        return 0L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n = 0;
        while (n <= 32) {
            FileUtils.isSpecial[n] = true;
            FileUtils.escapedChar1[n] = Character.forDigit(n >> 4, 16);
            FileUtils.escapedChar2[n] = Character.forDigit(n & 0xF, 16);
            ++n;
        }
        FileUtils.isSpecial[127] = true;
        FileUtils.escapedChar1[127] = 55;
        FileUtils.escapedChar2[127] = 70;
        char[] cArray = new char[]{'<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            FileUtils.isSpecial[c] = true;
            FileUtils.escapedChar1[c] = Character.forDigit(c >> 4, 16);
            FileUtils.escapedChar2[c] = Character.forDigit(c & 0xF, 16);
            ++n3;
        }
    }
}

