/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JAXPUtils {
    private static final FileUtils fu = FileUtils.newFileUtils();
    private static SAXParserFactory parserFactory = null;
    private static SAXParserFactory nsParserFactory = null;
    private static DocumentBuilderFactory builderFactory = null;

    public static synchronized SAXParserFactory getParserFactory() throws BuildException {
        if (parserFactory == null) {
            parserFactory = JAXPUtils.newParserFactory();
        }
        return parserFactory;
    }

    public static synchronized SAXParserFactory getNSParserFactory() throws BuildException {
        if (nsParserFactory == null) {
            nsParserFactory = JAXPUtils.newParserFactory();
            nsParserFactory.setNamespaceAware(true);
        }
        return nsParserFactory;
    }

    public static SAXParserFactory newParserFactory() throws BuildException {
        try {
            return SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new BuildException("XML parser factory has not been configured correctly: " + factoryConfigurationError.getMessage(), factoryConfigurationError);
        }
    }

    public static Parser getParser() throws BuildException {
        try {
            return JAXPUtils.newSAXParser(JAXPUtils.getParserFactory()).getParser();
        }
        catch (SAXException sAXException) {
            throw JAXPUtils.convertToBuildException(sAXException);
        }
    }

    public static XMLReader getXMLReader() throws BuildException {
        try {
            return JAXPUtils.newSAXParser(JAXPUtils.getParserFactory()).getXMLReader();
        }
        catch (SAXException sAXException) {
            throw JAXPUtils.convertToBuildException(sAXException);
        }
    }

    public static XMLReader getNamespaceXMLReader() throws BuildException {
        try {
            return JAXPUtils.newSAXParser(JAXPUtils.getNSParserFactory()).getXMLReader();
        }
        catch (SAXException sAXException) {
            throw JAXPUtils.convertToBuildException(sAXException);
        }
    }

    public static String getSystemId(File file) {
        return fu.toURI(file.getAbsolutePath());
    }

    public static DocumentBuilder getDocumentBuilder() throws BuildException {
        try {
            return JAXPUtils.getDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException(parserConfigurationException);
        }
    }

    private static SAXParser newSAXParser(SAXParserFactory sAXParserFactory) throws BuildException {
        try {
            return sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException("Cannot create parser for the given configuration: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw JAXPUtils.convertToBuildException(sAXException);
        }
    }

    private static BuildException convertToBuildException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception != null) {
            return new BuildException(exception);
        }
        return new BuildException(sAXException);
    }

    private static synchronized DocumentBuilderFactory getDocumentBuilderFactory() throws BuildException {
        if (builderFactory == null) {
            try {
                builderFactory = DocumentBuilderFactory.newInstance();
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new BuildException("Document builder factory has not been configured correctly: " + factoryConfigurationError.getMessage(), factoryConfigurationError);
            }
        }
        return builderFactory;
    }
}

