/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.tools.ant.Task;

public class LeadPipeInputStream
extends PipedInputStream {
    private Task managingTask;

    public LeadPipeInputStream() {
    }

    public LeadPipeInputStream(int n) {
        this.setBufferSize(n);
    }

    public LeadPipeInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        super(pipedOutputStream);
    }

    public LeadPipeInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
        super(pipedOutputStream);
        this.setBufferSize(n);
    }

    public synchronized int read() throws IOException {
        int n;
        block3: {
            n = -1;
            try {
                n = super.read();
            }
            catch (IOException iOException) {
                if ("write end dead".equalsIgnoreCase(iOException.getMessage())) {
                    if (this.in <= 0 || this.out >= this.buffer.length || this.out <= this.in) break block3;
                    n = this.buffer[this.out++] & 0xFF;
                    break block3;
                }
                this.log("error at LeadPipeInputStream.read():  " + iOException.getMessage(), 2);
            }
        }
        return n;
    }

    public synchronized void setBufferSize(int n) {
        if (n > this.buffer.length) {
            byte[] byArray = new byte[n];
            if (this.in >= 0) {
                if (this.in > this.out) {
                    System.arraycopy(this.buffer, this.out, byArray, this.out, this.in - this.out);
                } else {
                    int n2 = this.buffer.length - this.out;
                    System.arraycopy(this.buffer, this.out, byArray, 0, n2);
                    System.arraycopy(this.buffer, 0, byArray, n2, this.in);
                    this.in += n2;
                    this.out = 0;
                }
            }
            this.buffer = byArray;
        }
    }

    public void setManagingTask(Task task) {
        this.managingTask = task;
    }

    public void log(String string, int n) {
        if (this.managingTask != null) {
            this.managingTask.log(string, n);
        } else if (n > 1) {
            System.out.println(string);
        } else {
            System.err.println(string);
        }
    }
}

