/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.tools.ant.BuildException;

public class ScriptRunner {
    private String language;
    private String script = "";
    private Map beans = new HashMap();

    public void addBeans(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Object v = map.get(string);
                this.addBean(string, v);
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
    }

    public void addBean(String string, Object object) {
        boolean bl = string.length() > 0 && Character.isJavaIdentifierStart(string.charAt(0));
        int n = 1;
        while (bl && n < string.length()) {
            bl = Character.isJavaIdentifierPart(string.charAt(n));
            ++n;
        }
        if (bl) {
            this.beans.put(string, object);
        }
    }

    public void executeScript(String string) throws BuildException {
        if (this.language == null) {
            throw new BuildException("script language must be specified");
        }
        try {
            BSFManager bSFManager = new BSFManager();
            Iterator iterator = this.beans.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object v = this.beans.get(string2);
                if (v != null) {
                    bSFManager.declareBean(string2, v, v.getClass());
                    continue;
                }
                bSFManager.undeclareBean(string2);
            }
            bSFManager.exec(this.language, string, 0, 0, (Object)this.script);
        }
        catch (BSFException bSFException) {
            Throwable throwable = bSFException;
            Throwable throwable2 = bSFException.getTargetException();
            if (throwable2 != null) {
                if (throwable2 instanceof BuildException) {
                    throw (BuildException)throwable2;
                }
                throwable = throwable2;
            }
            throw new BuildException(throwable);
        }
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setSrc(File file) {
        if (!file.exists()) {
            throw new BuildException("file " + file.getPath() + " not found.");
        }
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
        this.script = this.script + new String(byArray);
    }

    public void addText(String string) {
        this.script = this.script + string;
    }

    static {
        BSFManager.registerScriptingEngine((String)"groovy", (String)"org.codehaus.groovy.bsf.GroovyEngine", (String[])new String[]{"groovy", "gy"});
    }
}

