/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.mail;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.mail.ErrorInQuitException;
import org.apache.tools.mail.MailPrintStream;
import org.apache.tools.mail.SmtpResponseReader;

public class MailMessage {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 25;
    private String host;
    private int port = 25;
    private String from;
    private Vector replyto;
    private Vector to;
    private Vector cc;
    private Vector headersKeys;
    private Vector headersValues;
    private MailPrintStream out;
    private SmtpResponseReader in;
    private Socket socket;
    private static final int OK_READY = 220;
    private static final int OK_HELO = 250;
    private static final int OK_FROM = 250;
    private static final int OK_RCPT_1 = 250;
    private static final int OK_RCPT_2 = 251;
    private static final int OK_DATA = 354;
    private static final int OK_DOT = 250;
    private static final int OK_QUIT = 221;

    public MailMessage() throws IOException {
        this(DEFAULT_HOST, 25);
    }

    public MailMessage(String string) throws IOException {
        this(string, 25);
    }

    public MailMessage(String string, int n) throws IOException {
        this.port = n;
        this.host = string;
        this.replyto = new Vector();
        this.to = new Vector();
        this.cc = new Vector();
        this.headersKeys = new Vector();
        this.headersValues = new Vector();
        this.connect();
        this.sendHelo();
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void from(String string) throws IOException {
        this.sendFrom(string);
        this.from = string;
    }

    public void replyto(String string) {
        this.replyto.addElement(string);
    }

    public void to(String string) throws IOException {
        this.sendRcpt(string);
        this.to.addElement(string);
    }

    public void cc(String string) throws IOException {
        this.sendRcpt(string);
        this.cc.addElement(string);
    }

    public void bcc(String string) throws IOException {
        this.sendRcpt(string);
    }

    public void setSubject(String string) {
        this.setHeader("Subject", string);
    }

    public void setHeader(String string, String string2) {
        this.headersKeys.add(string);
        this.headersValues.add(string2);
    }

    public PrintStream getPrintStream() throws IOException {
        this.setFromHeader();
        this.setReplyToHeader();
        this.setToHeader();
        this.setCcHeader();
        this.setHeader("X-Mailer", "org.apache.tools.mail.MailMessage (ant.apache.org)");
        this.sendData();
        this.flushHeaders();
        return this.out;
    }

    void setFromHeader() {
        this.setHeader("From", this.from);
    }

    void setReplyToHeader() {
        if (!this.replyto.isEmpty()) {
            this.setHeader("Reply-To", this.vectorToList(this.replyto));
        }
    }

    void setToHeader() {
        if (!this.to.isEmpty()) {
            this.setHeader("To", this.vectorToList(this.to));
        }
    }

    void setCcHeader() {
        if (!this.cc.isEmpty()) {
            this.setHeader("Cc", this.vectorToList(this.cc));
        }
    }

    String vectorToList(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    void flushHeaders() throws IOException {
        int n = 0;
        while (n < this.headersKeys.size()) {
            String string = (String)this.headersKeys.elementAt(n);
            String string2 = (String)this.headersValues.elementAt(n);
            this.out.println(string + ": " + string2);
            ++n;
        }
        this.out.println();
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndClose() throws IOException {
        try {
            this.sendDot();
            this.sendQuit();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.disconnect();
            throw throwable;
        }
        this.disconnect();
    }

    static String sanitizeAddress(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            char c = string.charAt(n5);
            if (c == '(') {
                ++n;
                if (n2 == 0) {
                    n3 = n5;
                }
            } else if (c == ')') {
                --n;
                if (n3 == 0) {
                    n2 = n5 + 1;
                }
            } else if (n == 0 && c == '<') {
                n2 = n5 + 1;
            } else if (n == 0 && c == '>') {
                n3 = n5;
            }
            ++n5;
        }
        if (n3 == 0) {
            n3 = n4;
        }
        return string.substring(n2, n3);
    }

    void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.out = new MailPrintStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.in = new SmtpResponseReader(this.socket.getInputStream());
        this.getReady();
    }

    void getReady() throws IOException {
        String string = this.in.getResponse();
        int[] nArray = new int[]{220};
        if (!this.isResponseOK(string, nArray)) {
            throw new IOException("Didn't get introduction from server: " + string);
        }
    }

    void sendHelo() throws IOException {
        String string = InetAddress.getLocalHost().getHostName();
        int[] nArray = new int[]{250};
        this.send("HELO " + string, nArray);
    }

    void sendFrom(String string) throws IOException {
        int[] nArray = new int[]{250};
        this.send("MAIL FROM: <" + MailMessage.sanitizeAddress(string) + ">", nArray);
    }

    void sendRcpt(String string) throws IOException {
        int[] nArray = new int[]{250, 251};
        this.send("RCPT TO: <" + MailMessage.sanitizeAddress(string) + ">", nArray);
    }

    void sendData() throws IOException {
        int[] nArray = new int[]{354};
        this.send("DATA", nArray);
    }

    void sendDot() throws IOException {
        int[] nArray = new int[]{250};
        this.send("\r\n.", nArray);
    }

    void sendQuit() throws IOException {
        int[] nArray = new int[]{221};
        try {
            this.send("QUIT", nArray);
        }
        catch (IOException iOException) {
            throw new ErrorInQuitException(iOException);
        }
    }

    void send(String string, int[] nArray) throws IOException {
        this.out.rawPrint(string + "\r\n");
        String string2 = this.in.getResponse();
        if (!this.isResponseOK(string2, nArray)) {
            throw new IOException("Unexpected reply to command: " + string + ": " + string2);
        }
    }

    boolean isResponseOK(String string, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (string.startsWith("" + nArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void disconnect() throws IOException {
        block6: {
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.socket == null) break block6;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

