/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.NativeLibraryClient;
import java.io.File;
import java.io.UnsupportedEncodingException;

public class ShellLink
implements NativeLibraryClient {
    public static final int HIDE = 0;
    public static final int NORMAL = 1;
    public static final int MINIMIZED = 2;
    public static final int MAXIMIZED = 3;
    public static final int MINNOACTIVE = 7;
    private static final int MIN_SHOW = 0;
    private static final int MAX_SHOW = 7;
    public static final int DESKTOP = 1;
    public static final int PROGRAM_MENU = 2;
    public static final int START_MENU = 3;
    public static final int STARTUP = 4;
    private static final int MIN_TYPE = 1;
    private static final int MAX_TYPE = 4;
    private static final int SL_OK = 1;
    private static final int SL_ERROR = -1;
    private static final int SL_INITIALIZED = -2;
    private static final int SL_NOT_INITIALIZED = -3;
    private static final int SL_OUT_OF_HANDLES = -4;
    private static final int SL_NO_IPERSIST = -5;
    private static final int SL_NO_SAVE = -6;
    private static final int SL_WRONG_DATA_TYPE = -7;
    private static final int UNINITIALIZED = -1;
    private static final String LINK_EXTENSION = ".lnk";
    public static final int CURRENT_USER = 0;
    public static final int ALL_USERS = 1;
    private int nativeHandle = -1;
    private String currentUserLinkPath;
    private String allUsersLinkPath;
    private String groupName = "";
    private String linkName = "";
    private String linkFileName = "";
    private String linkDirectory = "";
    private String arguments = "";
    private String description = "";
    private String iconPath = "";
    private String targetPath = "";
    private String workingDirectory = "";
    private String dummyString = "";
    private int hotkey = 0;
    private int iconIndex = 0;
    private int showCommand = 1;
    private int linkType = 1;
    private int userType = 0;
    private boolean initializeSucceeded = false;

    private native int initializeCOM();

    private native int releaseCOM();

    private native int getInterface();

    private native int releaseInterface();

    private native int GetArguments();

    private native int GetDescription();

    private native int GetHotkey();

    private native int GetIconLocation();

    private native int GetPath();

    private native int GetShowCommand();

    private native int GetWorkingDirectory();

    private native int Resolve();

    private native int SetArguments();

    private native int SetDescription();

    private native int SetHotkey();

    private native int SetIconLocation();

    private native int SetPath();

    private native int SetShowCommand();

    private native int SetWorkingDirectory();

    private native int saveLink(String var1);

    private native int loadLink(String var1);

    private native int GetFullLinkPath(int var1, int var2);

    private native void FreeLibrary(String var1);

    public ShellLink(int n, String string) throws Exception, IllegalArgumentException {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("the type parameter used an illegal value");
        }
        if (string == null) {
            throw new IllegalArgumentException("the name parameter was null");
        }
        this.linkName = string;
        this.linkType = n;
        this.initialize();
        this.setAllLinkPaths();
    }

    public ShellLink(String string, int n) throws Exception, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("the name parameter was null");
        }
        this.userType = n;
        this.initialize();
        int n2 = string.lastIndexOf(File.separator);
        int n3 = n2 + 1;
        int n4 = string.lastIndexOf(46);
        if (n4 < 0) {
            throw new Exception("illegal file name");
        }
        this.linkName = string.substring(n3, n4);
        if (n == 0) {
            this.currentUserLinkPath = string.substring(0, n2);
        } else {
            this.allUsersLinkPath = string.substring(0, n2);
        }
        this.linkFileName = this.fullLinkName(n);
        if (this.loadLink(this.linkFileName) != 1) {
            throw new Exception("reading of the file did not succeed");
        }
        this.get();
    }

    public ShellLink(int n, int n2, String string, String string2) throws Exception, IllegalArgumentException {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("the type parameter used an illegal value");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("the name parameter was null");
        }
        this.userType = n2;
        this.initialize();
        this.setAllLinkPaths();
        if (string != null) {
            this.groupName = string;
        }
        this.linkName = string2;
        this.linkFileName = this.fullLinkName(n2);
        if (this.loadLink(this.linkFileName) != 1) {
            throw new Exception("reading of the file did not succeed");
        }
        this.get();
    }

    private void initialize() throws Exception {
        try {
            Librarian.getInstance().loadLibrary("ShellLink", this);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Exception("could not locate native library");
        }
        try {
            if (this.initializeCOM() != 1) {
                throw new Exception("could not initialize COM");
            }
            this.initializeSucceeded = true;
        }
        catch (Throwable throwable) {
            throw new Exception("unidentified problem initializing COM\n" + throwable.toString());
        }
        int n = this.getInterface();
        if (n != 1) {
            this.releaseCOM();
            this.initializeSucceeded = false;
            if (n == -4) {
                throw new Exception("could not get an instance of IShellLink, no more handles available");
            }
            throw new Exception("could not get an instance of IShellLink, failed to co-create instance");
        }
    }

    protected void finalize() throws Throwable {
        this.releaseInterface();
        if (this.initializeSucceeded) {
            this.releaseCOM();
            this.initializeSucceeded = false;
        }
        super.finalize();
    }

    public void freeLibrary(String string) {
        int n = this.releaseInterface();
        if (this.initializeSucceeded) {
            n = this.releaseCOM();
            this.initializeSucceeded = false;
        }
        this.FreeLibrary(string);
    }

    private String fullLinkPath(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            stringBuffer.append(this.currentUserLinkPath);
        } else {
            stringBuffer.append(this.allUsersLinkPath);
        }
        if (this.groupName != null && this.groupName.length() > 0) {
            stringBuffer.append(File.separator);
            stringBuffer.append(this.groupName);
        }
        return stringBuffer.toString();
    }

    private String fullLinkName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fullLinkPath(n));
        stringBuffer.append(File.separator);
        stringBuffer.append(this.linkName);
        stringBuffer.append(LINK_EXTENSION);
        return stringBuffer.toString();
    }

    private void set() throws Exception {
        if (this.SetArguments() != 1) {
            throw new Exception("could not set arguments");
        }
        if (this.SetDescription() != 1) {
            throw new Exception("could not set description");
        }
        if (this.SetHotkey() != 1) {
            throw new Exception("could not set hotkey");
        }
        if (this.SetIconLocation() != 1) {
            throw new Exception("could not set icon location");
        }
        if (this.SetPath() != 1) {
            throw new Exception("could not set target path");
        }
        if (this.SetShowCommand() != 1) {
            throw new Exception("could not set show command");
        }
        if (this.SetWorkingDirectory() != 1) {
            throw new Exception("could not set working directory");
        }
    }

    private void get() throws Exception {
        if (this.GetArguments() != 1) {
            throw new Exception("could not get arguments");
        }
        if (this.GetDescription() != 1) {
            throw new Exception("could not get description");
        }
        if (this.GetHotkey() != 1) {
            throw new Exception("could not get hotkey");
        }
        if (this.GetIconLocation() != 1) {
            throw new Exception("could not get icon location");
        }
        if (this.GetPath() != 1) {
            throw new Exception("could not get target ath");
        }
        if (this.GetShowCommand() != 1) {
            throw new Exception("could not get show command");
        }
        if (this.GetWorkingDirectory() != 1) {
            throw new Exception("could not get working directory");
        }
    }

    public void setProgramGroup(String string) {
        this.groupName = string;
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setHotkey(int n) {
        this.hotkey = n;
    }

    public void setIconLocation(String string, int n) {
        this.iconPath = string;
        this.iconIndex = n;
    }

    public void setTargetPath(String string) {
        this.targetPath = string;
    }

    public void setShowCommand(int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("illegal value for show command " + n);
        }
        this.showCommand = n;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public void setLinkName(String string) {
        this.linkName = string;
    }

    public void setLinkType(int n) throws IllegalArgumentException, UnsupportedEncodingException {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("illegal value for type");
        }
        this.linkType = n;
        this.setAllLinkPaths();
    }

    public int getLinkType() {
        return this.linkType;
    }

    public void setUserType(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(n + " is not a recognized user type");
        }
        this.userType = n;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getLinkPath(int n) {
        String string = null;
        string = n == 0 ? this.currentUserLinkPath : this.allUsersLinkPath;
        return string;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return this.description;
    }

    public int getHotkey() {
        return this.hotkey;
    }

    public String getIconLocation() {
        return this.iconPath;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public int getShowCommand() {
        return this.showCommand;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getFileName() {
        return this.linkFileName;
    }

    public String getDirectoryCreated() {
        return this.linkDirectory;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String getcurrentUserLinkPath() {
        return this.currentUserLinkPath;
    }

    public String getallUsersLinkPath() {
        return this.allUsersLinkPath;
    }

    public void save() throws Exception {
        this.set();
        int n = this.Resolve();
        if (n != 1) {
            throw new Exception("cannot resolve target");
        }
        File file = new File(this.fullLinkPath(this.userType));
        if (!file.exists()) {
            file.mkdirs();
            this.linkDirectory = file.getPath();
        } else {
            this.linkDirectory = "";
        }
        String string = this.fullLinkName(this.userType);
        n = this.saveLink(string);
        if (n == -5) {
            throw new Exception("could not get handle for IPesist");
        }
        if (n == -6) {
            throw new Exception("the save operation failed");
        }
        this.linkFileName = string;
    }

    public void save(String string) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("name was null");
        }
        this.set();
        if (this.Resolve() != 1) {
            throw new Exception("cannot resolve target");
        }
        File file = new File(string.substring(0, string.lastIndexOf(File.separatorChar)));
        if (!file.exists()) {
            file.mkdirs();
            this.linkDirectory = file.getPath();
        } else {
            this.linkDirectory = null;
        }
        if (this.saveLink(string) != 1) {
            throw new Exception("the save operation failed");
        }
        this.linkFileName = string;
    }

    private void setAllLinkPaths() throws IllegalArgumentException {
        this.currentUserLinkPath = "";
        this.allUsersLinkPath = "";
        this.GetFullLinkPath(0, this.linkType);
        this.GetFullLinkPath(1, this.linkType);
        if (this.userType == 0 && this.currentUserLinkPath.length() == 0) {
            this.userType = 1;
        } else if (this.userType == 1 && this.allUsersLinkPath.length() == 0) {
            this.userType = 0;
        }
        if (this.allUsersLinkPath.length() == 0 && this.currentUserLinkPath.length() == 0) {
            throw new IllegalArgumentException("linkType " + this.linkType + " is invalid.");
        }
    }
}

