/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.util.Stack;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdXMLBuilder
implements IXMLBuilder {
    private Stack<XMLElement> stack = null;
    private XMLElement root = null;

    protected XMLElement getCurrentElement() {
        return this.stack.peek();
    }

    protected Stack<XMLElement> getStack() {
        return this.stack;
    }

    protected void setRootElement(XMLElement xMLElement) {
        this.stack.clear();
        this.stack.push(xMLElement);
        this.root = xMLElement;
    }

    protected void finalize() throws Throwable {
        this.root = null;
        this.stack.clear();
        this.stack = null;
        super.finalize();
    }

    @Override
    public void startBuilding(String string, int n) {
        this.stack = new Stack();
        this.root = null;
    }

    @Override
    public void newProcessingInstruction(String string, Reader reader) {
    }

    @Override
    public void startElement(String string, String string2, String string3, String string4, int n) {
        XMLElement xMLElement = new XMLElement(string, string4, n);
        if (this.stack.empty()) {
            this.root = xMLElement;
        } else {
            XMLElement xMLElement2 = this.stack.peek();
            xMLElement2.addChild(xMLElement);
        }
        this.stack.push(xMLElement);
    }

    @Override
    public void elementAttributesProcessed(String string, String string2, String string3) {
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        XMLElement xMLElement;
        XMLElement xMLElement2 = this.stack.pop();
        if (xMLElement2.getChildrenCount() == 1 && (xMLElement = xMLElement2.getChildAtIndex(0)).getName() == null) {
            xMLElement2.setContent(xMLElement.getContent());
            xMLElement2.removeChildAtIndex(0);
        }
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws Exception {
        XMLElement xMLElement = this.stack.peek();
        if (xMLElement.hasAttribute(string)) {
            throw new XMLParseException(xMLElement.getSystemID(), xMLElement.getLineNr(), "Duplicate attribute: " + string);
        }
        xMLElement.setAttribute(string, string4);
    }

    @Override
    public void addPCData(Reader reader, String string, int n) throws Exception {
        int n2 = 2048;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[n2];
        while (true) {
            int n4;
            if (n3 >= n2) {
                stringBuffer.ensureCapacity(n2 *= 2);
            }
            if ((n4 = reader.read(cArray)) < 0) break;
            stringBuffer.append(cArray, 0, n4);
            n3 += n4;
        }
        XMLElement xMLElement = new XMLElement(null, string, n);
        xMLElement.setContent(stringBuffer.toString());
        if (!this.stack.empty()) {
            XMLElement xMLElement2 = this.stack.peek();
            xMLElement2.addChild(xMLElement);
        }
    }

    @Override
    public Object getResult() {
        return this.root;
    }
}

