/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.TypeAdapter;

public class AntTypeDefinition {
    private String name;
    private Class clazz;
    private Class adapterClass;
    private Class adaptToClass;
    private String className;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setClass(Class clazz) {
        this.clazz = clazz;
        if (clazz == null) {
            return;
        }
        if (this.classLoader == null) {
            this.classLoader = clazz.getClassLoader();
        }
        if (this.className == null) {
            this.className = clazz.getName();
        }
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setAdapterClass(Class clazz) {
        this.adapterClass = clazz;
    }

    public void setAdaptToClass(Class clazz) {
        this.adaptToClass = clazz;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getExposedClass(Project project) {
        if (this.adaptToClass != null) {
            Class clazz = this.getTypeClass(project);
            if (clazz == null) {
                return null;
            }
            if (this.adaptToClass.isAssignableFrom(clazz)) {
                return clazz;
            }
        }
        if (this.adapterClass != null) {
            return this.adapterClass;
        }
        return this.getTypeClass(project);
    }

    public Class getTypeClass(Project project) {
        block5: {
            if (this.clazz != null) {
                return this.clazz;
            }
            try {
                if (this.classLoader == null) {
                    this.clazz = Class.forName(this.className);
                    break block5;
                }
                this.clazz = this.classLoader.loadClass(this.className);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                project.log("Could not load a dependent class (" + noClassDefFoundError.getMessage() + ") for type " + this.name, 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                project.log("Could not load class (" + this.className + ") for type " + this.name, 4);
            }
        }
        return this.clazz;
    }

    public Object create(Project project) {
        return this.icreate(project);
    }

    private Object icreate(Project project) {
        Class clazz = this.getTypeClass(project);
        if (clazz == null) {
            return null;
        }
        Object object = this.createAndSet(project, clazz);
        if (object == null || this.adapterClass == null) {
            return object;
        }
        if (this.adaptToClass != null && this.adaptToClass.isAssignableFrom(object.getClass())) {
            return object;
        }
        TypeAdapter typeAdapter = (TypeAdapter)this.createAndSet(project, this.adapterClass);
        if (typeAdapter == null) {
            return null;
        }
        typeAdapter.setProxy(object);
        return typeAdapter;
    }

    public void checkClass(Project project) {
        if (this.clazz == null) {
            this.clazz = this.getTypeClass(project);
            if (this.clazz == null) {
                throw new BuildException("Unable to create class for " + this.getName());
            }
        }
        if (this.adapterClass != null) {
            boolean bl = true;
            if (this.adaptToClass != null && this.adaptToClass.isAssignableFrom(this.clazz)) {
                bl = false;
            }
            if (bl) {
                TypeAdapter typeAdapter = (TypeAdapter)this.createAndSet(project, this.adapterClass);
                if (typeAdapter == null) {
                    throw new BuildException("Unable to create adapter object");
                }
                typeAdapter.checkProxyClass(this.clazz);
            }
        }
    }

    private Object createAndSet(Project project, Class clazz) {
        try {
            Constructor constructor = null;
            boolean bl = false;
            try {
                constructor = clazz.getConstructor(new Class[0]);
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = clazz.getConstructor(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = AntTypeDefinition.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                bl = false;
            }
            Object var5_9 = null;
            var5_9 = bl ? constructor.newInstance(new Object[0]) : constructor.newInstance(project);
            project.setProjectReference(var5_9);
            return var5_9;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new BuildException("Could not create type " + this.name + " due to " + throwable, throwable);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = "Type " + this.name + ": A class needed by class " + clazz + " cannot be found: " + noClassDefFoundError.getMessage();
            throw new BuildException(string, noClassDefFoundError);
        }
        catch (Throwable throwable) {
            throw new BuildException("Could not create type " + this.name + " due to " + throwable, throwable);
        }
    }

    public boolean sameDefinition(AntTypeDefinition antTypeDefinition, Project project) {
        if (antTypeDefinition == null) {
            return false;
        }
        if (antTypeDefinition.getClass() != this.getClass()) {
            return false;
        }
        if (!antTypeDefinition.getTypeClass(project).equals(this.getTypeClass(project))) {
            return false;
        }
        if (!antTypeDefinition.getExposedClass(project).equals(this.getExposedClass(project))) {
            return false;
        }
        if (antTypeDefinition.adapterClass != this.adapterClass) {
            return false;
        }
        return antTypeDefinition.adaptToClass == this.adaptToClass;
    }

    public boolean similarDefinition(AntTypeDefinition antTypeDefinition, Project project) {
        if (antTypeDefinition == null) {
            return false;
        }
        if (this.getClass() != antTypeDefinition.getClass()) {
            return false;
        }
        if (!this.getClassName().equals(antTypeDefinition.getClassName())) {
            return false;
        }
        if (!this.extractClassname(this.adapterClass).equals(this.extractClassname(antTypeDefinition.adapterClass))) {
            return false;
        }
        if (!this.extractClassname(this.adaptToClass).equals(this.extractClassname(antTypeDefinition.adaptToClass))) {
            return false;
        }
        ClassLoader classLoader = antTypeDefinition.getClassLoader();
        ClassLoader classLoader2 = this.getClassLoader();
        return classLoader2 != null && classLoader != null && classLoader instanceof AntClassLoader && classLoader2 instanceof AntClassLoader && ((AntClassLoader)classLoader).getClasspath().equals(((AntClassLoader)classLoader2).getClasspath());
    }

    private String extractClassname(Class clazz) {
        if (clazz == null) {
            return "<null>";
        }
        return clazz.getClass().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

