/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.types.Description;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.StringUtils;

public class Project {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    private static final String ANTCLASSLOADER_JDK12 = "org.apache.tools.ant.loader.AntClassLoader2";
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String TOKEN_START = "@";
    public static final String TOKEN_END = "@";
    private String name;
    private String description;
    private Hashtable references = new AntRefTable(this);
    private String defaultTarget;
    private Hashtable targets = new Hashtable();
    private FilterSet globalFilterSet = new FilterSet();
    private FilterSetCollection globalFilters;
    private File baseDir;
    private Vector listeners;
    private ClassLoader coreLoader;
    private Hashtable threadTasks;
    private Hashtable threadGroupTasks;
    private InputHandler inputHandler;
    private InputStream defaultInputStream;
    private boolean keepGoingMode;
    private FileUtils fileUtils;
    private boolean loggingMessage;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public void setDefaultInputStream(InputStream inputStream) {
        this.defaultInputStream = inputStream;
    }

    public InputStream getDefaultInputStream() {
        return this.defaultInputStream;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public Project() {
        this.globalFilterSet.setProject(this);
        this.globalFilters = new FilterSetCollection(this.globalFilterSet);
        this.listeners = new Vector();
        this.coreLoader = null;
        this.threadTasks = new Hashtable();
        this.threadGroupTasks = new Hashtable();
        this.inputHandler = null;
        this.defaultInputStream = null;
        this.keepGoingMode = false;
        this.loggingMessage = false;
        this.fileUtils = FileUtils.newFileUtils();
        this.inputHandler = new DefaultInputHandler();
    }

    public void initSubProject(Project project) {
        ComponentHelper.getComponentHelper(project).initSubProject(ComponentHelper.getComponentHelper(this));
        project.setKeepGoingMode(this.isKeepGoingMode());
    }

    public void init() throws BuildException {
        this.setJavaVersionProperty();
        ComponentHelper.getComponentHelper(this).initDefaultDefinitions();
        this.setSystemProperties();
    }

    private AntClassLoader createClassLoader() {
        AntClassLoader antClassLoader = null;
        if (!JavaEnvUtils.isJavaVersion(JAVA_1_1)) {
            try {
                Class<?> clazz = Class.forName(ANTCLASSLOADER_JDK12);
                antClassLoader = (AntClassLoader)clazz.newInstance();
            }
            catch (Exception exception) {
                this.log("Unable to create Class Loader: " + exception.getMessage(), 4);
            }
        }
        if (antClassLoader == null) {
            antClassLoader = new AntClassLoader();
        }
        antClassLoader.setProject(this);
        return antClassLoader;
    }

    public AntClassLoader createClassLoader(Path path) {
        AntClassLoader antClassLoader = this.createClassLoader();
        antClassLoader.setClassPath(path);
        return antClassLoader;
    }

    public void setCoreLoader(ClassLoader classLoader) {
        this.coreLoader = classLoader;
    }

    public ClassLoader getCoreLoader() {
        return this.coreLoader;
    }

    public synchronized void addBuildListener(BuildListener buildListener) {
        Vector vector = this.getBuildListeners();
        vector.addElement(buildListener);
        this.listeners = vector;
    }

    public synchronized void removeBuildListener(BuildListener buildListener) {
        Vector vector = this.getBuildListeners();
        vector.removeElement(buildListener);
        this.listeners = vector;
    }

    public Vector getBuildListeners() {
        return (Vector)this.listeners.clone();
    }

    public void log(String string) {
        this.log(string, 2);
    }

    public void log(String string, int n) {
        this.fireMessageLogged(this, string, n);
    }

    public void log(Task task, String string, int n) {
        this.fireMessageLogged(task, string, n);
    }

    public void log(Target target, String string, int n) {
        this.fireMessageLogged(target, string, n);
    }

    public FilterSet getGlobalFilterSet() {
        return this.globalFilterSet;
    }

    public void setProperty(String string, String string2) {
        PropertyHelper.getPropertyHelper(this).setProperty(null, string, string2, true);
    }

    public void setNewProperty(String string, String string2) {
        PropertyHelper.getPropertyHelper(this).setNewProperty(null, string, string2);
    }

    public void setUserProperty(String string, String string2) {
        PropertyHelper.getPropertyHelper(this).setUserProperty(null, string, string2);
    }

    public void setInheritedProperty(String string, String string2) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        propertyHelper.setInheritedProperty(null, string, string2);
    }

    private void setPropertyInternal(String string, String string2) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        propertyHelper.setProperty(null, string, string2, false);
    }

    public String getProperty(String string) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return (String)propertyHelper.getProperty(null, string);
    }

    public String replaceProperties(String string) throws BuildException {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return propertyHelper.replaceProperties(null, string, null);
    }

    public String getUserProperty(String string) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return (String)propertyHelper.getUserProperty(null, string);
    }

    public Hashtable getProperties() {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return propertyHelper.getProperties();
    }

    public Hashtable getUserProperties() {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return propertyHelper.getUserProperties();
    }

    public void copyUserProperties(Project project) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        propertyHelper.copyUserProperties(project);
    }

    public void copyInheritedProperties(Project project) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        propertyHelper.copyInheritedProperties(project);
    }

    public void setDefaultTarget(String string) {
        this.defaultTarget = string;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefault(String string) {
        this.defaultTarget = string;
    }

    public void setName(String string) {
        this.setUserProperty("ant.project.name", string);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Description.getDescription(this);
        }
        return this.description;
    }

    public void addFilter(String string, String string2) {
        if (string == null) {
            return;
        }
        this.globalFilterSet.addFilter(new FilterSet.Filter(string, string2));
    }

    public Hashtable getFilters() {
        return this.globalFilterSet.getFilterHash();
    }

    public void setBasedir(String string) throws BuildException {
        this.setBaseDir(new File(string));
    }

    public void setBaseDir(File file) throws BuildException {
        if (!(file = this.fileUtils.normalize(file.getAbsolutePath())).exists()) {
            throw new BuildException("Basedir " + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new BuildException("Basedir " + file.getAbsolutePath() + " is not a directory");
        }
        this.baseDir = file;
        this.setPropertyInternal("basedir", this.baseDir.getPath());
        String string = "Project base dir set to: " + this.baseDir;
        this.log(string, 3);
    }

    public File getBaseDir() {
        block2: {
            if (this.baseDir != null) break block2;
            try {
                this.setBasedir(".");
            }
            catch (BuildException buildException) {
                buildException.printStackTrace();
            }
        }
        return this.baseDir;
    }

    public void setKeepGoingMode(boolean bl) {
        this.keepGoingMode = bl;
    }

    public boolean isKeepGoingMode() {
        return this.keepGoingMode;
    }

    public static String getJavaVersion() {
        return JavaEnvUtils.getJavaVersion();
    }

    public void setJavaVersionProperty() throws BuildException {
        String string = JavaEnvUtils.getJavaVersion();
        this.setPropertyInternal("ant.java.version", string);
        if (JavaEnvUtils.isJavaVersion(JAVA_1_0)) {
            throw new BuildException("Ant cannot work on Java 1.0");
        }
        this.log("Detected Java version: " + string + " in: " + System.getProperty("java.home"), 3);
        this.log("Detected OS: " + System.getProperty("os.name"), 3);
    }

    public void setSystemProperties() {
        Properties properties = System.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            String string = properties.get(object).toString();
            this.setPropertyInternal(object.toString(), string);
        }
    }

    public void addTaskDefinition(String string, Class clazz) throws BuildException {
        ComponentHelper.getComponentHelper(this).addTaskDefinition(string, clazz);
    }

    public void checkTaskClass(Class clazz) throws BuildException {
        ComponentHelper.getComponentHelper(this).checkTaskClass(clazz);
        if (!Modifier.isPublic(clazz.getModifiers())) {
            String string = clazz + " is not public";
            this.log(string, 0);
            throw new BuildException(string);
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            String string = clazz + " is abstract";
            this.log(string, 0);
            throw new BuildException(string);
        }
        try {
            clazz.getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "No public no-arg constructor in " + clazz;
            this.log(string, 0);
            throw new BuildException(string);
        }
        catch (LinkageError linkageError) {
            String string = "Could not load " + clazz + ": " + linkageError;
            this.log(string, 0);
            throw new BuildException(string, linkageError);
        }
        if (!(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = Project.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(clazz)) {
            TaskAdapter.checkTaskClass(clazz, this);
        }
    }

    public Hashtable getTaskDefinitions() {
        return ComponentHelper.getComponentHelper(this).getTaskDefinitions();
    }

    public void addDataTypeDefinition(String string, Class clazz) {
        ComponentHelper.getComponentHelper(this).addDataTypeDefinition(string, clazz);
    }

    public Hashtable getDataTypeDefinitions() {
        return ComponentHelper.getComponentHelper(this).getDataTypeDefinitions();
    }

    public void addTarget(Target target) throws BuildException {
        this.addTarget(target.getName(), target);
    }

    public void addTarget(String string, Target target) throws BuildException {
        if (this.targets.get(string) != null) {
            throw new BuildException("Duplicate target: `" + string + "'");
        }
        this.addOrReplaceTarget(string, target);
    }

    public void addOrReplaceTarget(Target target) {
        this.addOrReplaceTarget(target.getName(), target);
    }

    public void addOrReplaceTarget(String string, Target target) {
        String string2 = " +Target: " + string;
        this.log(string2, 4);
        target.setProject(this);
        this.targets.put(string, target);
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Task createTask(String string) throws BuildException {
        return ComponentHelper.getComponentHelper(this).createTask(string);
    }

    public Object createDataType(String string) throws BuildException {
        return ComponentHelper.getComponentHelper(this).createDataType(string);
    }

    public void executeTargets(Vector vector) throws BuildException {
        BuildException buildException = null;
        int n = 0;
        while (n < vector.size()) {
            try {
                this.executeTarget((String)vector.elementAt(n));
            }
            catch (BuildException buildException2) {
                if (!this.keepGoingMode) {
                    throw buildException2;
                }
                buildException = buildException2;
            }
            ++n;
        }
        if (buildException != null) {
            throw buildException;
        }
    }

    public void demuxOutput(String string, boolean bl) {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            this.log(string, bl ? 1 : 2);
        } else if (bl) {
            task.handleErrorOutput(string);
        } else {
            task.handleOutput(string);
        }
    }

    public int defaultInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.defaultInputStream != null) {
            System.out.flush();
            return this.defaultInputStream.read(byArray, n, n2);
        }
        throw new EOFException("No input provided for project");
    }

    public int demuxInput(byte[] byArray, int n, int n2) throws IOException {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            return this.defaultInput(byArray, n, n2);
        }
        return task.handleInput(byArray, n, n2);
    }

    public void demuxFlush(String string, boolean bl) {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            this.fireMessageLogged(this, string, bl ? 0 : 2);
        } else if (bl) {
            task.handleErrorFlush(string);
        } else {
            task.handleFlush(string);
        }
    }

    public void executeTarget(String string) throws BuildException {
        if (string == null) {
            String string2 = "No target specified";
            throw new BuildException(string2);
        }
        Vector vector = this.topoSort(string, this.targets);
        HashSet<String> hashSet = new HashSet<String>();
        BuildException buildException = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Target target = (Target)enumeration.nextElement();
            boolean bl = true;
            Enumeration enumeration2 = target.getDependencies();
            while (enumeration2.hasMoreElements()) {
                object = (String)enumeration2.nextElement();
                if (hashSet.contains(object)) continue;
                bl = false;
                this.log(target, "Cannot execute '" + target.getName() + "' - '" + (String)object + "' failed or was not executed.", 0);
                break;
            }
            if (bl) {
                object = null;
                try {
                    target.performTasks();
                    hashSet.add(target.getName());
                }
                catch (RuntimeException runtimeException) {
                    if (!this.keepGoingMode) {
                        throw runtimeException;
                    }
                    object = runtimeException;
                }
                catch (Throwable throwable) {
                    if (!this.keepGoingMode) {
                        throw new BuildException(throwable);
                    }
                    object = throwable;
                }
                if (object != null) {
                    if (object instanceof BuildException) {
                        this.log(target, "Target '" + target.getName() + "' failed with message '" + ((Throwable)object).getMessage() + "'.", 0);
                        if (buildException == null) {
                            buildException = (BuildException)object;
                        }
                    } else {
                        this.log(target, "Target '" + target.getName() + "' failed with message '" + ((Throwable)object).getMessage() + "'.", 0);
                        ((Throwable)object).printStackTrace(System.err);
                        if (buildException == null) {
                            buildException = new BuildException((Throwable)object);
                        }
                    }
                }
            }
            if (target.getName().equals(string)) break;
        }
        if (buildException != null) {
            throw buildException;
        }
    }

    public File resolveFile(String string, File file) {
        return this.fileUtils.resolveFile(file, string);
    }

    public File resolveFile(String string) {
        return this.fileUtils.resolveFile(this.baseDir, string);
    }

    public static String translatePath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        while (pathTokenizer.hasMoreTokens()) {
            String string2 = pathTokenizer.nextToken();
            string2 = string2.replace('/', File.separatorChar);
            string2 = string2.replace('\\', File.separatorChar);
            if (stringBuffer.length() != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void copyFile(String string, String string2) throws IOException {
        this.fileUtils.copyFile(string, string2);
    }

    public void copyFile(String string, String string2, boolean bl) throws IOException {
        this.fileUtils.copyFile(string, string2, bl ? this.globalFilters : null);
    }

    public void copyFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        this.fileUtils.copyFile(string, string2, bl ? this.globalFilters : null, bl2);
    }

    public void copyFile(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.fileUtils.copyFile(string, string2, bl ? this.globalFilters : null, bl2, bl3);
    }

    public void copyFile(File file, File file2) throws IOException {
        this.fileUtils.copyFile(file, file2);
    }

    public void copyFile(File file, File file2, boolean bl) throws IOException {
        this.fileUtils.copyFile(file, file2, bl ? this.globalFilters : null);
    }

    public void copyFile(File file, File file2, boolean bl, boolean bl2) throws IOException {
        this.fileUtils.copyFile(file, file2, bl ? this.globalFilters : null, bl2);
    }

    public void copyFile(File file, File file2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.fileUtils.copyFile(file, file2, bl ? this.globalFilters : null, bl2, bl3);
    }

    public void setFileLastModified(File file, long l) throws BuildException {
        if (JavaEnvUtils.isJavaVersion(JAVA_1_1)) {
            this.log("Cannot change the modification time of " + file + " in JDK 1.1", 1);
            return;
        }
        this.fileUtils.setFileLastModified(file, l);
        this.log("Setting modification time for " + file, 3);
    }

    public static boolean toBoolean(String string) {
        return "on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string);
    }

    public final Vector topoSort(String string, Hashtable hashtable) throws BuildException {
        Vector vector = new Vector();
        Hashtable hashtable2 = new Hashtable();
        Stack stack = new Stack();
        this.tsort(string, hashtable, hashtable2, stack, vector);
        this.log("Build sequence for target `" + string + "' is " + vector, 3);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable2.get(string2);
            if (string3 == null) {
                this.tsort(string2, hashtable, hashtable2, stack, vector);
                continue;
            }
            if (string3 != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + string2);
        }
        this.log("Complete build sequence is " + vector, 3);
        return vector;
    }

    private final void tsort(String string, Hashtable hashtable, Hashtable hashtable2, Stack stack, Vector vector) throws BuildException {
        String string2;
        hashtable2.put(string, VISITING);
        stack.push(string);
        Target target = (Target)hashtable.get(string);
        if (target == null) {
            StringBuffer stringBuffer = new StringBuffer("Target `");
            stringBuffer.append(string);
            stringBuffer.append("' does not exist in this project. ");
            stack.pop();
            if (!stack.empty()) {
                String string3 = (String)stack.peek();
                stringBuffer.append("It is used from target `");
                stringBuffer.append(string3);
                stringBuffer.append("'.");
            }
            throw new BuildException(new String(stringBuffer));
        }
        Enumeration enumeration = target.getDependencies();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            String string4 = (String)hashtable2.get(string2);
            if (string4 == null) {
                this.tsort(string2, hashtable, hashtable2, stack, vector);
                continue;
            }
            if (string4 != VISITING) continue;
            throw Project.makeCircularException(string2, stack);
        }
        string2 = (String)stack.pop();
        if (string != string2) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + string + " but got " + string2);
        }
        hashtable2.put(string, VISITED);
        vector.addElement(target);
    }

    private static BuildException makeCircularException(String string, Stack stack) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("Circular dependency: ");
        stringBuffer.append(string);
        do {
            string2 = (String)stack.pop();
            stringBuffer.append(" <- ");
            stringBuffer.append(string2);
        } while (!string2.equals(string));
        return new BuildException(new String(stringBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(String string, Object object) {
        Hashtable hashtable = this.references;
        synchronized (hashtable) {
            Object object2 = ((AntRefTable)this.references).getReal(string);
            if (object2 == object) {
                return;
            }
            if (object2 != null && !(object2 instanceof UnknownElement)) {
                this.log("Overriding previous definition of reference to " + string, 1);
            }
            this.log("Adding reference: " + string, 4);
            this.references.put(string, object);
        }
    }

    public Hashtable getReferences() {
        return this.references;
    }

    public Object getReference(String string) {
        return this.references.get(string);
    }

    public String getElementName(Object object) {
        return ComponentHelper.getComponentHelper(this).getElementName(object);
    }

    public void fireBuildStarted() {
        BuildEvent buildEvent = new BuildEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            BuildListener buildListener = (BuildListener)iterator.next();
            buildListener.buildStarted(buildEvent);
        }
    }

    public void fireBuildFinished(Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(this);
        buildEvent.setException(throwable);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            BuildListener buildListener = (BuildListener)iterator.next();
            buildListener.buildFinished(buildEvent);
        }
    }

    public void fireSubBuildStarted() {
        BuildEvent buildEvent = new BuildEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SubBuildListener)) continue;
            ((SubBuildListener)e).subBuildStarted(buildEvent);
        }
    }

    public void fireSubBuildFinished(Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(this);
        buildEvent.setException(throwable);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SubBuildListener)) continue;
            ((SubBuildListener)e).subBuildFinished(buildEvent);
        }
    }

    protected void fireTargetStarted(Target target) {
        BuildEvent buildEvent = new BuildEvent(target);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            BuildListener buildListener = (BuildListener)iterator.next();
            buildListener.targetStarted(buildEvent);
        }
    }

    protected void fireTargetFinished(Target target, Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(target);
        buildEvent.setException(throwable);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            BuildListener buildListener = (BuildListener)iterator.next();
            buildListener.targetFinished(buildEvent);
        }
    }

    protected void fireTaskStarted(Task task) {
        this.registerThreadTask(Thread.currentThread(), task);
        BuildEvent buildEvent = new BuildEvent(task);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            BuildListener buildListener = (BuildListener)iterator.next();
            buildListener.taskStarted(buildEvent);
        }
    }

    protected void fireTaskFinished(Task task, Throwable throwable) {
        this.registerThreadTask(Thread.currentThread(), null);
        System.out.flush();
        System.err.flush();
        BuildEvent buildEvent = new BuildEvent(task);
        buildEvent.setException(throwable);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            BuildListener buildListener = (BuildListener)iterator.next();
            buildListener.taskFinished(buildEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageLoggedEvent(BuildEvent buildEvent, String string, int n) {
        if (string.endsWith(StringUtils.LINE_SEP)) {
            int n2 = string.length() - StringUtils.LINE_SEP.length();
            buildEvent.setMessage(string.substring(0, n2), n);
        } else {
            buildEvent.setMessage(string, n);
        }
        Project project = this;
        synchronized (project) {
            if (this.loggingMessage) {
                throw new BuildException("Listener attempted to access " + (n == 0 ? "System.err" : "System.out") + " - infinite loop terminated");
            }
            try {
                this.loggingMessage = true;
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    BuildListener buildListener = (BuildListener)iterator.next();
                    buildListener.messageLogged(buildEvent);
                }
                Object var8_8 = null;
                this.loggingMessage = false;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.loggingMessage = false;
                throw throwable;
            }
        }
    }

    protected void fireMessageLogged(Project project, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(project);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    protected void fireMessageLogged(Target target, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(target);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    protected void fireMessageLogged(Task task, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(task);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    public synchronized void registerThreadTask(Thread thread, Task task) {
        if (task != null) {
            this.threadTasks.put(thread, task);
            this.threadGroupTasks.put(thread.getThreadGroup(), task);
        } else {
            this.threadTasks.remove(thread);
            this.threadGroupTasks.remove(thread.getThreadGroup());
        }
    }

    public Task getThreadTask(Thread thread) {
        Task task = (Task)this.threadTasks.get(thread);
        if (task == null) {
            ThreadGroup threadGroup = thread.getThreadGroup();
            while (task == null && threadGroup != null) {
                task = (Task)this.threadGroupTasks.get(threadGroup);
                threadGroup = threadGroup.getParent();
            }
        }
        return task;
    }

    public final void setProjectReference(Object object) {
        if (object instanceof ProjectComponent) {
            ((ProjectComponent)object).setProject(this);
            return;
        }
        try {
            Method method = object.getClass().getMethod("setProject", class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = Project.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
            if (method != null) {
                method.invoke(object, this);
            }
        }
        catch (Throwable throwable) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AntRefTable
    extends Hashtable {
        private Project project;

        public AntRefTable(Project project) {
            this.project = project;
        }

        public Object getReal(Object object) {
            return super.get(object);
        }

        public Object get(Object object) {
            Object object2 = super.get(object);
            if (object2 instanceof UnknownElement) {
                UnknownElement unknownElement = (UnknownElement)object2;
                unknownElement.maybeConfigure();
                object2 = unknownElement.getRealThing();
            }
            return object2;
        }
    }
}

