/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.taskdefs.PreSetDef;

public class UnknownElement
extends Task {
    private String elementName;
    private String namespace;
    private String qname;
    private Object realThing;
    private List children = null;
    private boolean presetDefed = false;

    public UnknownElement(String string) {
        this.elementName = string;
    }

    public List getChildren() {
        return this.children;
    }

    public String getTag() {
        return this.elementName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        if (string.equals("ant:current")) {
            ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.getProject());
            string = componentHelper.getCurrentAntlibUri();
        }
        this.namespace = string;
    }

    public String getQName() {
        return this.qname;
    }

    public void setQName(String string) {
        this.qname = string;
    }

    public RuntimeConfigurable getWrapper() {
        return super.getWrapper();
    }

    public void maybeConfigure() throws BuildException {
        this.configure(this.makeObject(this, this.getWrapper()));
    }

    public void configure(Object object) {
        this.realThing = object;
        this.getWrapper().setProxy(this.realThing);
        Task task = null;
        if (this.realThing instanceof Task) {
            task = (Task)this.realThing;
            task.setRuntimeConfigurableWrapper(this.getWrapper());
            this.getOwningTarget().replaceChild((Task)this, (Task)this.realThing);
        }
        this.handleChildren(this.realThing, this.getWrapper());
        if (task != null) {
            task.maybeConfigure();
        } else {
            this.getWrapper().maybeConfigure(this.getProject());
        }
    }

    protected void handleOutput(String string) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleOutput(string);
        } else {
            super.handleOutput(string);
        }
    }

    protected int handleInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.realThing instanceof Task) {
            return ((Task)this.realThing).handleInput(byArray, n, n2);
        }
        return super.handleInput(byArray, n, n2);
    }

    protected void handleFlush(String string) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleFlush(string);
        } else {
            super.handleFlush(string);
        }
    }

    protected void handleErrorOutput(String string) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleErrorOutput(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    protected void handleErrorFlush(String string) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleErrorOutput(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    public void execute() {
        if (this.realThing == null) {
            throw new BuildException("Could not create task of type: " + this.elementName, this.getLocation());
        }
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).execute();
        }
        this.realThing = null;
    }

    public void addChild(UnknownElement unknownElement) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(unknownElement);
    }

    protected void handleChildren(Object object, RuntimeConfigurable runtimeConfigurable) throws BuildException {
        if (object instanceof TypeAdapter) {
            object = ((TypeAdapter)object).getProxy();
        }
        String string = this.getNamespace();
        Class<?> clazz = object.getClass();
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(clazz);
        if (this.children != null) {
            Iterator iterator = this.children.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                RuntimeConfigurable runtimeConfigurable2 = runtimeConfigurable.getChild(n);
                UnknownElement unknownElement = (UnknownElement)iterator.next();
                if (!this.handleChild(string, introspectionHelper, object, unknownElement, runtimeConfigurable2)) {
                    if (!(object instanceof TaskContainer)) {
                        introspectionHelper.throwNotSupported(this.getProject(), object, unknownElement.getTag());
                    } else {
                        TaskContainer taskContainer = (TaskContainer)object;
                        taskContainer.addTask(unknownElement);
                    }
                }
                ++n;
            }
        }
    }

    protected String getComponentName() {
        return ProjectHelper.genComponentName(this.getNamespace(), this.getTag());
    }

    public void applyPreSet(UnknownElement unknownElement) {
        if (this.presetDefed) {
            return;
        }
        this.getWrapper().applyPreSet(unknownElement.getWrapper());
        if (unknownElement.children != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(unknownElement.children);
            if (this.children != null) {
                arrayList.addAll(this.children);
            }
            this.children = arrayList;
        }
        this.presetDefed = true;
    }

    protected Object makeObject(UnknownElement unknownElement, RuntimeConfigurable runtimeConfigurable) {
        Object object;
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.getProject());
        String string = unknownElement.getComponentName();
        Object object2 = componentHelper.createComponent(unknownElement, unknownElement.getNamespace(), string);
        if (object2 == null) {
            throw this.getNotFoundException("task or type", string);
        }
        if (object2 instanceof PreSetDef.PreSetDefinition) {
            object = (PreSetDef.PreSetDefinition)object2;
            object2 = ((PreSetDef.PreSetDefinition)object).createObject(unknownElement.getProject());
            unknownElement.applyPreSet(((PreSetDef.PreSetDefinition)object).getPreSets());
            if (object2 instanceof Task) {
                Task task = (Task)object2;
                task.setTaskType(unknownElement.getTaskType());
                task.setTaskName(unknownElement.getTaskName());
            }
        }
        if (object2 instanceof Task) {
            object = (Task)object2;
            ((Task)object).setOwningTarget(this.getOwningTarget());
            ((Task)object).init();
        }
        return object2;
    }

    protected Task makeTask(UnknownElement unknownElement, RuntimeConfigurable runtimeConfigurable) {
        Task task = this.getProject().createTask(unknownElement.getTag());
        if (task != null) {
            task.setLocation(this.getLocation());
            task.setOwningTarget(this.getOwningTarget());
            task.init();
        }
        return task;
    }

    protected BuildException getNotFoundException(String string, String string2) {
        String string3 = System.getProperty("line.separator");
        String string4 = "Could not create " + string + " of type: " + string2 + "." + string3 + string3 + "Ant could not find the task or a class this " + "task relies upon." + string3 + string3 + "This is common and has a number of causes; the usual " + string3 + "solutions are to read the manual pages then download and" + string3 + "install needed JAR files, or fix the build file: " + string3 + " - You have misspelt '" + string2 + "'." + string3 + "   Fix: check your spelling." + string3 + " - The task needs an external JAR file to execute" + string3 + "     and this is not found at the right place in the classpath." + string3 + "   Fix: check the documentation for dependencies." + string3 + "   Fix: declare the task." + string3 + " - The task is an Ant optional task and the JAR file and/or libraries" + string3 + "     implementing the functionality were not found at the time you" + string3 + "     yourself built your installation of Ant from the Ant sources." + string3 + "   Fix: Look in the ANT_HOME/lib for the 'ant-' JAR corresponding to the" + string3 + "     task and make sure it contains more than merely a META-INF/MANIFEST.MF." + string3 + "     If all it contains is the manifest, then rebuild Ant with the needed" + string3 + "     libraries present in ${ant.home}/lib/optional/ , or alternatively," + string3 + "     download a pre-built release version from apache.org" + string3 + " - The build file was written for a later version of Ant" + string3 + "   Fix: upgrade to at least the latest release version of Ant" + string3 + " - The task is not an Ant core or optional task " + string3 + "     and needs to be declared using <taskdef>." + string3 + " - You are attempting to use a task defined using " + string3 + "    <presetdef> or <macrodef> but have spelt wrong or not " + string3 + "   defined it at the point of use" + string3 + string3 + "Remember that for JAR files to be visible to Ant tasks implemented" + string3 + "in ANT_HOME/lib, the files must be in the same directory or on the" + string3 + "classpath" + string3 + string3 + "Please neither file bug reports on this problem, nor email the" + string3 + "Ant mailing lists, until all of these causes have been explored," + string3 + "as this is not an Ant bug.";
        return new BuildException(string4, this.getLocation());
    }

    public String getTaskName() {
        return this.realThing == null || !(this.realThing instanceof Task) ? super.getTaskName() : ((Task)this.realThing).getTaskName();
    }

    public Task getTask() {
        if (this.realThing instanceof Task) {
            return (Task)this.realThing;
        }
        return null;
    }

    public Object getRealThing() {
        return this.realThing;
    }

    private boolean handleChild(String string, IntrospectionHelper introspectionHelper, Object object, UnknownElement unknownElement, RuntimeConfigurable runtimeConfigurable) {
        String string2 = ProjectHelper.genComponentName(unknownElement.getNamespace(), unknownElement.getTag());
        if (introspectionHelper.supportsNestedElement(string, string2)) {
            Object object2;
            IntrospectionHelper.Creator creator = introspectionHelper.getElementCreator(this.getProject(), string, object, string2, unknownElement);
            creator.setPolyType(runtimeConfigurable.getPolyType());
            Object object3 = creator.create();
            if (object3 instanceof PreSetDef.PreSetDefinition) {
                object2 = (PreSetDef.PreSetDefinition)object3;
                object3 = creator.getRealObject();
                unknownElement.applyPreSet(((PreSetDef.PreSetDefinition)object2).getPreSets());
            }
            runtimeConfigurable.setCreator(creator);
            runtimeConfigurable.setProxy(object3);
            if (object3 instanceof Task) {
                object2 = (Task)object3;
                ((Task)object2).setRuntimeConfigurableWrapper(runtimeConfigurable);
                ((Task)object2).setTaskName(string2);
                ((Task)object2).setTaskType(string2);
                ((Task)object2).setLocation(unknownElement.getLocation());
            }
            unknownElement.handleChildren(object3, runtimeConfigurable);
            return true;
        }
        return false;
    }

    public boolean similar(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().getName().equals(object.getClass().getName())) {
            return false;
        }
        UnknownElement unknownElement = (UnknownElement)object;
        if (!this.equalsString(this.elementName, unknownElement.elementName)) {
            return false;
        }
        if (!this.namespace.equals(unknownElement.namespace)) {
            return false;
        }
        if (!this.qname.equals(unknownElement.qname)) {
            return false;
        }
        if (!this.getWrapper().getAttributeMap().equals(unknownElement.getWrapper().getAttributeMap())) {
            return false;
        }
        if (!this.getWrapper().getText().toString().equals(unknownElement.getWrapper().getText().toString())) {
            return false;
        }
        if (this.children == null || this.children.size() == 0) {
            return unknownElement.children == null || unknownElement.children.size() == 0;
        }
        if (unknownElement.children == null) {
            return false;
        }
        if (this.children.size() != unknownElement.children.size()) {
            return false;
        }
        int n = 0;
        while (n < this.children.size()) {
            UnknownElement unknownElement2 = (UnknownElement)this.children.get(n);
            if (!unknownElement2.similar(unknownElement.children.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean equalsString(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }
}

