/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.FileUtils;

public abstract class BaseFilterReader
extends FilterReader {
    private static final int BUFFER_SIZE = 8192;
    private boolean initialized = false;
    private Project project = null;

    public BaseFilterReader() {
        super(new StringReader(new String()));
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public BaseFilterReader(Reader reader) {
        super(reader);
    }

    public final int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            cArray[n + n3] = (char)n4;
            ++n3;
        }
        return n2;
    }

    public final long skip(long l) throws IOException, IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        long l2 = 0L;
        while (l2 < l) {
            if (this.read() == -1) {
                return l2;
            }
            ++l2;
        }
        return l;
    }

    protected final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    protected final boolean getInitialized() {
        return this.initialized;
    }

    public final void setProject(Project project) {
        this.project = project;
    }

    protected final Project getProject() {
        return this.project;
    }

    protected final String readLine() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n != -1) {
            stringBuffer.append((char)n);
            if (n == 10) break;
            n = this.in.read();
        }
        return stringBuffer.toString();
    }

    protected final String readFully() throws IOException {
        return FileUtils.readFully(this.in, 8192);
    }
}

