/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class ConcatFilter
extends BaseParamFilterReader
implements ChainableReader {
    private File prepend;
    private File append;
    private Reader prependReader = null;
    private Reader appendReader = null;

    public ConcatFilter() {
    }

    public ConcatFilter(Reader reader) {
        super(reader);
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.prependReader != null && (n = this.prependReader.read()) == -1) {
            this.prependReader.close();
            this.prependReader = null;
        }
        if (n == -1) {
            n = super.read();
        }
        if (n == -1 && this.appendReader != null && (n = this.appendReader.read()) == -1) {
            this.appendReader.close();
            this.appendReader = null;
        }
        return n;
    }

    public void setPrepend(File file) {
        this.prepend = file;
    }

    public File getPrepend() {
        return this.prepend;
    }

    public void setAppend(File file) {
        this.append = file;
    }

    public File getAppend() {
        return this.append;
    }

    public Reader chain(Reader reader) {
        ConcatFilter concatFilter = new ConcatFilter(reader);
        concatFilter.setPrepend(this.getPrepend());
        concatFilter.setAppend(this.getAppend());
        return concatFilter;
    }

    private void initialize() throws IOException {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                if ("prepend".equals(parameterArray[n].getName())) {
                    this.setPrepend(new File(parameterArray[n].getValue()));
                } else if ("append".equals(parameterArray[n].getName())) {
                    this.setAppend(new File(parameterArray[n].getValue()));
                }
                ++n;
            }
        }
        if (this.prepend != null) {
            if (!this.prepend.isAbsolute()) {
                this.prepend = new File(this.getProject().getBaseDir(), this.prepend.getPath());
            }
            this.prependReader = new BufferedReader(new FileReader(this.prepend));
        }
        if (this.append != null) {
            if (!this.append.isAbsolute()) {
                this.append = new File(this.getProject().getBaseDir(), this.append.getPath());
            }
            this.appendReader = new BufferedReader(new FileReader(this.append));
        }
    }
}

