/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class ReplaceTokens
extends BaseParamFilterReader
implements ChainableReader {
    private static final char DEFAULT_BEGIN_TOKEN = '@';
    private static final char DEFAULT_END_TOKEN = '@';
    private String queuedData = null;
    private String replaceData = null;
    private int replaceIndex = -1;
    private int queueIndex = -1;
    private Hashtable hash = new Hashtable();
    private char beginToken = (char)64;
    private char endToken = (char)64;

    public ReplaceTokens() {
    }

    public ReplaceTokens(Reader reader) {
        super(reader);
    }

    private int getNextChar() throws IOException {
        if (this.queueIndex != -1) {
            char c = this.queuedData.charAt(this.queueIndex++);
            if (this.queueIndex >= this.queuedData.length()) {
                this.queueIndex = -1;
            }
            return c;
        }
        return this.in.read();
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        if (this.replaceIndex != -1) {
            char c = this.replaceData.charAt(this.replaceIndex++);
            if (this.replaceIndex >= this.replaceData.length()) {
                this.replaceIndex = -1;
            }
            return c;
        }
        int n = this.getNextChar();
        if (n == this.beginToken) {
            StringBuffer stringBuffer = new StringBuffer("");
            while ((n = this.getNextChar()) != -1) {
                stringBuffer.append((char)n);
                if (n != this.endToken) continue;
            }
            if (n == -1) {
                this.queuedData = this.queuedData == null || this.queueIndex == -1 ? stringBuffer.toString() : stringBuffer.toString() + this.queuedData.substring(this.queueIndex);
                this.queueIndex = 0;
                return this.beginToken;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            String string = (String)this.hash.get(stringBuffer.toString());
            if (string != null) {
                if (string.length() > 0) {
                    this.replaceData = string;
                    this.replaceIndex = 0;
                }
                return this.read();
            }
            String string2 = stringBuffer.toString() + this.endToken;
            this.queuedData = this.queuedData == null || this.queueIndex == -1 ? string2 : string2 + this.queuedData.substring(this.queueIndex);
            this.queueIndex = 0;
            return this.beginToken;
        }
        return n;
    }

    public final void setBeginToken(char c) {
        this.beginToken = c;
    }

    private final char getBeginToken() {
        return this.beginToken;
    }

    public final void setEndToken(char c) {
        this.endToken = c;
    }

    private final char getEndToken() {
        return this.endToken;
    }

    public final void addConfiguredToken(Token token) {
        this.hash.put(token.getKey(), token.getValue());
    }

    private void setTokens(Hashtable hashtable) {
        this.hash = hashtable;
    }

    private final Hashtable getTokens() {
        return this.hash;
    }

    public final Reader chain(Reader reader) {
        ReplaceTokens replaceTokens = new ReplaceTokens(reader);
        replaceTokens.setBeginToken(this.getBeginToken());
        replaceTokens.setEndToken(this.getEndToken());
        replaceTokens.setTokens(this.getTokens());
        replaceTokens.setInitialized(true);
        return replaceTokens;
    }

    private final void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                if (parameterArray[n] != null) {
                    String string;
                    String string2;
                    String string3 = parameterArray[n].getType();
                    if ("tokenchar".equals(string3)) {
                        string2 = parameterArray[n].getName();
                        string = parameterArray[n].getValue();
                        if ("begintoken".equals(string2)) {
                            if (string.length() == 0) {
                                throw new BuildException("Begin token cannot be empty");
                            }
                            this.beginToken = parameterArray[n].getValue().charAt(0);
                        } else if ("endtoken".equals(string2)) {
                            if (string.length() == 0) {
                                throw new BuildException("End token cannot be empty");
                            }
                            this.endToken = parameterArray[n].getValue().charAt(0);
                        }
                    } else if ("token".equals(string3)) {
                        string2 = parameterArray[n].getName();
                        string = parameterArray[n].getValue();
                        this.hash.put(string2, string);
                    }
                }
                ++n;
            }
        }
    }

    public static class Token {
        private String key;
        private String value;

        public final void setKey(String string) {
            this.key = string;
        }

        public final void setValue(String string) {
            this.value = string;
        }

        public final String getKey() {
            return this.key;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

