/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class StripLineBreaks
extends BaseParamFilterReader
implements ChainableReader {
    private static final String DEFAULT_LINE_BREAKS = "\r\n";
    private static final String LINE_BREAKS_KEY = "linebreaks";
    private String lineBreaks = "\r\n";

    public StripLineBreaks() {
    }

    public StripLineBreaks(Reader reader) {
        super(reader);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = this.in.read();
        while (n != -1) {
            if (this.lineBreaks.indexOf(n) == -1) break;
            n = this.in.read();
        }
        return n;
    }

    public final void setLineBreaks(String string) {
        this.lineBreaks = string;
    }

    private final String getLineBreaks() {
        return this.lineBreaks;
    }

    public final Reader chain(Reader reader) {
        StripLineBreaks stripLineBreaks = new StripLineBreaks(reader);
        stripLineBreaks.setLineBreaks(this.getLineBreaks());
        stripLineBreaks.setInitialized(true);
        return stripLineBreaks;
    }

    private final void initialize() {
        String string = null;
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                if (LINE_BREAKS_KEY.equals(parameterArray[n].getName())) {
                    string = parameterArray[n].getValue();
                    break;
                }
                ++n;
            }
        }
        if (string != null) {
            this.lineBreaks = string;
        }
    }
}

