/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public final class JavaClassHelper {
    private static final String LS = System.getProperty("line.separator");

    public static final StringBuffer getConstants(byte[] byArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ClassParser classParser = new ClassParser((InputStream)byteArrayInputStream, "");
        JavaClass javaClass = classParser.parse();
        Field[] fieldArray = javaClass.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            ConstantValue constantValue;
            Field field = fieldArray[n];
            if (field != null && (constantValue = field.getConstantValue()) != null) {
                String string = constantValue.toString();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                stringBuffer.append(field.getName());
                stringBuffer.append('=');
                stringBuffer.append(string);
                stringBuffer.append(LS);
            }
            ++n;
        }
        return stringBuffer;
    }
}

