/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.input;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;

public class PropertyFileInputHandler
implements InputHandler {
    private Properties props = null;
    public static final String FILE_NAME_KEY = "ant.input.properties";

    public void handleInput(InputRequest inputRequest) throws BuildException {
        this.readProps();
        Object object = this.props.get(inputRequest.getPrompt());
        if (object == null) {
            throw new BuildException("Unable to find input for '" + inputRequest.getPrompt() + "'");
        }
        inputRequest.setInput(object.toString());
        if (!inputRequest.isInputValid()) {
            throw new BuildException("Found invalid input " + object + " for '" + inputRequest.getPrompt() + "'");
        }
    }

    private synchronized void readProps() throws BuildException {
        if (this.props == null) {
            String string = System.getProperty(FILE_NAME_KEY);
            if (string == null) {
                throw new BuildException("System property ant.input.properties for PropertyFileInputHandler not set");
            }
            this.props = new Properties();
            try {
                this.props.load(new FileInputStream(string));
            }
            catch (IOException iOException) {
                throw new BuildException("Couldn't load " + string, iOException);
            }
        }
    }
}

