/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.StringUtils;

public abstract class AbstractCvsTask
extends Task {
    public static final int DEFAULT_COMPRESSION_LEVEL = 3;
    private static final int MAXIMUM_COMRESSION_LEVEL = 9;
    private Commandline cmd = new Commandline();
    private Vector vecCommandlines = new Vector();
    private String cvsRoot;
    private String cvsRsh;
    private String cvsPackage;
    private String tag;
    private static final String DEFAULT_COMMAND = "checkout";
    private String command = null;
    private boolean quiet = false;
    private boolean reallyquiet = false;
    private int compression = 0;
    private boolean noexec = false;
    private int port = 0;
    private File passFile = null;
    private File dest;
    private boolean append = false;
    private File output;
    private File error;
    private boolean failOnError = false;
    private ExecuteStreamHandler executeStreamHandler;
    private OutputStream outputStream;
    private OutputStream errorStream;

    public void setExecuteStreamHandler(ExecuteStreamHandler executeStreamHandler) {
        this.executeStreamHandler = executeStreamHandler;
    }

    protected ExecuteStreamHandler getExecuteStreamHandler() {
        if (this.executeStreamHandler == null) {
            this.setExecuteStreamHandler(new PumpStreamHandler(this.getOutputStream(), this.getErrorStream()));
        }
        return this.executeStreamHandler;
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected OutputStream getOutputStream() {
        if (this.outputStream == null) {
            if (this.output != null) {
                try {
                    this.setOutputStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getPath(), this.append))));
                }
                catch (IOException iOException) {
                    throw new BuildException(iOException, this.getLocation());
                }
            } else {
                this.setOutputStream(new LogOutputStream(this, 2));
            }
        }
        return this.outputStream;
    }

    protected void setErrorStream(OutputStream outputStream) {
        this.errorStream = outputStream;
    }

    protected OutputStream getErrorStream() {
        if (this.errorStream == null) {
            if (this.error != null) {
                try {
                    this.setErrorStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(this.error.getPath(), this.append))));
                }
                catch (IOException iOException) {
                    throw new BuildException(iOException, this.getLocation());
                }
            } else {
                this.setErrorStream(new LogOutputStream(this, 1));
            }
        }
        return this.errorStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runCommand(Commandline commandline) throws BuildException {
        Object object;
        Environment environment = new Environment();
        if (this.port > 0) {
            object = new Environment.Variable();
            ((Environment.Variable)object).setKey("CVS_CLIENT_PORT");
            ((Environment.Variable)object).setValue(String.valueOf(this.port));
            environment.addVariable((Environment.Variable)object);
        }
        if (this.passFile == null && ((File)(object = new File(System.getProperty("cygwin.user.home", System.getProperty("user.home")) + File.separatorChar + ".cvspass"))).exists()) {
            this.setPassfile((File)object);
        }
        if (this.passFile != null) {
            if (this.passFile.isFile() && this.passFile.canRead()) {
                object = new Environment.Variable();
                ((Environment.Variable)object).setKey("CVS_PASSFILE");
                ((Environment.Variable)object).setValue(String.valueOf(this.passFile));
                environment.addVariable((Environment.Variable)object);
                this.log("Using cvs passfile: " + String.valueOf(this.passFile), 2);
            } else if (!this.passFile.canRead()) {
                this.log("cvs passfile: " + String.valueOf(this.passFile) + " ignored as it is not readable", 1);
            } else {
                this.log("cvs passfile: " + String.valueOf(this.passFile) + " ignored as it is not a file", 1);
            }
        }
        if (this.cvsRsh != null) {
            object = new Environment.Variable();
            ((Environment.Variable)object).setKey("CVS_RSH");
            ((Environment.Variable)object).setValue(String.valueOf(this.cvsRsh));
            environment.addVariable((Environment.Variable)object);
        }
        object = new Execute(this.getExecuteStreamHandler(), null);
        ((Execute)object).setAntRun(this.getProject());
        if (this.dest == null) {
            this.dest = this.getProject().getBaseDir();
        }
        if (!this.dest.exists()) {
            this.dest.mkdirs();
        }
        ((Execute)object).setWorkingDirectory(this.dest);
        ((Execute)object).setCommandline(commandline.getCommandline());
        ((Execute)object).setEnvironment(environment.getVariables());
        try {
            String string = this.executeToString((Execute)object);
            this.log(string, 3);
            int n = ((Execute)object).execute();
            this.log("retCode=" + n, 4);
            if (this.failOnError && Execute.isFailure(n)) {
                throw new BuildException("cvs exited with error code " + n + StringUtils.LINE_SEP + "Command line was [" + string + "]", this.getLocation());
            }
        }
        catch (IOException iOException) {
            if (this.failOnError) {
                throw new BuildException(iOException, this.getLocation());
            }
            this.log("Caught exception: " + iOException.getMessage(), 1);
        }
        catch (BuildException buildException) {
            if (this.failOnError) {
                throw buildException;
            }
            Throwable throwable = buildException.getException();
            if (throwable == null) {
                throwable = buildException;
            }
            this.log("Caught exception: " + throwable.getMessage(), 1);
        }
        catch (Exception exception) {
            if (this.failOnError) {
                throw new BuildException(exception, this.getLocation());
            }
            this.log("Caught exception: " + exception.getMessage(), 1);
        }
        finally {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.errorStream != null) {
                try {
                    this.errorStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        String string = this.getCommand();
        if (this.getCommand() == null && this.vecCommandlines.size() == 0) {
            this.setCommand(DEFAULT_COMMAND);
        }
        String string2 = this.getCommand();
        Commandline commandline = null;
        if (string2 != null) {
            commandline = (Commandline)this.cmd.clone();
            commandline.createArgument(true).setLine(string2);
            this.addConfiguredCommandline(commandline, true);
        }
        try {
            int n = 0;
            while (n < this.vecCommandlines.size()) {
                this.runCommand((Commandline)this.vecCommandlines.elementAt(n));
                ++n;
            }
            Object var6_5 = null;
            if (commandline != null) {
                this.removeCommandline(commandline);
            }
            this.setCommand(string);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (commandline != null) {
                this.removeCommandline(commandline);
            }
            this.setCommand(string);
            throw throwable;
        }
    }

    private String executeToString(Execute execute) {
        StringBuffer stringBuffer = new StringBuffer(Commandline.describeCommand(execute.getCommandline()));
        String string = StringUtils.LINE_SEP;
        String[] stringArray = execute.getEnvironment();
        if (stringArray != null) {
            stringBuffer.append(string);
            stringBuffer.append(string);
            stringBuffer.append("environment:");
            stringBuffer.append(string);
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(string);
                stringBuffer.append("\t");
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void setCvsRoot(String string) {
        if (string != null && string.trim().equals("")) {
            string = null;
        }
        this.cvsRoot = string;
    }

    public String getCvsRoot() {
        return this.cvsRoot;
    }

    public void setCvsRsh(String string) {
        if (string != null && string.trim().equals("")) {
            string = null;
        }
        this.cvsRsh = string;
    }

    public String getCvsRsh() {
        return this.cvsRsh;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setPassfile(File file) {
        this.passFile = file;
    }

    public File getPassFile() {
        return this.passFile;
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public File getDest() {
        return this.dest;
    }

    public void setPackage(String string) {
        this.cvsPackage = string;
    }

    public String getPackage() {
        return this.cvsPackage;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        if (string != null && string.trim().length() > 0) {
            this.tag = string;
            this.addCommandArgument("-r" + string);
        }
    }

    public void addCommandArgument(String string) {
        this.addCommandArgument(this.cmd, string);
    }

    public void addCommandArgument(Commandline commandline, String string) {
        commandline.createArgument().setValue(string);
    }

    public void setDate(String string) {
        if (string != null && string.trim().length() > 0) {
            this.addCommandArgument("-D");
            this.addCommandArgument(string);
        }
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public void setReallyquiet(boolean bl) {
        this.reallyquiet = bl;
    }

    public void setNoexec(boolean bl) {
        this.noexec = bl;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setError(File file) {
        this.error = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    protected void configureCommandline(Commandline commandline) {
        if (commandline == null) {
            return;
        }
        commandline.setExecutable("cvs");
        if (this.cvsPackage != null) {
            commandline.createArgument().setLine(this.cvsPackage);
        }
        if (this.compression > 0 && this.compression <= 9) {
            commandline.createArgument(true).setValue("-z" + this.compression);
        }
        if (this.quiet && !this.reallyquiet) {
            commandline.createArgument(true).setValue("-q");
        }
        if (this.reallyquiet) {
            commandline.createArgument(true).setValue("-Q");
        }
        if (this.noexec) {
            commandline.createArgument(true).setValue("-n");
        }
        if (this.cvsRoot != null) {
            commandline.createArgument(true).setLine("-d" + this.cvsRoot);
        }
    }

    protected void removeCommandline(Commandline commandline) {
        this.vecCommandlines.removeElement(commandline);
    }

    public void addConfiguredCommandline(Commandline commandline) {
        this.addConfiguredCommandline(commandline, false);
    }

    public void addConfiguredCommandline(Commandline commandline, boolean bl) {
        if (commandline == null) {
            return;
        }
        this.configureCommandline(commandline);
        if (bl) {
            this.vecCommandlines.insertElementAt(commandline, 0);
        } else {
            this.vecCommandlines.addElement(commandline);
        }
    }

    public void setCompressionLevel(int n) {
        this.compression = n;
    }

    public void setCompression(boolean bl) {
        this.setCompressionLevel(bl ? 3 : 0);
    }
}

