/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.FileUtils;

public class Ant
extends Task {
    private File dir = null;
    private String antFile = null;
    private String target = null;
    private String output = null;
    private boolean inheritAll = true;
    private boolean inheritRefs = false;
    private Vector properties = new Vector();
    private Vector references = new Vector();
    private Project newProject;
    private PrintStream out = null;
    private Vector propertySets = new Vector();
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setInheritAll(boolean bl) {
        this.inheritAll = bl;
    }

    public void setInheritRefs(boolean bl) {
        this.inheritRefs = bl;
    }

    public void init() {
        this.newProject = new Project();
        this.newProject.setDefaultInputStream(this.getProject().getDefaultInputStream());
        this.newProject.setJavaVersionProperty();
    }

    private void reinit() {
        this.init();
    }

    private void initializeProject() {
        Object object;
        Object object2;
        this.newProject.setInputHandler(this.getProject().getInputHandler());
        Iterator iterator = this.getBuildListeners();
        while (iterator.hasNext()) {
            this.newProject.addBuildListener((BuildListener)iterator.next());
        }
        if (this.output != null) {
            object2 = null;
            object2 = this.dir != null ? FileUtils.newFileUtils().resolveFile(this.dir, this.output) : this.getProject().resolveFile(this.output);
            try {
                this.out = new PrintStream(new FileOutputStream((File)object2));
                object = new DefaultLogger();
                ((DefaultLogger)object).setMessageOutputLevel(2);
                ((DefaultLogger)object).setOutputPrintStream(this.out);
                ((DefaultLogger)object).setErrorPrintStream(this.out);
                this.newProject.addBuildListener((BuildListener)object);
            }
            catch (IOException iOException) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        this.getProject().initSubProject(this.newProject);
        this.getProject().copyUserProperties(this.newProject);
        if (!this.inheritAll) {
            this.newProject.setSystemProperties();
        } else {
            this.addAlmostAll(this.getProject().getProperties());
        }
        object2 = this.propertySets.elements();
        while (object2.hasMoreElements()) {
            object = (PropertySet)object2.nextElement();
            this.addAlmostAll(((PropertySet)object).getProperties());
        }
    }

    public void handleOutput(String string) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(string, false);
        } else {
            super.handleOutput(string);
        }
    }

    public int handleInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.newProject != null) {
            return this.newProject.demuxInput(byArray, n, n2);
        }
        return super.handleInput(byArray, n, n2);
    }

    public void handleFlush(String string) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(string, false);
        } else {
            super.handleFlush(string);
        }
    }

    public void handleErrorOutput(String string) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(string, true);
        } else {
            super.handleErrorOutput(string);
        }
    }

    public void handleErrorFlush(String string) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(string, true);
        } else {
            super.handleErrorFlush(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        block30: {
            var1_1 = this.dir;
            var2_2 = this.antFile;
            var3_3 = this.target;
            try {
                if (this.newProject == null) {
                    this.reinit();
                }
                if (this.dir == null && this.inheritAll) {
                    this.dir = this.getProject().getBaseDir();
                }
                this.initializeProject();
                if (this.dir != null) {
                    this.newProject.setBaseDir(this.dir);
                    if (var1_1 != null) {
                        this.newProject.setInheritedProperty("basedir", this.dir.getAbsolutePath());
                    }
                } else {
                    this.dir = this.getProject().getBaseDir();
                }
                this.overrideProperties();
                if (this.antFile == null) {
                    this.antFile = "build.xml";
                }
                var4_4 = FileUtils.newFileUtils().resolveFile(this.dir, this.antFile);
                this.antFile = var4_4.getAbsolutePath();
                this.log("calling target " + (this.target != null ? this.target : "[default]") + " in build file " + this.antFile, 3);
                this.newProject.setUserProperty("ant.file", this.antFile);
                var5_5 = this.getProject().getProperty("ant.file");
                if (var5_5 != null && this.newProject.resolveFile(this.newProject.getProperty("ant.file")).equals(this.getProject().resolveFile((String)var5_5)) && this.getOwningTarget() != null && this.getOwningTarget().getName().equals("")) {
                    if (this.getTaskName().equals("antcall") == false) throw new BuildException(this.getTaskName() + " task at the" + " top level must not invoke" + " its own build file.");
                    throw new BuildException("antcall must not be used at the top level.");
                }
                try {
                    ProjectHelper.configureProject(this.newProject, new File(this.antFile));
                }
                catch (BuildException var6_7) {
                    throw ProjectHelper.addLocationToBuildException(var6_7, this.getLocation());
                }
                if (this.target == null) {
                    this.target = this.newProject.getDefaultTarget();
                }
                if (this.newProject.getProperty("ant.file").equals(this.getProject().getProperty("ant.file")) && this.getOwningTarget() != null) {
                    var6_8 = this.getOwningTarget().getName();
                    if (var6_8.equals(this.target)) {
                        throw new BuildException(this.getTaskName() + " task calling " + "its own parent target.");
                    }
                    var7_9 = (Target)this.getProject().getTargets().get(this.target);
                    if (var7_9 != null && var7_9.dependsOn((String)var6_8)) {
                        throw new BuildException(this.getTaskName() + " task calling a target" + " that depends on" + " its parent target '" + (String)var6_8 + "'.");
                    }
                }
                this.addReferences();
                if (this.target == null) {
                }
                if (!"".equals(this.target)) {
                    var6_8 = null;
                    try {
                        try {
                            this.log("Entering " + this.antFile + "...", 3);
                            this.newProject.fireSubBuildStarted();
                            this.newProject.executeTarget(this.target);
                        }
                        catch (BuildException var7_10) {
                            var6_8 = ProjectHelper.addLocationToBuildException(var7_10, this.getLocation());
                            throw (BuildException)var6_8;
                        }
lbl55:
                        // 1 sources

                        while (true) {
                        }
                        var9_11 = null;
                    }
                    catch (Throwable var8_13) {
                        var9_12 = null;
                        this.log("Exiting " + this.antFile + ".", 3);
                        this.newProject.fireSubBuildFinished((Throwable)var6_8);
                        throw var8_13;
                    }
                    this.log("Exiting " + this.antFile + ".", 3);
                    this.newProject.fireSubBuildFinished((Throwable)var6_8);
                    ** continue;
                }
            }
            finally {
                this.newProject = null;
                var4_4 = this.properties.elements();
            }
            while (true) {
                if (!var4_4.hasMoreElements()) {
                    if (this.output != null && this.out != null) {
                        ** try [egrp 4[TRYBLOCK] [4 : 779->789)] { 
lbl76:
                        // 1 sources

                        break;
                    }
                    break block30;
                }
                var5_5 = (Property)var4_4.nextElement();
                var5_5.setProject(null);
            }
            {
                this.out.close();
            }
lbl83:
            // 1 sources

            catch (Exception var5_6) {
                // empty catch block
            }
        }
        this.dir = var1_1;
        this.antFile = var2_2;
        this.target = var3_3;
    }

    private void overrideProperties() throws BuildException {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.properties.size() - 1;
        while (n >= 0) {
            object = (Property)this.properties.get(n);
            if (((Property)object).getName() != null && !((Property)object).getName().equals("")) {
                if (hashSet.contains(((Property)object).getName())) {
                    this.properties.remove(n);
                } else {
                    hashSet.add(((Property)object).getName());
                }
            }
            --n;
        }
        object = this.properties.elements();
        while (object.hasMoreElements()) {
            Property property = (Property)object.nextElement();
            property.setProject(this.newProject);
            property.execute();
        }
        this.getProject().copyInheritedProperties(this.newProject);
    }

    private void addReferences() throws BuildException {
        Object object;
        Enumeration<Object> enumeration;
        Hashtable hashtable = (Hashtable)this.getProject().getReferences().clone();
        Hashtable hashtable2 = this.newProject.getReferences();
        if (this.references.size() > 0) {
            enumeration = this.references.elements();
            while (enumeration.hasMoreElements()) {
                object = (Reference)enumeration.nextElement();
                String string = ((org.apache.tools.ant.types.Reference)object).getRefId();
                if (string == null) {
                    throw new BuildException("the refid attribute is required for reference elements");
                }
                if (!hashtable.containsKey(string)) {
                    this.log("Parent project doesn't contain any reference '" + string + "'", 1);
                    continue;
                }
                hashtable.remove(string);
                String string2 = ((Reference)object).getToRefid();
                if (string2 == null) {
                    string2 = string;
                }
                this.copyReference(string, string2);
            }
        }
        if (this.inheritRefs) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (hashtable2.containsKey(object)) continue;
                this.copyReference((String)object, (String)object);
            }
        }
    }

    private void copyReference(String string, String string2) {
        Method method;
        Object object = this.getProject().getReference(string);
        if (object == null) {
            this.log("No object referenced by " + string + ". Can't copy to " + string2, 1);
            return;
        }
        Class<?> clazz = object.getClass();
        Object object2 = object;
        try {
            method = clazz.getMethod("clone", new Class[0]);
            if (method != null) {
                object2 = method.invoke(object, new Object[0]);
                this.log("Adding clone of reference " + string, 4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object2 instanceof ProjectComponent) {
            ((ProjectComponent)object2).setProject(this.newProject);
        } else {
            try {
                method = clazz.getMethod("setProject", class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = Ant.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                if (method != null) {
                    method.invoke(object2, this.newProject);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                String string3 = "Error setting new project instance for reference with id " + string;
                throw new BuildException(string3, exception, this.getLocation());
            }
        }
        this.newProject.addReference(string2, object2);
    }

    private void addAlmostAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if ("basedir".equals(string) || "ant.file".equals(string)) continue;
            String string2 = hashtable.get(string).toString();
            if (this.newProject.getProperty(string) != null) continue;
            this.newProject.setNewProperty(string, string2);
        }
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setAntfile(String string) {
        this.antFile = string;
    }

    public void setTarget(String string) {
        if (string.equals("")) {
            throw new BuildException("target attribute must not be empty");
        }
        this.target = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public Property createProperty() {
        if (this.newProject == null) {
            this.reinit();
        }
        Property property = new Property(true, this.getProject());
        property.setProject(this.newProject);
        property.setTaskName("property");
        this.properties.addElement(property);
        return property;
    }

    public void addReference(Reference reference) {
        this.references.addElement(reference);
    }

    public void addPropertyset(PropertySet propertySet) {
        this.propertySets.addElement(propertySet);
    }

    private Iterator getBuildListeners() {
        return this.getProject().getBuildListeners().iterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Reference
    extends org.apache.tools.ant.types.Reference {
        private String targetid = null;

        public void setToRefid(String string) {
            this.targetid = string;
        }

        public String getToRefid() {
            return this.targetid;
        }
    }
}

