/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Available
extends Task
implements Condition {
    private String property;
    private String classname;
    private String file;
    private Path filepath;
    private String resource;
    private FileDir type;
    private Path classpath;
    private AntClassLoader loader;
    private String value = "true";
    private boolean isTask = false;
    private boolean ignoreSystemclasses = false;

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setFilepath(Path path) {
        this.createFilepath().append(path);
    }

    public Path createFilepath() {
        if (this.filepath == null) {
            this.filepath = new Path(this.getProject());
        }
        return this.filepath.createPath();
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setClassname(String string) {
        if (!"".equals(string)) {
            this.classname = string;
        }
    }

    public void setFile(File file) {
        this.file = FileUtils.newFileUtils().removeLeadingPath(this.getProject().getBaseDir(), file);
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public void setType(String string) {
        this.log("DEPRECATED - The setType(String) method has been deprecated. Use setType(Available.FileDir) instead.");
        this.type = new FileDir();
        this.type.setValue(string);
    }

    public void setType(FileDir fileDir) {
        this.type = fileDir;
    }

    public void setIgnoresystemclasses(boolean bl) {
        this.ignoreSystemclasses = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute is required", this.getLocation());
        }
        this.isTask = true;
        try {
            if (this.eval()) {
                String string = this.getProject().getProperty(this.property);
                if (null != string && !string.equals(this.value)) {
                    this.log("DEPRECATED - <available> used to override an existing property." + StringUtils.LINE_SEP + "  Build file should not reuse the same property" + " name for different values.");
                }
                this.getProject().setProperty(this.property, this.value);
            }
            Object var3_2 = null;
            this.isTask = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.isTask = false;
            throw throwable;
        }
    }

    public boolean eval() throws BuildException {
        if (this.classname == null && this.file == null && this.resource == null) {
            throw new BuildException("At least one of (classname|file|resource) is required", this.getLocation());
        }
        if (this.type != null && this.file == null) {
            throw new BuildException("The type attribute is only valid when specifying the file attribute.", this.getLocation());
        }
        if (this.classpath != null) {
            this.classpath.setProject(this.getProject());
            this.loader = this.getProject().createClassLoader(this.classpath);
        }
        String string = "";
        if (this.isTask) {
            string = " to set property " + this.property;
        } else {
            this.setTaskName("available");
        }
        if (this.classname != null && !this.checkClass(this.classname)) {
            this.log("Unable to load class " + this.classname + string, 3);
            return false;
        }
        if (this.file != null && !this.checkFile()) {
            if (this.type != null) {
                this.log("Unable to find " + this.type + " " + this.file + string, 3);
            } else {
                this.log("Unable to find " + this.file + string, 3);
            }
            return false;
        }
        if (this.resource != null && !this.checkResource(this.resource)) {
            this.log("Unable to load resource " + this.resource + string, 3);
            return false;
        }
        if (this.loader != null) {
            this.loader.cleanup();
            this.loader = null;
        }
        if (!this.isTask) {
            this.setTaskName(null);
        }
        return true;
    }

    private boolean checkFile() {
        if (this.filepath == null) {
            return this.checkFile(this.getProject().resolveFile(this.file), this.file);
        }
        String[] stringArray = this.filepath.list();
        int n = 0;
        while (n < stringArray.length) {
            File file;
            this.log("Searching " + stringArray[n], 4);
            File file2 = new File(stringArray[n]);
            if (file2.exists() && this.file.equals(stringArray[n])) {
                if (this.type == null) {
                    this.log("Found: " + file2, 3);
                    return true;
                }
                if (this.type.isDir() && file2.isDirectory()) {
                    this.log("Found directory: " + file2, 3);
                    return true;
                }
                if (this.type.isFile() && file2.isFile()) {
                    this.log("Found file: " + file2, 3);
                    return true;
                }
                return false;
            }
            FileUtils fileUtils = FileUtils.newFileUtils();
            File file3 = fileUtils.getParentFile(file2);
            if (file3 != null && file3.exists() && this.file.equals(file3.getAbsolutePath())) {
                if (this.type == null) {
                    this.log("Found: " + file3, 3);
                    return true;
                }
                if (this.type.isDir()) {
                    this.log("Found directory: " + file3, 3);
                    return true;
                }
                return false;
            }
            if (file2.exists() && file2.isDirectory() && this.checkFile(new File(file2, this.file), this.file + " in " + file2)) {
                return true;
            }
            if (file3 != null && file3.exists() && this.checkFile(new File(file3, this.file), this.file + " in " + file3)) {
                return true;
            }
            if (file3 != null && (file = fileUtils.getParentFile(file3)) != null && file.exists() && this.checkFile(new File(file, this.file), this.file + " in " + file)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean checkFile(File file, String string) {
        if (this.type != null) {
            if (this.type.isDir()) {
                if (file.isDirectory()) {
                    this.log("Found directory: " + string, 3);
                }
                return file.isDirectory();
            }
            if (this.type.isFile()) {
                if (file.isFile()) {
                    this.log("Found file: " + string, 3);
                }
                return file.isFile();
            }
        }
        if (file.exists()) {
            this.log("Found: " + string, 3);
        }
        return file.exists();
    }

    private boolean checkResource(String string) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(string) != null;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(string) != null;
        }
        return ClassLoader.getSystemResourceAsStream(string) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkClass(String string) {
        try {
            Class<?> clazz = null;
            if (this.ignoreSystemclasses) {
                this.loader = this.getProject().createClassLoader(this.classpath);
                this.loader.setParentFirst(false);
                this.loader.addJavaLibraries();
                if (this.loader == null) return false;
                try {
                    clazz = this.loader.findClass(string);
                    return true;
                }
                catch (SecurityException securityException) {
                    return true;
                }
            } else {
                ClassLoader classLoader;
                clazz = this.loader != null ? this.loader.loadClass(string) : ((classLoader = this.getClass().getClassLoader()) != null ? Class.forName(string, true, classLoader) : Class.forName(string));
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("class \"" + string + "\" was not found", 4);
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.log("Could not load dependent class \"" + noClassDefFoundError.getMessage() + "\" for class \"" + string + "\"", 4);
            return false;
        }
    }

    public static class FileDir
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"file", "dir"};

        public String[] getValues() {
            return VALUES;
        }

        public boolean isDir() {
            return "dir".equalsIgnoreCase(this.getValue());
        }

        public boolean isFile() {
            return "file".equalsIgnoreCase(this.getValue());
        }
    }
}

