/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Antlib;
import org.apache.tools.ant.taskdefs.DefBase;
import org.apache.tools.ant.types.EnumeratedAttribute;

public abstract class Definer
extends DefBase {
    private static ResourceStack resourceStack = new ResourceStack();
    private String name;
    private String classname;
    private File file;
    private String resource;
    private int format = 0;
    private boolean definerSet = false;
    private int onError = 0;
    private String adapter;
    private String adaptTo;
    private Class adapterClass;
    private Class adaptToClass;

    public void setOnError(OnError onError) {
        this.onError = onError.getIndex();
    }

    public void setFormat(Format format) {
        this.format = format.getIndex();
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ClassLoader classLoader = this.createLoader();
        if (!this.definerSet) {
            throw new BuildException("name, file or resource attribute of " + this.getTaskName() + " is undefined", this.getLocation());
        }
        if (this.name != null) {
            if (this.classname == null) {
                throw new BuildException("classname attribute of " + this.getTaskName() + " element " + "is undefined", this.getLocation());
            }
            this.addDefinition(classLoader, this.name, this.classname);
        } else {
            URL uRL;
            if (this.classname != null) {
                String string = "You must not specify classname together with file or resource.";
                throw new BuildException(string, this.getLocation());
            }
            Enumeration enumeration = null;
            if (this.file != null) {
                uRL = this.fileToURL();
                if (uRL == null) {
                    return;
                }
                enumeration = new Enumeration(){
                    private boolean more = true;

                    public boolean hasMoreElements() {
                        return this.more;
                    }

                    public Object nextElement() throws NoSuchElementException {
                        if (this.more) {
                            this.more = false;
                            return uRL;
                        }
                        throw new NoSuchElementException();
                    }
                };
            } else {
                enumeration = this.resourceToURLs(classLoader);
            }
            while (enumeration.hasMoreElements()) {
                Object var6_6;
                uRL = (URL)enumeration.nextElement();
                int n = this.format;
                if (uRL.toString().toLowerCase(Locale.US).endsWith(".xml")) {
                    n = 1;
                }
                if (n == 0) {
                    this.loadProperties(classLoader, uRL);
                    break;
                }
                if (resourceStack.getStack().get(uRL) != null) {
                    this.log("Warning: Recursive loading of " + uRL + " ignored" + " at " + this.getLocation() + " originally loaded at " + resourceStack.getStack().get(uRL), 1);
                    continue;
                }
                try {
                    resourceStack.getStack().put(uRL, this.getLocation());
                    this.loadAntlib(classLoader, uRL);
                    var6_6 = null;
                    resourceStack.getStack().remove(uRL);
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    resourceStack.getStack().remove(uRL);
                    throw throwable;
                }
                {
                }
            }
        }
    }

    private URL fileToURL() {
        if (!this.file.exists()) {
            this.log("File " + this.file + " does not exist", 1);
            return null;
        }
        if (!this.file.isFile()) {
            this.log("File " + this.file + " is not a file", 1);
            return null;
        }
        try {
            return this.file.toURL();
        }
        catch (Exception exception) {
            this.log("File " + this.file + " cannot use as URL: " + exception.toString(), 1);
            return null;
        }
    }

    private Enumeration resourceToURLs(ClassLoader classLoader) {
        Enumeration<URL> enumeration;
        try {
            enumeration = classLoader.getResources(this.resource);
        }
        catch (IOException iOException) {
            throw new BuildException("Could not fetch resources named " + this.resource, iOException, this.getLocation());
        }
        if (!enumeration.hasMoreElements() && this.onError != 2) {
            this.log("Could not load definitions from resource " + this.resource + ". It could not be found.", 1);
        }
        return enumeration;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadProperties(ClassLoader var1_1, URL var2_2) {
        block12: {
            block11: {
                var3_3 = null;
                try {
                    try {
                        var3_3 = var2_2.openStream();
                        if (var3_3 == null) {
                            this.log("Could not load definitions from " + var2_2, 1);
                            var7_4 = null;
                            if (var3_3 == null) return;
                            break block11;
                        }
                        var4_10 = new Properties();
                        var4_10.load(var3_3);
                        var5_12 = var4_10.keys();
                        while (var5_12.hasMoreElements()) {
                            this.name = (String)var5_12.nextElement();
                            this.classname = var4_10.getProperty(this.name);
                            this.addDefinition(var1_1, this.name, this.classname);
                        }
                        break block12;
                    }
                    catch (IOException var4_11) {
                        throw new BuildException(var4_11, this.getLocation());
                    }
                }
                catch (Throwable var6_13) {
                    var7_6 = null;
                    if (var3_3 == null) throw var6_13;
                    try {
                        var3_3.close();
                        throw var6_13;
                    }
                    catch (IOException var8_9) {
                        // empty catch block
                    }
                    throw var6_13;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 150->157)] { 
lbl34:
            // 1 sources

            var3_3.close();
            return;
lbl36:
            // 1 sources

            catch (IOException var8_7) {
                // empty catch block
            }
            return;
        }
        var7_5 = null;
        if (var3_3 == null) return;
        try {}
        catch (IOException var8_8) {}
        var3_3.close();
        return;
    }

    private void loadAntlib(ClassLoader classLoader, URL uRL) {
        try {
            Antlib antlib = Antlib.createAntlib(this.getProject(), uRL, this.getURI());
            antlib.setClassLoader(classLoader);
            antlib.setURI(this.getURI());
            antlib.perform();
        }
        catch (BuildException buildException) {
            throw ProjectHelper.addLocationToBuildException(buildException, this.getLocation());
        }
    }

    public void setFile(File file) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.file = file;
    }

    public void setResource(String string) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.resource = string;
    }

    public void setName(String string) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.name = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public void setAdapter(String string) {
        this.adapter = string;
    }

    protected void setAdapterClass(Class clazz) {
        this.adapterClass = clazz;
    }

    public void setAdaptTo(String string) {
        this.adaptTo = string;
    }

    protected void setAdaptToClass(Class clazz) {
        this.adaptToClass = clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addDefinition(ClassLoader classLoader, String string, String string2) throws BuildException {
        Class<?> clazz = null;
        try {
            try {
                string = ProjectHelper.genComponentName(this.getURI(), string);
                if (this.onError != 2) {
                    clazz = Class.forName(string2, true, classLoader);
                }
                if (this.adapter != null) {
                    this.adapterClass = Class.forName(this.adapter, true, classLoader);
                }
                if (this.adaptTo != null) {
                    this.adaptToClass = Class.forName(this.adaptTo, true, classLoader);
                }
                AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
                antTypeDefinition.setName(string);
                antTypeDefinition.setClassName(string2);
                antTypeDefinition.setClass(clazz);
                antTypeDefinition.setAdapterClass(this.adapterClass);
                antTypeDefinition.setAdaptToClass(this.adaptToClass);
                antTypeDefinition.setClassLoader(classLoader);
                if (clazz != null) {
                    antTypeDefinition.checkClass(this.getProject());
                }
                ComponentHelper.getComponentHelper(this.getProject()).addDataTypeDefinition(antTypeDefinition);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = this.getTaskName() + " class " + string2 + " cannot be found";
                throw new BuildException(string3, classNotFoundException, this.getLocation());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string4 = this.getTaskName() + " A class needed by class " + string2 + " cannot be found: " + noClassDefFoundError.getMessage();
                throw new BuildException(string4, noClassDefFoundError, this.getLocation());
            }
        }
        catch (BuildException buildException) {
            switch (this.onError) {
                case 0: {
                    throw buildException;
                }
                case 1: {
                    this.log(buildException.getLocation() + "Warning: " + buildException.getMessage(), 1);
                    return;
                }
                default: {
                    this.log(buildException.getLocation() + buildException.getMessage(), 4);
                }
            }
        }
    }

    private void tooManyDefinitions() {
        throw new BuildException("Only one of the attributes name,file,resource can be set", this.getLocation());
    }

    public static class Format
    extends EnumeratedAttribute {
        public static final int PROPERTIES = 0;
        public static final int XML = 1;

        public String[] getValues() {
            return new String[]{"properties", "xml"};
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public static final int FAIL = 0;
        public static final int REPORT = 1;
        public static final int IGNORE = 2;

        public OnError() {
        }

        public OnError(String string) {
            this.setValue(string);
        }

        public String[] getValues() {
            return new String[]{"fail", "report", "ignore"};
        }
    }

    private static class ResourceStack
    extends ThreadLocal {
        private ResourceStack() {
        }

        public Object initialValue() {
            return new HashMap();
        }

        Map getStack() {
            return (Map)this.get();
        }
    }
}

