/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.util.CollectionUtils;

public class Manifest {
    public static final String ATTRIBUTE_MANIFEST_VERSION = "Manifest-Version";
    public static final String ATTRIBUTE_SIGNATURE_VERSION = "Signature-Version";
    public static final String ATTRIBUTE_NAME = "Name";
    public static final String ATTRIBUTE_FROM = "From";
    public static final String ATTRIBUTE_CLASSPATH = "Class-Path";
    public static final String DEFAULT_MANIFEST_VERSION = "1.0";
    public static final int MAX_LINE_LENGTH = 72;
    public static final int MAX_SECTION_LENGTH = 70;
    public static final String EOL = "\r\n";
    private String manifestVersion = "1.0";
    private Section mainSection = new Section();
    private Hashtable sections = new Hashtable();
    private Vector sectionIndex = new Vector();
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Manifest;

    public static Manifest getDefaultManifest() throws BuildException {
        try {
            String string = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream inputStream = (class$org$apache$tools$ant$taskdefs$Manifest == null ? (class$org$apache$tools$ant$taskdefs$Manifest = Manifest.class$("org.apache.tools.ant.taskdefs.Manifest")) : class$org$apache$tools$ant$taskdefs$Manifest).getResourceAsStream(string);
            if (inputStream == null) {
                throw new BuildException("Could not find default manifest: " + string);
            }
            try {
                Manifest manifest = new Manifest(new InputStreamReader(inputStream, "UTF-8"));
                Attribute attribute = new Attribute("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
                manifest.getMainSection().storeAttribute(attribute);
                return manifest;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new Manifest(new InputStreamReader(inputStream));
            }
        }
        catch (ManifestException manifestException) {
            throw new BuildException("Default manifest is invalid !!", manifestException);
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to read default manifest", iOException);
        }
    }

    public Manifest() {
        this.manifestVersion = null;
    }

    public Manifest(Reader reader) throws ManifestException, IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = this.mainSection.read(bufferedReader);
        String string2 = this.mainSection.getAttributeValue(ATTRIBUTE_MANIFEST_VERSION);
        if (string2 != null) {
            this.manifestVersion = string2;
            this.mainSection.removeAttribute(ATTRIBUTE_MANIFEST_VERSION);
        }
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            Attribute attribute;
            if (string3.length() == 0) continue;
            Section section = new Section();
            if (string == null) {
                attribute = new Attribute(string3);
                if (!attribute.getName().equalsIgnoreCase(ATTRIBUTE_NAME)) {
                    throw new ManifestException("Manifest sections should start with a \"Name\" attribute and not \"" + attribute.getName() + "\"");
                }
                string = attribute.getValue();
            } else {
                attribute = new Attribute(string3);
                section.addAttributeAndCheck(attribute);
            }
            section.setName(string);
            string = section.read(bufferedReader);
            this.addConfiguredSection(section);
        }
    }

    public void addConfiguredSection(Section section) throws ManifestException {
        String string = section.getName();
        if (string == null) {
            throw new BuildException("Sections must have a name");
        }
        this.sections.put(string, section);
        if (!this.sectionIndex.contains(string)) {
            this.sectionIndex.addElement(string);
        }
    }

    public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
        if (attribute.getKey() == null || attribute.getValue() == null) {
            throw new BuildException("Attributes must have name and value");
        }
        if (attribute.getKey().equalsIgnoreCase(ATTRIBUTE_MANIFEST_VERSION)) {
            this.manifestVersion = attribute.getValue();
        } else {
            this.mainSection.addConfiguredAttribute(attribute);
        }
    }

    public void merge(Manifest manifest) throws ManifestException {
        this.merge(manifest, false);
    }

    public void merge(Manifest manifest, boolean bl) throws ManifestException {
        if (manifest != null) {
            if (bl) {
                this.mainSection = (Section)manifest.mainSection.clone();
            } else {
                this.mainSection.merge(manifest.mainSection);
            }
            if (manifest.manifestVersion != null) {
                this.manifestVersion = manifest.manifestVersion;
            }
            Enumeration enumeration = manifest.getSectionNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Section section = (Section)this.sections.get(string);
                Section section2 = (Section)manifest.sections.get(string);
                if (section == null) {
                    if (section2 == null) continue;
                    this.addConfiguredSection((Section)section2.clone());
                    continue;
                }
                section.merge(section2);
            }
        }
    }

    public void write(PrintWriter printWriter) throws IOException {
        Object object;
        printWriter.print("Manifest-Version: " + this.manifestVersion + EOL);
        String string = this.mainSection.getAttributeValue(ATTRIBUTE_SIGNATURE_VERSION);
        if (string != null) {
            printWriter.print("Signature-Version: " + string + EOL);
            this.mainSection.removeAttribute(ATTRIBUTE_SIGNATURE_VERSION);
        }
        this.mainSection.write(printWriter);
        if (string != null) {
            try {
                object = new Attribute(ATTRIBUTE_SIGNATURE_VERSION, string);
                this.mainSection.addConfiguredAttribute((Attribute)object);
            }
            catch (ManifestException manifestException) {
                // empty catch block
            }
        }
        object = this.sectionIndex.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            Section section = this.getSection(string2);
            section.write(printWriter);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.write(new PrintWriter(stringWriter));
        }
        catch (IOException iOException) {
            return null;
        }
        return stringWriter.toString();
    }

    public Enumeration getWarnings() {
        Vector vector = new Vector();
        Enumeration enumeration = this.mainSection.getWarnings();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.sections.elements();
        while (enumeration2.hasMoreElements()) {
            Section section = (Section)enumeration2.nextElement();
            Enumeration enumeration3 = section.getWarnings();
            while (enumeration3.hasMoreElements()) {
                vector.addElement(enumeration3.nextElement());
            }
        }
        return vector.elements();
    }

    public int hashCode() {
        int n = 0;
        if (this.manifestVersion != null) {
            n += this.manifestVersion.hashCode();
        }
        n += this.mainSection.hashCode();
        return n += this.sections.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Manifest manifest = (Manifest)object;
        if (this.manifestVersion == null ? manifest.manifestVersion != null : !this.manifestVersion.equals(manifest.manifestVersion)) {
            return false;
        }
        if (!this.mainSection.equals(manifest.mainSection)) {
            return false;
        }
        return CollectionUtils.equals(this.sections, manifest.sections);
    }

    public String getManifestVersion() {
        return this.manifestVersion;
    }

    public Section getMainSection() {
        return this.mainSection;
    }

    public Section getSection(String string) {
        return (Section)this.sections.get(string);
    }

    public Enumeration getSectionNames() {
        return this.sectionIndex.elements();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Attribute {
        private String name = null;
        private Vector values = new Vector();
        private int currentIndex = 0;

        public Attribute() {
        }

        public Attribute(String string) throws ManifestException {
            this.parse(string);
        }

        public Attribute(String string, String string2) {
            this.name = string;
            this.setValue(string2);
        }

        public int hashCode() {
            int n = 0;
            if (this.name != null) {
                n += this.name.hashCode();
            }
            return n += this.values.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            if (object == this) {
                return true;
            }
            Attribute attribute = (Attribute)object;
            String string = this.getKey();
            String string2 = attribute.getKey();
            if (string == null && string2 != null || string != null && string2 == null || !string.equals(string2)) {
                return false;
            }
            return CollectionUtils.equals(this.values, attribute.values);
        }

        public void parse(String string) throws ManifestException {
            int n = string.indexOf(": ");
            if (n == -1) {
                throw new ManifestException("Manifest line \"" + string + "\" is not valid as it does not " + "contain a name and a value separated by ': ' ");
            }
            this.name = string.substring(0, n);
            this.setValue(string.substring(n + 2));
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            if (this.name == null) {
                return null;
            }
            return this.name.toLowerCase();
        }

        public void setValue(String string) {
            if (this.currentIndex >= this.values.size()) {
                this.values.addElement(string);
                this.currentIndex = this.values.size() - 1;
            } else {
                this.values.setElementAt(string, this.currentIndex);
            }
        }

        public String getValue() {
            if (this.values.size() == 0) {
                return null;
            }
            String string = "";
            Enumeration enumeration = this.getValues();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = string + string2 + " ";
            }
            return string.trim();
        }

        public void addValue(String string) {
            ++this.currentIndex;
            this.setValue(string);
        }

        public Enumeration getValues() {
            return this.values.elements();
        }

        public void addContinuation(String string) {
            String string2 = (String)this.values.elementAt(this.currentIndex);
            this.setValue(string2 + string.substring(1));
        }

        public void write(PrintWriter printWriter) throws IOException {
            Enumeration enumeration = this.getValues();
            while (enumeration.hasMoreElements()) {
                this.writeValue(printWriter, (String)enumeration.nextElement());
            }
        }

        private void writeValue(PrintWriter printWriter, String string) throws IOException {
            String string2 = this.name + ": " + string;
            while (string2.getBytes().length > 72) {
                int n = 70;
                String string3 = string2.substring(0, n);
                while (string3.getBytes().length > 70 && n > 0) {
                    string3 = string2.substring(0, --n);
                }
                if (n == 0) {
                    throw new IOException("Unable to write manifest line " + this.name + ": " + string);
                }
                printWriter.print(string3 + Manifest.EOL);
                string2 = " " + string2.substring(n);
            }
            printWriter.print(string2 + Manifest.EOL);
        }
    }

    public static class Section {
        private Vector warnings = new Vector();
        private String name = null;
        private Hashtable attributes = new Hashtable();
        private Vector attributeIndex = new Vector();

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String read(BufferedReader bufferedReader) throws ManifestException, IOException {
            String string;
            Attribute attribute = null;
            while (true) {
                String string2;
                if ((string2 = bufferedReader.readLine()) == null || string2.length() == 0) {
                    return null;
                }
                if (string2.charAt(0) == ' ') {
                    if (attribute == null) {
                        if (this.name != null) {
                            this.name = this.name + string2.substring(1);
                            continue;
                        }
                        throw new ManifestException("Can't start an attribute with a continuation line " + string2);
                    }
                    attribute.addContinuation(string2);
                    continue;
                }
                attribute = new Attribute(string2);
                string = this.addAttributeAndCheck(attribute);
                attribute = this.getAttribute(attribute.getKey());
                if (string != null) break;
            }
            return string;
        }

        public void merge(Section section) throws ManifestException {
            Object object;
            if (this.name == null && section.getName() != null || this.name != null && !this.name.equalsIgnoreCase(section.getName())) {
                throw new ManifestException("Unable to merge sections with different names");
            }
            Enumeration enumeration = section.getAttributeKeys();
            Attribute attribute = null;
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Attribute attribute2 = section.getAttribute((String)object);
                if (((String)object).equalsIgnoreCase(Manifest.ATTRIBUTE_CLASSPATH)) {
                    if (attribute == null) {
                        attribute = new Attribute();
                        attribute.setName(Manifest.ATTRIBUTE_CLASSPATH);
                    }
                    Enumeration enumeration2 = attribute2.getValues();
                    while (enumeration2.hasMoreElements()) {
                        String string = (String)enumeration2.nextElement();
                        attribute.addValue(string);
                    }
                    continue;
                }
                this.storeAttribute(attribute2);
            }
            if (attribute != null) {
                this.storeAttribute(attribute);
            }
            object = section.warnings.elements();
            while (object.hasMoreElements()) {
                this.warnings.addElement(object.nextElement());
            }
        }

        public void write(PrintWriter printWriter) throws IOException {
            Object object;
            if (this.name != null) {
                object = new Attribute(Manifest.ATTRIBUTE_NAME, this.name);
                ((Attribute)object).write(printWriter);
            }
            object = this.getAttributeKeys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Attribute attribute = this.getAttribute(string);
                attribute.write(printWriter);
            }
            printWriter.print(Manifest.EOL);
        }

        public Attribute getAttribute(String string) {
            return (Attribute)this.attributes.get(string.toLowerCase());
        }

        public Enumeration getAttributeKeys() {
            return this.attributeIndex.elements();
        }

        public String getAttributeValue(String string) {
            Attribute attribute = this.getAttribute(string.toLowerCase());
            if (attribute == null) {
                return null;
            }
            return attribute.getValue();
        }

        public void removeAttribute(String string) {
            String string2 = string.toLowerCase();
            this.attributes.remove(string2);
            this.attributeIndex.removeElement(string2);
        }

        public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
            String string = this.addAttributeAndCheck(attribute);
            if (string != null) {
                throw new BuildException("Specify the section name using the \"name\" attribute of the <section> element rather than using a \"Name\" manifest attribute");
            }
        }

        public String addAttributeAndCheck(Attribute attribute) throws ManifestException {
            if (attribute.getName() == null || attribute.getValue() == null) {
                throw new BuildException("Attributes must have name and value");
            }
            if (attribute.getKey().equalsIgnoreCase(Manifest.ATTRIBUTE_NAME)) {
                this.warnings.addElement("\"Name\" attributes should not occur in the main section and must be the first element in all other sections: \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
                return attribute.getValue();
            }
            if (attribute.getKey().startsWith(Manifest.ATTRIBUTE_FROM.toLowerCase())) {
                this.warnings.addElement("Manifest attributes should not start with \"From\" in \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
            } else {
                String string = attribute.getKey();
                if (string.equalsIgnoreCase(Manifest.ATTRIBUTE_CLASSPATH)) {
                    Attribute attribute2 = (Attribute)this.attributes.get(string);
                    if (attribute2 == null) {
                        this.storeAttribute(attribute);
                    } else {
                        this.warnings.addElement("Multiple Class-Path attributes are supported but violate the Jar specification and may not be correctly processed in all environments");
                        Enumeration enumeration = attribute.getValues();
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            attribute2.addValue(string2);
                        }
                    }
                } else {
                    if (this.attributes.containsKey(string)) {
                        throw new ManifestException("The attribute \"" + attribute.getName() + "\" may not occur more " + "than once in the same section");
                    }
                    this.storeAttribute(attribute);
                }
            }
            return null;
        }

        public Object clone() {
            Section section = new Section();
            section.setName(this.name);
            Enumeration enumeration = this.getAttributeKeys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Attribute attribute = this.getAttribute(string);
                section.storeAttribute(new Attribute(attribute.getName(), attribute.getValue()));
            }
            return section;
        }

        private void storeAttribute(Attribute attribute) {
            if (attribute == null) {
                return;
            }
            String string = attribute.getKey();
            this.attributes.put(string, attribute);
            if (!this.attributeIndex.contains(string)) {
                this.attributeIndex.addElement(string);
            }
        }

        public Enumeration getWarnings() {
            return this.warnings.elements();
        }

        public int hashCode() {
            int n = 0;
            if (this.name != null) {
                n += this.name.hashCode();
            }
            return n += this.attributes.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            if (object == this) {
                return true;
            }
            Section section = (Section)object;
            return CollectionUtils.equals(this.attributes, section.attributes);
        }
    }
}

