/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class Pack
extends Task {
    protected File zipFile;
    protected File source;

    public void setZipfile(File file) {
        this.zipFile = file;
    }

    public void setDestfile(File file) {
        this.setZipfile(file);
    }

    public void setSrc(File file) {
        this.source = file;
    }

    private void validate() throws BuildException {
        if (this.zipFile == null) {
            throw new BuildException("zipfile attribute is required", this.getLocation());
        }
        if (this.zipFile.isDirectory()) {
            throw new BuildException("zipfile attribute must not represent a directory!", this.getLocation());
        }
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.getLocation());
        }
        if (this.source.isDirectory()) {
            throw new BuildException("Src attribute must not represent a directory!", this.getLocation());
        }
    }

    public void execute() throws BuildException {
        this.validate();
        if (!this.source.exists()) {
            this.log("Nothing to do: " + this.source.getAbsolutePath() + " doesn't exist.");
        } else if (this.zipFile.lastModified() < this.source.lastModified()) {
            this.log("Building: " + this.zipFile.getAbsolutePath());
            this.pack();
        } else {
            this.log("Nothing to do: " + this.zipFile.getAbsolutePath() + " is up to date.");
        }
    }

    private void zipFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            outputStream.write(byArray, 0, n);
        } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(File file, OutputStream outputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, outputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    protected abstract void pack();
}

