/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.StringUtils;

public class Parallel
extends Task
implements TaskContainer {
    private Vector nestedTasks = new Vector();
    private final Object semaphore = new Object();
    private int numThreads = 0;
    private int numThreadsPerProcessor = 0;
    private long timeout;
    private volatile boolean stillRunning;
    private boolean timedOut;
    private boolean failOnAny;
    private TaskList daemonTasks;
    private StringBuffer exceptionMessage;
    private int numExceptions = 0;
    private Throwable firstException;
    private Location firstLocation;
    static /* synthetic */ Class class$java$lang$Runtime;

    public void addDaemons(TaskList taskList) {
        if (this.daemonTasks != null) {
            throw new BuildException("Only one daemon group is supported");
        }
        this.daemonTasks = taskList;
    }

    public void setPollInterval(int n) {
    }

    public void setFailOnAny(boolean bl) {
        this.failOnAny = bl;
    }

    public void addTask(Task task) {
        this.nestedTasks.addElement(task);
    }

    public void setThreadsPerProcessor(int n) {
        this.numThreadsPerProcessor = n;
    }

    public void setThreadCount(int n) {
        this.numThreads = n;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public void execute() throws BuildException {
        this.updateThreadCounts();
        if (this.numThreads == 0) {
            this.numThreads = this.nestedTasks.size();
        }
        this.spinThreads();
    }

    private void updateThreadCounts() {
        int n;
        if (this.numThreadsPerProcessor != 0 && (n = this.getNumProcessors()) != 0) {
            this.numThreads = n * this.numThreadsPerProcessor;
        }
    }

    private void processExceptions(TaskRunnable[] taskRunnableArray) {
        if (taskRunnableArray == null) {
            return;
        }
        int n = 0;
        while (n < taskRunnableArray.length) {
            Throwable throwable = taskRunnableArray[n].getException();
            if (throwable != null) {
                ++this.numExceptions;
                if (this.firstException == null) {
                    this.firstException = throwable;
                }
                if (throwable instanceof BuildException && this.firstLocation == Location.UNKNOWN_LOCATION) {
                    this.firstLocation = ((BuildException)throwable).getLocation();
                }
                this.exceptionMessage.append(StringUtils.LINE_SEP);
                this.exceptionMessage.append(throwable.getMessage());
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spinThreads() throws BuildException {
        int n = this.nestedTasks.size();
        TaskRunnable[] taskRunnableArray = new TaskRunnable[n];
        this.stillRunning = true;
        this.timedOut = false;
        int n2 = 0;
        Enumeration enumeration = this.nestedTasks.elements();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            taskRunnableArray[n2] = new TaskRunnable(task);
            ++n2;
        }
        int n3 = n < this.numThreads ? n : this.numThreads;
        TaskRunnable[] taskRunnableArray2 = new TaskRunnable[n3];
        n2 = 0;
        ThreadGroup threadGroup = new ThreadGroup("parallel");
        TaskRunnable[] taskRunnableArray3 = null;
        if (this.daemonTasks != null && this.daemonTasks.tasks.size() != 0) {
            taskRunnableArray3 = new TaskRunnable[this.daemonTasks.tasks.size()];
        }
        Object object = this.semaphore;
        synchronized (object) {
            Thread thread;
            int n4;
            if (taskRunnableArray3 != null) {
                n4 = 0;
                while (n4 < taskRunnableArray3.length) {
                    taskRunnableArray3[n4] = new TaskRunnable((Task)this.daemonTasks.tasks.get(n4));
                    thread = new Thread(threadGroup, taskRunnableArray3[n4]);
                    thread.setDaemon(true);
                    thread.start();
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < n3) {
                taskRunnableArray2[n4] = taskRunnableArray[n2++];
                thread = new Thread(threadGroup, taskRunnableArray2[n4]);
                thread.start();
                ++n4;
            }
            if (this.timeout != 0L) {
                thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public synchronized void run() {
                        try {
                            this.wait(Parallel.this.timeout);
                            Object object = Parallel.this.semaphore;
                            synchronized (object) {
                                Parallel.this.stillRunning = false;
                                Parallel.this.timedOut = true;
                                Parallel.this.semaphore.notifyAll();
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                };
                thread.start();
            }
            block10: while (n2 < n && this.stillRunning) {
                int n5 = 0;
                while (n5 < n3) {
                    if (taskRunnableArray2[n5] == null || taskRunnableArray2[n5].finished) {
                        taskRunnableArray2[n5] = taskRunnableArray[n2++];
                        Thread thread2 = new Thread(threadGroup, taskRunnableArray2[n5]);
                        thread2.start();
                        continue block10;
                    }
                    ++n5;
                }
                try {
                    this.semaphore.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            block12: while (this.stillRunning) {
                int n6 = 0;
                while (n6 < n3) {
                    if (taskRunnableArray2[n6] != null && !taskRunnableArray2[n6].finished) {
                        try {
                            this.semaphore.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block12;
                    }
                    ++n6;
                }
                this.stillRunning = false;
            }
        }
        if (this.timedOut) {
            throw new BuildException("Parallel execution timed out");
        }
        this.exceptionMessage = new StringBuffer();
        this.numExceptions = 0;
        this.firstException = null;
        this.firstLocation = Location.UNKNOWN_LOCATION;
        this.processExceptions(taskRunnableArray3);
        this.processExceptions(taskRunnableArray);
        if (this.numExceptions == 1) {
            if (this.firstException instanceof BuildException) {
                throw (BuildException)this.firstException;
            }
            throw new BuildException(this.firstException);
        }
        if (this.numExceptions > 1) {
            throw new BuildException(this.exceptionMessage.toString(), this.firstLocation);
        }
    }

    private int getNumProcessors() {
        try {
            Class[] classArray = new Class[]{};
            Method method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Parallel.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("availableProcessors", classArray);
            Object[] objectArray = new Object[]{};
            Integer n = (Integer)method.invoke((Object)Runtime.getRuntime(), objectArray);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class TaskList
    implements TaskContainer {
        private List tasks = new ArrayList();

        public void addTask(Task task) throws BuildException {
            this.tasks.add(task);
        }
    }

    private class TaskRunnable
    implements Runnable {
        private Throwable exception;
        private Task task;
        boolean finished;

        TaskRunnable(Task task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.perform();
            }
            catch (Throwable throwable) {
                this.exception = throwable;
                if (Parallel.this.failOnAny) {
                    Parallel.this.stillRunning = false;
                }
            }
            finally {
                Object object = Parallel.this.semaphore;
                synchronized (object) {
                    this.finished = true;
                    Parallel.this.semaphore.notifyAll();
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

