/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;

public class PathConvert
extends Task {
    private Path path = null;
    private Reference refid = null;
    private String targetOS = null;
    private boolean targetWindows = false;
    private boolean onWindows = false;
    private boolean setonempty = true;
    private String property = null;
    private Vector prefixMap = new Vector();
    private String pathSep = null;
    private String dirSep = null;
    private Mapper mapper = null;

    public PathConvert() {
        this.onWindows = Os.isFamily("dos");
    }

    public Path createPath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path.createPath();
    }

    public MapEntry createMap() {
        MapEntry mapEntry = new MapEntry();
        this.prefixMap.addElement(mapEntry);
        return mapEntry;
    }

    public void setTargetos(String string) {
        TargetOs targetOs = new TargetOs();
        targetOs.setValue(string);
        this.setTargetos(targetOs);
    }

    public void setTargetos(TargetOs targetOs) {
        this.targetOS = targetOs.getValue();
        this.targetWindows = !this.targetOS.equals("unix") && !this.targetOS.equals("tandem");
    }

    public void setSetonempty(boolean bl) {
        this.setonempty = bl;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setRefid(Reference reference) {
        if (this.path != null) {
            throw this.noChildrenAllowed();
        }
        this.refid = reference;
    }

    public void setPathSep(String string) {
        this.pathSep = string;
    }

    public void setDirSep(String string) {
        this.dirSep = string;
    }

    public boolean isReference() {
        return this.refid != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Path path = this.path;
        String string = this.pathSep;
        String string2 = this.dirSep;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (this.isReference()) {
                this.path = new Path(this.getProject()).createPath();
                object4 = this.refid.getReferencedObject(this.getProject());
                if (object4 instanceof Path) {
                    this.path.setRefid(this.refid);
                } else if (object4 instanceof FileSet) {
                    object3 = (FileSet)object4;
                    this.path.addFileset((FileSet)object3);
                } else if (object4 instanceof DirSet) {
                    object3 = (DirSet)object4;
                    this.path.addDirset((DirSet)object3);
                } else if (object4 instanceof FileList) {
                    object3 = (FileList)object4;
                    this.path.addFilelist((FileList)object3);
                } else {
                    throw new BuildException("'refid' does not refer to a path, fileset, dirset, or filelist.");
                }
            }
            this.validateSetup();
            object4 = this.onWindows ? "\\" : "/";
            object3 = new StringBuffer(100);
            String[] stringArray = this.path.list();
            if (this.mapper != null) {
                FileNameMapper fileNameMapper = this.mapper.getImplementation();
                object2 = new ArrayList();
                int n = 0;
                while (n < stringArray.length) {
                    object = fileNameMapper.mapFileName(stringArray[n]);
                    int n2 = 0;
                    while (object != null && n2 < ((String[])object).length) {
                        object2.add(object[n2]);
                        ++n2;
                    }
                    ++n;
                }
                stringArray = object2.toArray(new String[0]);
            }
            int n = 0;
            while (n < stringArray.length) {
                object2 = stringArray[n];
                object2 = this.mapElement((String)object2);
                if (n != 0) {
                    ((StringBuffer)object3).append(this.pathSep);
                }
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, (String)object4, true);
                object = null;
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object4).equals(object)) {
                        ((StringBuffer)object3).append(this.dirSep);
                        continue;
                    }
                    ((StringBuffer)object3).append((String)object);
                }
                ++n;
            }
            object2 = ((StringBuffer)object3).toString();
            if (this.setonempty) {
                this.log("Set property " + this.property + " = " + (String)object2, 3);
                this.getProject().setNewProperty(this.property, (String)object2);
            } else if (((StringBuffer)object3).length() > 0) {
                this.log("Set property " + this.property + " = " + (String)object2, 3);
                this.getProject().setNewProperty(this.property, (String)object2);
            }
            Object var13_14 = null;
            this.path = path;
            this.dirSep = string2;
            this.pathSep = string;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.path = path;
            this.dirSep = string2;
            this.pathSep = string;
            throw throwable;
        }
    }

    private String mapElement(String string) {
        int n = this.prefixMap.size();
        if (n != 0) {
            int n2 = 0;
            while (n2 < n) {
                MapEntry mapEntry = (MapEntry)this.prefixMap.elementAt(n2);
                String string2 = mapEntry.apply(string);
                if (string2 != string) {
                    string = string2;
                    break;
                }
                ++n2;
            }
        }
        return string;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper");
        }
        this.mapper = mapper;
    }

    private void validateSetup() throws BuildException {
        if (this.path == null) {
            throw new BuildException("You must specify a path to convert");
        }
        if (this.property == null) {
            throw new BuildException("You must specify a property");
        }
        if (this.targetOS == null && this.pathSep == null && this.dirSep == null) {
            throw new BuildException("You must specify at least one of targetOS, dirSep, or pathSep");
        }
        String string = File.separator;
        String string2 = File.pathSeparator;
        if (this.targetOS != null) {
            string2 = this.targetWindows ? ";" : ":";
            String string3 = string = this.targetWindows ? "\\" : "/";
        }
        if (this.pathSep != null) {
            string2 = this.pathSep;
        }
        if (this.dirSep != null) {
            string = this.dirSep;
        }
        this.pathSep = string2;
        this.dirSep = string;
    }

    private BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested <path> elements when using the refid attribute.");
    }

    public class MapEntry {
        private String from = null;
        private String to = null;

        public void setFrom(String string) {
            this.from = string;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public String apply(String string) {
            String string2;
            if (this.from == null || this.to == null) {
                throw new BuildException("Both 'from' and 'to' must be set in a map entry");
            }
            String string3 = PathConvert.this.onWindows ? string.toLowerCase() : string;
            String string4 = string2 = PathConvert.this.onWindows ? this.from.toLowerCase() : this.from;
            if (string3.startsWith(string2)) {
                int n = this.from.length();
                string = n >= string.length() ? this.to : this.to + string.substring(n);
            }
            return string;
        }
    }

    public static class TargetOs
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"windows", "unix", "netware", "os/2", "tandem"};
        }
    }
}

