/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.JDBCTask;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class SQLExec
extends JDBCTask {
    private int goodSql = 0;
    private int totalSql = 0;
    private Connection conn = null;
    private Vector filesets = new Vector();
    private Statement statement = null;
    private File srcFile = null;
    private String sqlCommand = "";
    private Vector transactions = new Vector();
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private File output = null;
    private String onError = "abort";
    private String encoding = null;
    private boolean append = false;
    private boolean keepformat = false;
    private boolean escapeProcessing = true;

    public void setSrc(File file) {
        this.srcFile = file;
    }

    public void addText(String string) {
        this.sqlCommand = this.sqlCommand + string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public Transaction createTransaction() {
        Transaction transaction = new Transaction();
        this.transactions.addElement(transaction);
        return transaction;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setPrint(boolean bl) {
        this.print = bl;
    }

    public void setShowheaders(boolean bl) {
        this.showheaders = bl;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setOnerror(OnError onError) {
        this.onError = onError.getValue();
    }

    public void setKeepformat(boolean bl) {
        this.keepformat = bl;
    }

    public void setEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Vector vector = (Vector)this.transactions.clone();
        String string = this.sqlCommand;
        this.sqlCommand = this.sqlCommand.trim();
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.srcFile == null && this.sqlCommand.length() == 0 && this.filesets.isEmpty() && this.transactions.size() == 0) {
                throw new BuildException("Source file or fileset, transactions or sql statement must be set!", this.getLocation());
            }
            if (this.srcFile != null && !this.srcFile.exists()) {
                throw new BuildException("Source file does not exist!", this.getLocation());
            }
            int n = 0;
            while (n < this.filesets.size()) {
                object3 = (FileSet)this.filesets.elementAt(n);
                object2 = ((AbstractFileSet)object3).getDirectoryScanner(this.getProject());
                object = ((AbstractFileSet)object3).getDir(this.getProject());
                String[] stringArray = ((DirectoryScanner)object2).getIncludedFiles();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    Transaction transaction = this.createTransaction();
                    transaction.setSrc(new File((File)object, stringArray[n2]));
                    ++n2;
                }
                ++n;
            }
            object3 = this.createTransaction();
            ((Transaction)object3).setSrc(this.srcFile);
            ((Transaction)object3).addText(this.sqlCommand);
            this.conn = this.getConnection();
            if (!this.isValidRdbms(this.conn)) {
                Object var15_15 = null;
                this.transactions = vector;
                this.sqlCommand = string;
                return;
            }
            try {
                this.statement = this.conn.createStatement();
                this.statement.setEscapeProcessing(this.escapeProcessing);
                object2 = System.out;
                try {
                    if (this.output != null) {
                        this.log("Opening PrintStream to output file " + this.output, 3);
                        object2 = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                    }
                    object = this.transactions.elements();
                    while (object.hasMoreElements()) {
                        ((Transaction)object.nextElement()).runTransaction((PrintStream)object2);
                        if (this.isAutocommit()) continue;
                        this.log("Committing transaction", 3);
                        this.conn.commit();
                    }
                    Object var11_18 = null;
                    if (object2 != null && object2 != System.out) {
                        ((PrintStream)object2).close();
                    }
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    if (object2 != null && object2 != System.out) {
                        ((PrintStream)object2).close();
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                if (!this.isAutocommit() && this.conn != null && this.onError.equals("abort")) {
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new BuildException(iOException, this.getLocation());
            }
            catch (SQLException sQLException) {
                if (!this.isAutocommit() && this.conn != null && this.onError.equals("abort")) {
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                }
                throw new BuildException(sQLException, this.getLocation());
            }
            finally {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            this.log(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully");
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.transactions = vector;
            this.sqlCommand = string;
            throw throwable;
        }
        Object var15_16 = null;
        this.transactions = vector;
        this.sqlCommand = string;
    }

    protected void runStatements(Reader reader, PrintStream printStream) throws SQLException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            StringTokenizer stringTokenizer;
            if (!this.keepformat) {
                string = string.trim();
            }
            string = this.getProject().replaceProperties(string);
            if (!this.keepformat && (string.startsWith("//") || string.startsWith("--") || (stringTokenizer = new StringTokenizer(string)).hasMoreTokens() && "REM".equalsIgnoreCase(string2 = stringTokenizer.nextToken()))) continue;
            if (!this.keepformat) {
                stringBuffer.append(" " + string);
            } else {
                stringBuffer.append("\n" + string);
            }
            if (!this.keepformat && string.indexOf("--") >= 0) {
                stringBuffer.append("\n");
            }
            if ((!this.delimiterType.equals("normal") || !stringBuffer.toString().endsWith(this.delimiter)) && (!this.delimiterType.equals("row") || !string.equals(this.delimiter))) continue;
            this.execSQL(stringBuffer.substring(0, stringBuffer.length() - this.delimiter.length()), printStream);
            stringBuffer.replace(0, stringBuffer.length(), "");
        }
        if (!stringBuffer.equals("")) {
            this.execSQL(stringBuffer.toString(), printStream);
        }
    }

    protected void execSQL(String string, PrintStream printStream) throws SQLException {
        if ("".equals(string.trim())) {
            return;
        }
        try {
            Serializable serializable;
            ++this.totalSql;
            this.log("SQL: " + string, 3);
            int n = 0;
            int n2 = 0;
            ResultSet resultSet = null;
            boolean bl = this.statement.execute(string);
            n = this.statement.getUpdateCount();
            resultSet = this.statement.getResultSet();
            do {
                if (!bl) {
                    if (n != -1) {
                        n2 += n;
                    }
                } else if (this.print) {
                    this.printResults(printStream);
                }
                bl = this.statement.getMoreResults();
                n = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
            } while (bl);
            this.log(n2 + " rows affected", 3);
            if (this.print) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(n2 + " rows affected");
                printStream.println(serializable);
            }
            serializable = this.conn.getWarnings();
            while (serializable != null) {
                this.log(serializable + " sql warning", 3);
                serializable = ((SQLWarning)serializable).getNextWarning();
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException sQLException) {
            this.log("Failed to execute: " + string, 0);
            if (!this.onError.equals("continue")) {
                throw sQLException;
            }
            this.log(sQLException.toString(), 0);
        }
    }

    protected void printResults(PrintStream printStream) throws SQLException {
        ResultSet resultSet = null;
        resultSet = this.statement.getResultSet();
        if (resultSet != null) {
            int n;
            this.log("Processing new result set.", 3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer();
            if (this.showheaders) {
                n = 1;
                while (n < n2) {
                    stringBuffer.append(resultSetMetaData.getColumnName(n));
                    stringBuffer.append(",");
                    ++n;
                }
                stringBuffer.append(resultSetMetaData.getColumnName(n2));
                printStream.println(stringBuffer);
                stringBuffer = new StringBuffer();
            }
            while (resultSet.next()) {
                n = 1;
                int n3 = 1;
                while (n3 <= n2) {
                    String string = resultSet.getString(n3);
                    if (string != null) {
                        string = string.trim();
                    }
                    if (n != 0) {
                        n = 0;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string);
                    ++n3;
                }
                printStream.println(stringBuffer);
                stringBuffer = new StringBuffer();
            }
        }
        printStream.println();
    }

    public static class DelimiterType
    extends EnumeratedAttribute {
        public static final String NORMAL = "normal";
        public static final String ROW = "row";

        public String[] getValues() {
            return new String[]{NORMAL, ROW};
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }

    public class Transaction {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        public void setSrc(File file) {
            this.tSrcFile = file;
        }

        public void addText(String string) {
            this.tSqlCommand = this.tSqlCommand + string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTransaction(PrintStream printStream) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SQLExec.this.log("Executing commands", 2);
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), printStream);
            }
            if (this.tSrcFile != null) {
                SQLExec.this.log("Executing file: " + this.tSrcFile.getAbsolutePath(), 2);
                InputStreamReader inputStreamReader = SQLExec.this.encoding == null ? new FileReader(this.tSrcFile) : new InputStreamReader((InputStream)new FileInputStream(this.tSrcFile), SQLExec.this.encoding);
                try {
                    SQLExec.this.runStatements(inputStreamReader, printStream);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    ((Reader)inputStreamReader).close();
                    throw throwable;
                }
                ((Reader)inputStreamReader).close();
                {
                }
            }
        }
    }
}

