/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.JavaEnvUtils;

public class SignJar
extends Task {
    protected File jar;
    protected String alias;
    private String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigfile;
    protected File signedjar;
    protected boolean verbose;
    protected boolean internalsf;
    protected boolean sectionsonly;
    private String maxMemory;
    protected Vector filesets = new Vector();
    protected boolean lazy;

    public void setMaxmemory(String string) {
        this.maxMemory = string;
    }

    public void setJar(File file) {
        this.jar = file;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public void setStoretype(String string) {
        this.storetype = string;
    }

    public void setKeypass(String string) {
        this.keypass = string;
    }

    public void setSigfile(String string) {
        this.sigfile = string;
    }

    public void setSignedjar(File file) {
        this.signedjar = file;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setInternalsf(boolean bl) {
        this.internalsf = bl;
    }

    public void setSectionsonly(boolean bl) {
        this.sectionsonly = bl;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        if (null == this.jar && this.filesets.size() == 0) {
            throw new BuildException("jar must be set through jar attribute or nested filesets");
        }
        if (null != this.jar) {
            if (this.filesets.size() != 0) {
                this.log("nested filesets will be ignored if the jar attribute has been specified.", 1);
            }
            this.doOneJar(this.jar, this.signedjar);
            return;
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.doOneJar(new File(fileSet.getDir(this.getProject()), stringArray[n2]), null);
                ++n2;
            }
            ++n;
        }
    }

    private void doOneJar(File file, File file2) throws BuildException {
        if (null == this.alias) {
            throw new BuildException("alias attribute must be set");
        }
        if (null == this.storepass) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.isUpToDate(file, file2)) {
            return;
        }
        ExecTask execTask = (ExecTask)this.getProject().createTask("exec");
        execTask.setExecutable(JavaEnvUtils.getJdkExecutable("jarsigner"));
        if (this.maxMemory != null) {
            execTask.createArg().setValue("-J-Xmx" + this.maxMemory);
        }
        if (null != this.keystore) {
            File file3 = this.getProject().resolveFile(this.keystore);
            if (file3.exists()) {
                execTask.createArg().setValue("-keystore");
                execTask.createArg().setValue(file3.getPath());
            } else {
                execTask.createArg().setValue("-keystore");
                execTask.createArg().setValue(this.keystore);
            }
        }
        if (null != this.storepass) {
            execTask.createArg().setValue("-storepass");
            execTask.createArg().setValue(this.storepass);
        }
        if (null != this.storetype) {
            execTask.createArg().setValue("-storetype");
            execTask.createArg().setValue(this.storetype);
        }
        if (null != this.keypass) {
            execTask.createArg().setValue("-keypass");
            execTask.createArg().setValue(this.keypass);
        }
        if (null != this.sigfile) {
            execTask.createArg().setValue("-sigfile");
            execTask.createArg().setValue(this.sigfile);
        }
        if (null != file2) {
            execTask.createArg().setValue("-signedjar");
            execTask.createArg().setValue(file2.toString());
        }
        if (this.verbose) {
            execTask.createArg().setValue("-verbose");
        }
        if (this.internalsf) {
            execTask.createArg().setValue("-internalsf");
        }
        if (this.sectionsonly) {
            execTask.createArg().setValue("-sectionsonly");
        }
        execTask.createArg().setValue(file.toString());
        execTask.createArg().setValue(this.alias);
        this.log("Signing JAR: " + file.getAbsolutePath());
        execTask.setFailonerror(true);
        execTask.setTaskName(this.getTaskName());
        execTask.execute();
    }

    protected boolean isUpToDate(File file, File file2) {
        if (null == file) {
            return false;
        }
        if (null != file2) {
            if (!file.exists()) {
                return false;
            }
            if (!file2.exists()) {
                return false;
            }
            if (file.equals(file2)) {
                return false;
            }
            if (file2.lastModified() > file.lastModified()) {
                return true;
            }
        } else if (this.lazy) {
            return this.isSigned(file);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSigned(File var1_1) {
        var2_2 = "META-INF/";
        var3_3 = ".SF";
        if (!var1_1.exists()) {
            return false;
        }
        var4_4 = null;
        try {
            try {
                var4_4 = new ZipFile(var1_1);
                if (null == this.alias) {
                    block14: {
                        var5_5 = var4_4.entries();
                        do {
                            if (!var5_5.hasMoreElements()) break block14;
                        } while (!(var6_8 = var5_5.nextElement().getName()).startsWith("META-INF/") || !var6_8.endsWith(".SF"));
                        var7_11 = true;
                        var9_12 = null;
                        if (var4_4 == null) return var7_11;
                        try {
                            var4_4.close();
                            return var7_11;
                        }
                        catch (IOException var10_17) {
                            // empty catch block
                        }
                        return var7_11;
                    }
                    var6_9 = false;
                    var9_13 = null;
                    if (var4_4 == null) return var6_9;
                    ** try [egrp 2[TRYBLOCK] [8 : 186->194)] { 
lbl30:
                    // 1 sources

                    var4_4.close();
                    return var6_9;
lbl32:
                    // 1 sources

                    catch (IOException var10_18) {
                        // empty catch block
                    }
                    return var6_9;
                }
                var5_6 = var4_4.getEntry("META-INF/" + this.alias.toUpperCase() + ".SF") != null;
            }
            catch (IOException var5_7) {
                var6_10 = false;
                var9_15 = null;
                if (var4_4 == null) return var6_10;
                ** try [egrp 2[TRYBLOCK] [8 : 186->194)] { 
lbl44:
                // 1 sources

                var4_4.close();
                return var6_10;
lbl46:
                // 1 sources

                catch (IOException var10_20) {
                    // empty catch block
                }
                return var6_10;
            }
        }
        catch (Throwable var8_22) {
            var9_16 = null;
            if (var4_4 == null) throw var8_22;
            try {}
            catch (IOException var10_21) {
                throw var8_22;
            }
            var4_4.close();
            throw var8_22;
        }
        var9_14 = null;
        if (var4_4 == null) return var5_6;
        try {}
        catch (IOException var10_19) {
            // empty catch block
            return var5_6;
        }
        var4_4.close();
        return var5_6;
    }
}

