/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Reference;

public class SubAnt
extends Task {
    private Path buildpath;
    private Ant ant = null;
    private String target = null;
    private String antfile = "build.xml";
    private File genericantfile = null;
    private boolean inheritAll = false;
    private boolean inheritRefs = false;
    private boolean failOnError = true;
    private String output = null;
    private Vector properties = new Vector();
    private Vector references = new Vector();
    private Vector propertySets = new Vector();

    public void handleOutput(String string) {
        if (this.ant != null) {
            this.ant.handleOutput(string);
        } else {
            super.handleOutput(string);
        }
    }

    public int handleInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.ant != null) {
            return this.ant.handleInput(byArray, n, n2);
        }
        return super.handleInput(byArray, n, n2);
    }

    public void handleFlush(String string) {
        if (this.ant != null) {
            this.ant.handleFlush(string);
        } else {
            super.handleFlush(string);
        }
    }

    public void handleErrorOutput(String string) {
        if (this.ant != null) {
            this.ant.handleErrorOutput(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    public void handleErrorFlush(String string) {
        if (this.ant != null) {
            this.ant.handleErrorFlush(string);
        } else {
            super.handleErrorFlush(string);
        }
    }

    public void execute() {
        if (this.buildpath == null) {
            throw new BuildException("No buildpath specified");
        }
        String[] stringArray = this.buildpath.list();
        int n = stringArray.length;
        if (n < 1) {
            this.log("No sub-builds to iterate on", 1);
            return;
        }
        BuildException buildException = null;
        int n2 = 0;
        while (n2 < n) {
            File file = null;
            Throwable throwable = null;
            try {
                File file2 = null;
                file = new File(stringArray[n2]);
                if (file.isDirectory()) {
                    if (this.genericantfile != null) {
                        file2 = file;
                        file = this.genericantfile;
                    } else {
                        file = new File(file, this.antfile);
                    }
                }
                this.execute(file, file2);
            }
            catch (RuntimeException runtimeException) {
                if (!this.getProject().isKeepGoingMode()) {
                    throw runtimeException;
                }
                throwable = runtimeException;
            }
            catch (Throwable throwable2) {
                if (!this.getProject().isKeepGoingMode()) {
                    throw new BuildException(throwable2);
                }
                throwable = throwable2;
            }
            if (throwable != null) {
                if (throwable instanceof BuildException) {
                    this.log("File '" + file + "' failed with message '" + throwable.getMessage() + "'.", 0);
                    if (buildException == null) {
                        buildException = (BuildException)throwable;
                    }
                } else {
                    this.log("Target '" + file + "' failed with message '" + throwable.getMessage() + "'.", 0);
                    throwable.printStackTrace(System.err);
                    if (buildException == null) {
                        buildException = new BuildException(throwable);
                    }
                }
            }
            ++n2;
        }
        if (buildException != null) {
            throw buildException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(File file, File file2) throws BuildException {
        block11: {
            if (!file.exists() || file.isDirectory() || !file.canRead()) {
                String string = "Invalid file: " + file;
                if (this.failOnError) {
                    throw new BuildException(string);
                }
                this.log(string, 1);
                return;
            }
            this.ant = this.createAntTask(file2);
            String string = null;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
            this.ant.setAntfile(string);
            try {
                try {
                    this.ant.execute();
                }
                catch (BuildException buildException) {
                    if (this.failOnError) {
                        throw buildException;
                    }
                    this.log("Failure for target '" + this.target + "' of: " + string + "\n" + buildException.getMessage(), 1);
                    Object var7_8 = null;
                    this.ant = null;
                    break block11;
                }
                catch (Throwable throwable) {
                    if (this.failOnError) {
                        throw new BuildException(throwable);
                    }
                    this.log("Failure for target '" + this.target + "' of: " + string + "\n" + throwable.toString(), 1);
                    Object var7_9 = null;
                    this.ant = null;
                }
                Object var7_7 = null;
                this.ant = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.ant = null;
                throw throwable;
            }
        }
    }

    public void setAntfile(String string) {
        this.antfile = string;
    }

    public void setGenericAntfile(File file) {
        this.genericantfile = file;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public void setInheritall(boolean bl) {
        this.inheritAll = bl;
    }

    public void setInheritrefs(boolean bl) {
        this.inheritRefs = bl;
    }

    public void addProperty(Property property) {
        this.properties.addElement(property);
    }

    public void addReference(Ant.Reference reference) {
        this.references.addElement(reference);
    }

    public void addPropertyset(PropertySet propertySet) {
        this.propertySets.addElement(propertySet);
    }

    public void addDirset(DirSet dirSet) {
        this.getBuildpath().addDirset(dirSet);
    }

    public void addFileset(FileSet fileSet) {
        this.getBuildpath().addFileset(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.getBuildpath().addFilelist(fileList);
    }

    public void setBuildpath(Path path) {
        this.getBuildpath().append(path);
    }

    public Path createBuildpath() {
        return this.getBuildpath().createPath();
    }

    public Path.PathElement createBuildpathElement() {
        return this.getBuildpath().createPathElement();
    }

    private Path getBuildpath() {
        if (this.buildpath == null) {
            this.buildpath = new Path(this.getProject());
        }
        return this.buildpath;
    }

    public void setBuildpathRef(Reference reference) {
        this.createBuildpath().setRefid(reference);
    }

    private Ant createAntTask(File file) {
        Ant ant = (Ant)this.getProject().createTask("ant");
        ant.setOwningTarget(this.getOwningTarget());
        ant.setTaskName(this.getTaskName());
        ant.init();
        if (this.target != null && this.target.length() > 0) {
            ant.setTarget(this.target);
        }
        if (this.output != null) {
            ant.setOutput(this.output);
        }
        if (file != null) {
            ant.setDir(file);
        }
        ant.setInheritAll(this.inheritAll);
        Enumeration enumeration = this.properties.elements();
        while (enumeration.hasMoreElements()) {
            SubAnt.copyProperty(ant.createProperty(), (Property)enumeration.nextElement());
        }
        Enumeration enumeration2 = this.propertySets.elements();
        while (enumeration2.hasMoreElements()) {
            ant.addPropertyset((PropertySet)enumeration2.nextElement());
        }
        ant.setInheritRefs(this.inheritRefs);
        Enumeration enumeration3 = this.references.elements();
        while (enumeration3.hasMoreElements()) {
            ant.addReference((Ant.Reference)enumeration3.nextElement());
        }
        return ant;
    }

    private static void copyProperty(Property property, Property property2) {
        property.setName(property2.getName());
        if (property2.getValue() != null) {
            property.setValue(property2.getValue());
        }
        if (property2.getFile() != null) {
            property.setFile(property2.getFile());
        }
        if (property2.getResource() != null) {
            property.setResource(property2.getResource());
        }
        if (property2.getPrefix() != null) {
            property.setPrefix(property2.getPrefix());
        }
        if (property2.getRefid() != null) {
            property.setRefid(property2.getRefid());
        }
        if (property2.getEnvironment() != null) {
            property.setEnvironment(property2.getEnvironment());
        }
        if (property2.getClasspath() != null) {
            property.setClasspath(property2.getClasspath());
        }
    }
}

