/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    public static final String WARN = "warn";
    public static final String FAIL = "fail";
    public static final String TRUNCATE = "truncate";
    public static final String GNU = "gnu";
    public static final String OMIT = "omit";
    File tarFile;
    File baseDir;
    private TarLongFileMode longFileMode = new TarLongFileMode();
    Vector filesets = new Vector();
    Vector fileSetFiles = new Vector();
    private boolean longWarningGiven = false;
    private TarCompressionMethod compression = new TarCompressionMethod();

    public TarFileSet createTarFileSet() {
        TarFileSet tarFileSet = new TarFileSet();
        this.filesets.addElement(tarFileSet);
        return tarFileSet;
    }

    public void setTarfile(File file) {
        this.tarFile = file;
    }

    public void setDestFile(File file) {
        this.tarFile = file;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setLongfile(String string) {
        this.log("DEPRECATED - The setLongfile(String) method has been deprecated. Use setLongfile(Tar.TarLongFileMode) instead.");
        this.longFileMode = new TarLongFileMode();
        this.longFileMode.setValue(string);
    }

    public void setLongfile(TarLongFileMode tarLongFileMode) {
        this.longFileMode = tarLongFileMode;
    }

    public void setCompression(TarCompressionMethod tarCompressionMethod) {
        this.compression = tarCompressionMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Vector vector;
        block27: {
            if (this.tarFile == null) {
                throw new BuildException("tarfile attribute must be set!", this.getLocation());
            }
            if (this.tarFile.exists() && this.tarFile.isDirectory()) {
                throw new BuildException("tarfile is a directory!", this.getLocation());
            }
            if (this.tarFile.exists() && !this.tarFile.canWrite()) {
                throw new BuildException("Can not write to the specified tarfile!", this.getLocation());
            }
            vector = (Vector)this.filesets.clone();
            try {
                Object object;
                Object object2;
                if (this.baseDir != null) {
                    if (!this.baseDir.exists()) {
                        throw new BuildException("basedir does not exist!", this.getLocation());
                    }
                    TarFileSet tarFileSet = new TarFileSet(this.fileset);
                    tarFileSet.setDir(this.baseDir);
                    this.filesets.addElement(tarFileSet);
                }
                if (this.filesets.size() == 0) {
                    throw new BuildException("You must supply either a basedir attribute or some nested filesets.", this.getLocation());
                }
                boolean bl = true;
                Enumeration enumeration = this.filesets.elements();
                block9: while (true) {
                    if (!enumeration.hasMoreElements()) {
                        if (!bl) break;
                        this.log("Nothing to do: " + this.tarFile.getAbsolutePath() + " is up to date.", 2);
                        Object var15_12 = null;
                        this.filesets = vector;
                        return;
                    }
                    object2 = (TarFileSet)enumeration.nextElement();
                    object = ((TarFileSet)object2).getFiles(this.getProject());
                    if (!this.archiveIsUpToDate((String[])object, ((AbstractFileSet)object2).getDir(this.getProject()))) {
                        bl = false;
                    }
                    int n = 0;
                    while (true) {
                        if (n >= ((String[])object).length) continue block9;
                        if (this.tarFile.equals(new File(((AbstractFileSet)object2).getDir(this.getProject()), object[n]))) {
                            throw new BuildException("A tar file cannot include itself", this.getLocation());
                        }
                        ++n;
                    }
                    break;
                }
                this.log("Building tar: " + this.tarFile.getAbsolutePath(), 2);
                object2 = null;
                try {
                    try {
                        object2 = new TarOutputStream(this.compression.compress(new BufferedOutputStream(new FileOutputStream(this.tarFile))));
                        ((TarOutputStream)object2).setDebug(true);
                        if (this.longFileMode.isTruncateMode()) {
                            ((TarOutputStream)object2).setLongFileMode(1);
                        } else if (this.longFileMode.isFailMode() || this.longFileMode.isOmitMode()) {
                            ((TarOutputStream)object2).setLongFileMode(0);
                        } else {
                            ((TarOutputStream)object2).setLongFileMode(2);
                        }
                        this.longWarningGiven = false;
                        object = this.filesets.elements();
                        while (object.hasMoreElements()) {
                            TarFileSet tarFileSet = (TarFileSet)object.nextElement();
                            String[] stringArray = tarFileSet.getFiles(this.getProject());
                            if (stringArray.length > 1 && tarFileSet.getFullpath().length() > 0) {
                                throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
                            }
                            int n = 0;
                            while (n < stringArray.length) {
                                File file = new File(tarFileSet.getDir(this.getProject()), stringArray[n]);
                                String string = stringArray[n].replace(File.separatorChar, '/');
                                this.tarFile(file, (TarOutputStream)object2, string, tarFileSet);
                                ++n;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        String string = "Problem creating TAR: " + iOException.getMessage();
                        throw new BuildException(string, iOException, this.getLocation());
                    }
                    Object var12_19 = null;
                    if (object2 == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    if (object2 == null) throw throwable;
                    try {
                        ((TarOutputStream)object2).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                ((TarOutputStream)object2).close();
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                this.filesets = vector;
                throw throwable;
            }
        }
        Object var15_13 = null;
        this.filesets = vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tarFile(File file, TarOutputStream tarOutputStream, String string, TarFileSet tarFileSet) throws IOException {
        FileInputStream fileInputStream;
        block20: {
            block19: {
                fileInputStream = null;
                String string2 = tarFileSet.getFullpath();
                if (string2.length() > 0) {
                    string = string2;
                } else {
                    String string3;
                    if (string.length() <= 0) {
                        return;
                    }
                    if (file.isDirectory() && !string.endsWith("/")) {
                        string = string + "/";
                    }
                    if ((string3 = tarFileSet.getPrefix()).length() > 0 && !string3.endsWith("/")) {
                        string3 = string3 + "/";
                    }
                    string = string3 + string;
                }
                if (string.startsWith("/") && !tarFileSet.getPreserveLeadingSlashes()) {
                    int n = string.length();
                    if (n <= 1) {
                        return;
                    }
                    string = string.substring(1, n);
                }
                try {
                    if (string.length() >= 100) {
                        if (this.longFileMode.isOmitMode()) {
                            this.log("Omitting: " + string, 2);
                            Object var11_10 = null;
                            if (fileInputStream == null) return;
                            break block19;
                        }
                        if (this.longFileMode.isWarnMode()) {
                            this.log("Entry: " + string + " longer than " + 100 + " characters.", 1);
                            if (!this.longWarningGiven) {
                                this.log("Resulting tar file can only be processed successfully by GNU compatible tar commands", 1);
                                this.longWarningGiven = true;
                            }
                        } else if (this.longFileMode.isFailMode()) {
                            throw new BuildException("Entry: " + string + " longer than " + 100 + "characters.", this.getLocation());
                        }
                    }
                    TarEntry tarEntry = new TarEntry(string);
                    tarEntry.setModTime(file.lastModified());
                    if (!file.isDirectory()) {
                        tarEntry.setSize(file.length());
                        tarEntry.setMode(tarFileSet.getMode());
                    } else {
                        tarEntry.setMode(tarFileSet.getDirMode());
                    }
                    tarEntry.setUserName(tarFileSet.getUserName());
                    tarEntry.setGroupName(tarFileSet.getGroup());
                    tarEntry.setUserId(tarFileSet.getUid());
                    tarEntry.setGroupId(tarFileSet.getGid());
                    tarOutputStream.putNextEntry(tarEntry);
                    if (!file.isDirectory()) {
                        fileInputStream = new FileInputStream(file);
                        byte[] byArray = new byte[8192];
                        int n = 0;
                        do {
                            tarOutputStream.write(byArray, 0, n);
                        } while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1);
                    }
                    tarOutputStream.closeEntry();
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (fileInputStream == null) throw throwable;
                    fileInputStream.close();
                    throw throwable;
                }
            }
            fileInputStream.close();
            return;
        }
        Object var11_11 = null;
        if (fileInputStream == null) return;
        fileInputStream.close();
    }

    protected boolean archiveIsUpToDate(String[] stringArray) {
        return this.archiveIsUpToDate(stringArray, this.baseDir);
    }

    protected boolean archiveIsUpToDate(String[] stringArray, File file) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        MergingMapper mergingMapper = new MergingMapper();
        mergingMapper.setTo(this.tarFile.getAbsolutePath());
        return sourceFileScanner.restrict(stringArray, file, null, mergingMapper).length == 0;
    }

    public static final class TarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public TarCompressionMethod() {
            this.setValue(NONE);
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private OutputStream compress(OutputStream outputStream) throws IOException {
            String string = this.getValue();
            if (GZIP.equals(string)) {
                return new GZIPOutputStream(outputStream);
            }
            if (BZIP2.equals(string)) {
                outputStream.write(66);
                outputStream.write(90);
                return new CBZip2OutputStream(outputStream);
            }
            return outputStream;
        }
    }

    public static class TarFileSet
    extends FileSet {
        private String[] files = null;
        private int fileMode = 33188;
        private int dirMode = 16877;
        private String userName = "";
        private String groupName = "";
        private int uid;
        private int gid;
        private String prefix = "";
        private String fullpath = "";
        private boolean preserveLeadingSlashes = false;

        public TarFileSet(FileSet fileSet) {
            super(fileSet);
        }

        public TarFileSet() {
        }

        public String[] getFiles(Project project) {
            if (this.files == null) {
                DirectoryScanner directoryScanner = this.getDirectoryScanner(project);
                String[] stringArray = directoryScanner.getIncludedDirectories();
                String[] stringArray2 = directoryScanner.getIncludedFiles();
                this.files = new String[stringArray.length + stringArray2.length];
                System.arraycopy(stringArray, 0, this.files, 0, stringArray.length);
                System.arraycopy(stringArray2, 0, this.files, stringArray.length, stringArray2.length);
            }
            return this.files;
        }

        public void setMode(String string) {
            this.fileMode = 0x8000 | Integer.parseInt(string, 8);
        }

        public int getMode() {
            return this.fileMode;
        }

        public void setDirMode(String string) {
            this.dirMode = 0x4000 | Integer.parseInt(string, 8);
        }

        public int getDirMode() {
            return this.dirMode;
        }

        public void setUserName(String string) {
            this.userName = string;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUid(int n) {
            this.uid = n;
        }

        public int getUid() {
            return this.uid;
        }

        public void setGroup(String string) {
            this.groupName = string;
        }

        public String getGroup() {
            return this.groupName;
        }

        public void setGid(int n) {
            this.gid = n;
        }

        public int getGid() {
            return this.gid;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setFullpath(String string) {
            this.fullpath = string;
        }

        public String getFullpath() {
            return this.fullpath;
        }

        public void setPreserveLeadingSlashes(boolean bl) {
            this.preserveLeadingSlashes = bl;
        }

        public boolean getPreserveLeadingSlashes() {
            return this.preserveLeadingSlashes;
        }
    }

    public static class TarLongFileMode
    extends EnumeratedAttribute {
        public static final String WARN = "warn";
        public static final String FAIL = "fail";
        public static final String TRUNCATE = "truncate";
        public static final String GNU = "gnu";
        public static final String OMIT = "omit";
        private final String[] validModes = new String[]{"warn", "fail", "truncate", "gnu", "omit"};

        public TarLongFileMode() {
            this.setValue("warn");
        }

        public String[] getValues() {
            return this.validModes;
        }

        public boolean isTruncateMode() {
            return "truncate".equalsIgnoreCase(this.getValue());
        }

        public boolean isWarnMode() {
            return "warn".equalsIgnoreCase(this.getValue());
        }

        public boolean isGnuMode() {
            return "gnu".equalsIgnoreCase(this.getValue());
        }

        public boolean isFailMode() {
            return "fail".equalsIgnoreCase(this.getValue());
        }

        public boolean isOmitMode() {
            return "omit".equalsIgnoreCase(this.getValue());
        }
    }
}

