/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class Tstamp
extends Task {
    private Vector customFormats = new Vector();
    private String prefix = "";

    public void setPrefix(String string) {
        this.prefix = string;
        if (!this.prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }

    public void execute() throws BuildException {
        try {
            Object object;
            Date date = new Date();
            Enumeration enumeration = this.customFormats.elements();
            while (enumeration.hasMoreElements()) {
                object = (CustomFormat)enumeration.nextElement();
                ((CustomFormat)object).execute(this.getProject(), date, this.getLocation());
            }
            object = new SimpleDateFormat("yyyyMMdd");
            this.setProperty("DSTAMP", ((DateFormat)object).format(date));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmm");
            this.setProperty("TSTAMP", simpleDateFormat.format(date));
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MMMM d yyyy", Locale.US);
            this.setProperty("TODAY", simpleDateFormat2.format(date));
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
    }

    public CustomFormat createFormat() {
        CustomFormat customFormat = new CustomFormat();
        this.customFormats.addElement(customFormat);
        return customFormat;
    }

    private void setProperty(String string, String string2) {
        this.getProject().setNewProperty(this.prefix + string, string2);
    }

    public class CustomFormat {
        private TimeZone timeZone;
        private String propertyName;
        private String pattern;
        private String language;
        private String country;
        private String variant;
        private int offset = 0;
        private int field = 5;

        public void setProperty(String string) {
            this.propertyName = string;
        }

        public void setPattern(String string) {
            this.pattern = string;
        }

        public void setLocale(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,");
            try {
                this.language = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreElements()) {
                    this.country = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreElements()) {
                        this.variant = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreElements()) {
                            throw new BuildException("bad locale format", Tstamp.this.getLocation());
                        }
                    }
                } else {
                    this.country = "";
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new BuildException("bad locale format", noSuchElementException, Tstamp.this.getLocation());
            }
        }

        public void setTimezone(String string) {
            this.timeZone = TimeZone.getTimeZone(string);
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public void setUnit(String string) {
            Tstamp.this.log("DEPRECATED - The setUnit(String) method has been deprecated. Use setUnit(Tstamp.Unit) instead.");
            Unit unit = new Unit();
            unit.setValue(string);
            this.field = unit.getCalendarField();
        }

        public void setUnit(Unit unit) {
            this.field = unit.getCalendarField();
        }

        public void execute(Project project, Date date, Location location) {
            if (this.propertyName == null) {
                throw new BuildException("property attribute must be provided", location);
            }
            if (this.pattern == null) {
                throw new BuildException("pattern attribute must be provided", location);
            }
            SimpleDateFormat simpleDateFormat = this.language == null ? new SimpleDateFormat(this.pattern) : (this.variant == null ? new SimpleDateFormat(this.pattern, new Locale(this.language, this.country)) : new SimpleDateFormat(this.pattern, new Locale(this.language, this.country, this.variant)));
            if (this.offset != 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(this.field, this.offset);
                date = calendar.getTime();
            }
            if (this.timeZone != null) {
                simpleDateFormat.setTimeZone(this.timeZone);
            }
            Tstamp.this.setProperty(this.propertyName, simpleDateFormat.format(date));
        }
    }

    public static class Unit
    extends EnumeratedAttribute {
        private static final String MILLISECOND = "millisecond";
        private static final String SECOND = "second";
        private static final String MINUTE = "minute";
        private static final String HOUR = "hour";
        private static final String DAY = "day";
        private static final String WEEK = "week";
        private static final String MONTH = "month";
        private static final String YEAR = "year";
        private static final String[] units = new String[]{"millisecond", "second", "minute", "hour", "day", "week", "month", "year"};
        private Hashtable calendarFields = new Hashtable();

        public Unit() {
            this.calendarFields.put(MILLISECOND, new Integer(14));
            this.calendarFields.put(SECOND, new Integer(13));
            this.calendarFields.put(MINUTE, new Integer(12));
            this.calendarFields.put(HOUR, new Integer(11));
            this.calendarFields.put(DAY, new Integer(5));
            this.calendarFields.put(WEEK, new Integer(3));
            this.calendarFields.put(MONTH, new Integer(2));
            this.calendarFields.put(YEAR, new Integer(1));
        }

        public int getCalendarField() {
            String string = this.getValue().toLowerCase();
            Integer n = (Integer)this.calendarFields.get(string);
            return n;
        }

        public String[] getValues() {
            return units;
        }
    }
}

