/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Untar
extends Expand {
    private UntarCompressionMethod compression = new UntarCompressionMethod();

    public void setCompression(UntarCompressionMethod untarCompressionMethod) {
        this.compression = untarCompressionMethod;
    }

    public void setEncoding(String string) {
        throw new BuildException("The " + this.getTaskName() + " task doesn't support the encoding" + " attribute", this.getLocation());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expandFile(FileUtils fileUtils, File file, File file2) {
        TarInputStream tarInputStream = null;
        try {
            try {
                this.log("Expanding: " + file + " into " + file2, 2);
                tarInputStream = new TarInputStream(this.compression.decompress(file, new BufferedInputStream(new FileInputStream(file))));
                TarEntry tarEntry = null;
                while (true) {
                    if ((tarEntry = tarInputStream.getNextEntry()) == null) {
                        this.log("expand complete", 3);
                        break;
                    }
                    this.extractFile(fileUtils, file, file2, tarInputStream, tarEntry.getName(), tarEntry.getModTime(), tarEntry.isDirectory());
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error while expanding " + file.getPath(), iOException, this.getLocation());
            }
            Object var7_7 = null;
            if (tarInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (tarInputStream == null) throw throwable;
            try {
                tarInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        tarInputStream.close();
        return;
    }

    public static final class UntarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public UntarCompressionMethod() {
            this.setValue(NONE);
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private InputStream decompress(File file, InputStream inputStream) throws IOException, BuildException {
            String string = this.getValue();
            if (GZIP.equals(string)) {
                return new GZIPInputStream(inputStream);
            }
            if (BZIP2.equals(string)) {
                char[] cArray = new char[]{'B', 'Z'};
                int n = 0;
                while (n < cArray.length) {
                    if (inputStream.read() != cArray[n]) {
                        throw new BuildException("Invalid bz2 file." + file.toString());
                    }
                    ++n;
                }
                return new CBZip2InputStream(inputStream);
            }
            return inputStream;
        }
    }
}

