/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Zip
extends MatchingTask {
    protected File zipFile;
    private ZipScanner zs;
    private File baseDir;
    protected Hashtable entries = new Hashtable();
    private Vector groupfilesets = new Vector();
    private Vector filesetsFromGroupfilesets = new Vector();
    protected String duplicate = "add";
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    private boolean doFilesonly = false;
    protected String archiveType = "zip";
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    protected Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    private static FileUtils fileUtils = FileUtils.newFileUtils();
    private boolean addingNewFiles = false;
    private String encoding;
    private boolean keepCompression = false;
    private boolean roundUp = true;

    public void setZipfile(File file) {
        this.setDestFile(file);
    }

    public void setFile(File file) {
        this.setDestFile(file);
    }

    public void setDestFile(File file) {
        this.zipFile = file;
    }

    public File getDestFile() {
        return this.zipFile;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setCompress(boolean bl) {
        this.doCompress = bl;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public void setFilesonly(boolean bl) {
        this.doFilesonly = bl;
    }

    public void setUpdate(boolean bl) {
        this.doUpdate = bl;
        this.savedDoUpdate = bl;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addZipfileset(ZipFileSet zipFileSet) {
        this.filesets.addElement(zipFileSet);
    }

    public void addZipGroupFileset(FileSet fileSet) {
        this.groupfilesets.addElement(fileSet);
    }

    public void setDuplicate(Duplicate duplicate) {
        this.duplicate = duplicate.getValue();
    }

    public void setWhenempty(WhenEmpty whenEmpty) {
        this.emptyBehavior = whenEmpty.getValue();
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setKeepCompression(boolean bl) {
        this.keepCompression = bl;
    }

    public void setRoundUp(boolean bl) {
        this.roundUp = bl;
    }

    public void execute() throws BuildException {
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.executeMain();
            this.skipWriting = false;
            this.executeMain();
        } else {
            this.executeMain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMain() throws BuildException {
        Object object;
        Object object2;
        Object object3;
        Cloneable cloneable;
        if (this.baseDir == null && this.filesets.size() == 0 && this.groupfilesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new BuildException(this.zipFile + " is not a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new BuildException(this.zipFile + " is read-only.");
        }
        File file = null;
        this.addingNewFiles = true;
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.log("ignoring update attribute as " + this.archiveType + " doesn't exist.", 4);
        }
        int n = 0;
        while (n < this.groupfilesets.size()) {
            this.log("Processing groupfileset ", 3);
            cloneable = (FileSet)this.groupfilesets.elementAt(n);
            object3 = ((AbstractFileSet)cloneable).getDirectoryScanner(this.getProject());
            object2 = object3.getIncludedFiles();
            File file2 = object3.getBasedir();
            int n2 = 0;
            while (n2 < ((Object[])object2).length) {
                this.log("Adding file " + (String)object2[n2] + " to fileset", 3);
                object = new ZipFileSet();
                ((ProjectComponent)object).setProject(this.getProject());
                ((ZipFileSet)object).setSrc(new File(file2, (String)object2[n2]));
                this.filesets.addElement(object);
                this.filesetsFromGroupfilesets.addElement(object);
                ++n2;
            }
            ++n;
        }
        cloneable = new Vector();
        if (this.baseDir != null) {
            object3 = (FileSet)this.getImplicitFileSet().clone();
            ((AbstractFileSet)object3).setDir(this.baseDir);
            ((Vector)cloneable).addElement(object3);
        }
        int n3 = 0;
        while (n3 < this.filesets.size()) {
            object2 = (FileSet)this.filesets.elementAt(n3);
            ((Vector)cloneable).addElement(object2);
            ++n3;
        }
        object2 = new FileSet[((Vector)cloneable).size()];
        ((Vector)cloneable).copyInto((Object[])object2);
        boolean bl = false;
        try {
            try {
                ArchiveState archiveState = this.getResourcesToAdd((FileSet[])object2, this.zipFile, false);
                if (!archiveState.isOutOfDate()) {
                    Object var25_13 = null;
                    this.cleanUp();
                    return;
                }
                object = archiveState.getResourcesToAdd();
                if (this.doUpdate) {
                    file = fileUtils.createTempFile("zip", ".tmp", fileUtils.getParentFile(this.zipFile));
                    file.deleteOnExit();
                    try {
                        fileUtils.rename(this.zipFile, file);
                    }
                    catch (SecurityException securityException) {
                        throw new BuildException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
                    }
                    catch (IOException iOException) {
                        throw new BuildException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
                    }
                }
                String string = this.doUpdate ? "Updating " : "Building ";
                this.log(string + this.archiveType + ": " + this.zipFile.getAbsolutePath());
                ZipOutputStream zipOutputStream = null;
                try {
                    if (!this.skipWriting) {
                        zipOutputStream = new ZipOutputStream(this.zipFile);
                        zipOutputStream.setEncoding(this.encoding);
                        if (this.doCompress) {
                            zipOutputStream.setMethod(8);
                        } else {
                            zipOutputStream.setMethod(0);
                        }
                    }
                    this.initZipOutputStream(zipOutputStream);
                    int n4 = 0;
                    while (n4 < ((Object[])object2).length) {
                        if (((Object)object[n4]).length != 0) {
                            this.addResources((FileSet)object2[n4], (Resource[])object[n4], zipOutputStream);
                        }
                        ++n4;
                    }
                    if (this.doUpdate) {
                        Object object4;
                        this.addingNewFiles = false;
                        ZipFileSet zipFileSet = new ZipFileSet();
                        zipFileSet.setProject(this.getProject());
                        zipFileSet.setSrc(file);
                        int n5 = 0;
                        while (n5 < this.addedFiles.size()) {
                            object4 = zipFileSet.createExclude();
                            ((PatternSet.NameEntry)object4).setName((String)this.addedFiles.elementAt(n5));
                            ++n5;
                        }
                        object4 = zipFileSet.getDirectoryScanner(this.getProject());
                        ((ZipScanner)object4).setEncoding(this.encoding);
                        String[] stringArray = ((DirectoryScanner)object4).getIncludedFiles();
                        Resource[] resourceArray = new Resource[stringArray.length];
                        int n6 = 0;
                        while (n6 < stringArray.length) {
                            resourceArray[n6] = ((DirectoryScanner)object4).getResource(stringArray[n6]);
                            ++n6;
                        }
                        if (!this.doFilesonly) {
                            String[] stringArray2 = ((DirectoryScanner)object4).getIncludedDirectories();
                            Resource[] resourceArray2 = new Resource[stringArray2.length];
                            int n7 = 0;
                            while (n7 < stringArray2.length) {
                                resourceArray2[n7] = ((DirectoryScanner)object4).getResource(stringArray2[n7]);
                                ++n7;
                            }
                            Resource[] resourceArray3 = resourceArray;
                            resourceArray = new Resource[resourceArray3.length + resourceArray2.length];
                            System.arraycopy(resourceArray2, 0, resourceArray, 0, resourceArray2.length);
                            System.arraycopy(resourceArray3, 0, resourceArray, resourceArray2.length, resourceArray3.length);
                        }
                        this.addResources(zipFileSet, resourceArray, zipOutputStream);
                    }
                    this.finalizeZipOutputStream(zipOutputStream);
                    if (this.doUpdate && !file.delete()) {
                        this.log("Warning: unable to delete temporary file " + file.getName(), 1);
                    }
                    bl = true;
                }
                finally {
                    block42: {
                        try {
                            if (zipOutputStream != null) {
                                zipOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (!bl) break block42;
                            throw iOException;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                object = "Problem creating " + this.archiveType + ": " + iOException.getMessage();
                if (!(this.doUpdate && file == null || this.zipFile.delete())) {
                    object = (String)object + " (and the archive is probably corrupt but I could not delete it)";
                }
                if (this.doUpdate && file != null) {
                    try {
                        fileUtils.rename(file, this.zipFile);
                    }
                    catch (IOException iOException2) {
                        object = (String)object + " (and I couldn't rename the temporary file " + file.getName() + " back)";
                    }
                }
                throw new BuildException((String)object, iOException, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            Object var25_15 = null;
            this.cleanUp();
            throw throwable;
        }
        Object var25_14 = null;
        this.cleanUp();
    }

    protected final boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void addResources(FileSet fileSet, Resource[] resourceArray, ZipOutputStream zipOutputStream) throws IOException {
        String string = "";
        String string2 = "";
        int n = 16877;
        int n2 = 33188;
        ZipFileSet zipFileSet = null;
        if (fileSet instanceof ZipFileSet) {
            zipFileSet = (ZipFileSet)fileSet;
            string = zipFileSet.getPrefix(this.getProject());
            string2 = zipFileSet.getFullpath(this.getProject());
            n = zipFileSet.getDirMode(this.getProject());
            n2 = zipFileSet.getFileMode(this.getProject());
        }
        if (string.length() > 0 && string2.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes must not be set on the same fileset.");
        }
        if (resourceArray.length != 1 && string2.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        if (string.length() > 0) {
            if (!string.endsWith("/") && !string.endsWith("\\")) {
                string = string + "/";
            }
            this.addParentDirs(null, string, zipOutputStream, "", n);
        }
        ZipFile zipFile = null;
        try {
            boolean bl = false;
            File file = null;
            if (zipFileSet == null || zipFileSet.getSrc(this.getProject()) == null) {
                bl = true;
                file = fileSet.getDir(this.getProject());
            } else {
                zipFile = new ZipFile(zipFileSet.getSrc(this.getProject()), this.encoding);
            }
            int n3 = 0;
            while (n3 < resourceArray.length) {
                String string3 = null;
                string3 = string2.length() > 0 ? string2 : resourceArray[n3].getName();
                if (!"".equals(string3 = string3.replace(File.separatorChar, '/'))) {
                    ZipEntry zipEntry;
                    if (resourceArray[n3].isDirectory() && !string3.endsWith("/")) {
                        string3 = string3 + "/";
                    }
                    if (!this.doFilesonly && !bl && resourceArray[n3].isDirectory() && !zipFileSet.hasDirModeBeenSet()) {
                        int n4 = string3.lastIndexOf("/", string3.length() - 2);
                        if (n4 != -1) {
                            this.addParentDirs(file, string3.substring(0, n4 + 1), zipOutputStream, string, n);
                        }
                        ZipEntry zipEntry2 = zipFile.getEntry(resourceArray[n3].getName());
                        this.addParentDirs(file, string3, zipOutputStream, string, zipEntry2.getUnixMode());
                    } else {
                        this.addParentDirs(file, string3, zipOutputStream, string, n);
                    }
                    if (!resourceArray[n3].isDirectory() && bl) {
                        File file2 = fileUtils.resolveFile(file, resourceArray[n3].getName());
                        this.zipFile(file2, zipOutputStream, string + string3, n2);
                    } else if (!resourceArray[n3].isDirectory() && (zipEntry = zipFile.getEntry(resourceArray[n3].getName())) != null) {
                        Object var17_19;
                        boolean bl2 = this.doCompress;
                        if (this.keepCompression) {
                            this.doCompress = zipEntry.getMethod() == 8;
                        }
                        try {
                            this.zipFile(zipFile.getInputStream(zipEntry), zipOutputStream, string + string3, zipEntry.getTime(), zipFileSet.getSrc(this.getProject()), zipFileSet.hasFileModeBeenSet() ? n2 : zipEntry.getUnixMode());
                            var17_19 = null;
                            this.doCompress = bl2;
                        }
                        catch (Throwable throwable) {
                            var17_19 = null;
                            this.doCompress = bl2;
                            throw throwable;
                        }
                    }
                }
                ++n3;
            }
            Object var19_21 = null;
            if (zipFile == null) return;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            if (zipFile == null) throw throwable;
            zipFile.close();
            throw throwable;
        }
        zipFile.close();
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected void finalizeZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean createEmptyZip(File file) throws BuildException {
        this.log("Note: creating empty " + this.archiveType + " archive " + file, 2);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[22];
                byArray[0] = 80;
                byArray[1] = 75;
                byArray[2] = 5;
                byArray[3] = 6;
                ((OutputStream)fileOutputStream).write(byArray);
            }
            catch (IOException iOException) {
                throw new BuildException("Could not create empty ZIP archive (" + iOException.getMessage() + ")", iOException, this.getLocation());
            }
            Object var5_5 = null;
            if (fileOutputStream == null) return true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((OutputStream)fileOutputStream).close();
        return true;
    }

    private synchronized ZipScanner getZipScanner() {
        if (this.zs == null) {
            this.zs = new ZipScanner();
            this.zs.setEncoding(this.encoding);
            this.zs.setSrc(this.zipFile);
        }
        return this.zs;
    }

    protected ArchiveState getResourcesToAdd(FileSet[] fileSetArray, File file, boolean bl) throws BuildException {
        Object object;
        Resource[][] resourceArray = this.grabResources(fileSetArray);
        if (Zip.isEmpty(resourceArray)) {
            if (bl && this.doUpdate) {
                return new ArchiveState(true, resourceArray);
            }
            if (this.emptyBehavior.equals("skip")) {
                if (this.doUpdate) {
                    this.log(this.archiveType + " archive " + file + " not updated because no new files were included.", 3);
                } else {
                    this.log("Warning: skipping " + this.archiveType + " archive " + file + " because no files were included.", 1);
                }
            } else {
                if (this.emptyBehavior.equals("fail")) {
                    throw new BuildException("Cannot create " + this.archiveType + " archive " + file + ": no files were included.", this.getLocation());
                }
                this.createEmptyZip(file);
            }
            return new ArchiveState(bl, resourceArray);
        }
        if (!file.exists()) {
            return new ArchiveState(true, resourceArray);
        }
        if (bl && !this.doUpdate) {
            return new ArchiveState(true, resourceArray);
        }
        Resource[][] resourceArray2 = new Resource[fileSetArray.length][];
        int n = 0;
        while (n < fileSetArray.length) {
            if (!(this.fileset instanceof ZipFileSet) || ((ZipFileSet)this.fileset).getSrc(this.getProject()) == null) {
                File file2 = fileSetArray[n].getDir(this.getProject());
                int n2 = 0;
                while (n2 < resourceArray[n].length) {
                    object = fileUtils.resolveFile(file2, resourceArray[n][n2].getName());
                    if (((File)object).equals(file)) {
                        throw new BuildException("A zip file cannot include itself", this.getLocation());
                    }
                    ++n2;
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < fileSetArray.length) {
            if (resourceArray[n3].length == 0) {
                resourceArray2[n3] = new Resource[0];
            } else {
                FileNameMapper fileNameMapper = new IdentityMapper();
                if (fileSetArray[n3] instanceof ZipFileSet) {
                    FileNameMapper fileNameMapper2;
                    object = (ZipFileSet)fileSetArray[n3];
                    if (((ZipFileSet)object).getFullpath(this.getProject()) != null && !((ZipFileSet)object).getFullpath(this.getProject()).equals("")) {
                        fileNameMapper2 = new MergingMapper();
                        ((MergingMapper)fileNameMapper2).setTo(((ZipFileSet)object).getFullpath(this.getProject()));
                        fileNameMapper = fileNameMapper2;
                    } else if (((ZipFileSet)object).getPrefix(this.getProject()) != null && !((ZipFileSet)object).getPrefix(this.getProject()).equals("")) {
                        fileNameMapper2 = new GlobPatternMapper();
                        ((GlobPatternMapper)fileNameMapper2).setFrom("*");
                        String string = ((ZipFileSet)object).getPrefix(this.getProject());
                        if (!string.endsWith("/") && !string.endsWith("\\")) {
                            string = string + "/";
                        }
                        ((GlobPatternMapper)fileNameMapper2).setTo(string + "*");
                        fileNameMapper = fileNameMapper2;
                    }
                }
                object = resourceArray[n3];
                if (this.doFilesonly) {
                    object = this.selectFileResources((Resource[])object);
                }
                resourceArray2[n3] = ResourceUtils.selectOutOfDateSources(this, (Resource[])object, fileNameMapper, this.getZipScanner());
                boolean bl2 = bl = bl || resourceArray2[n3].length > 0;
                if (bl && !this.doUpdate) break;
            }
            ++n3;
        }
        if (bl && !this.doUpdate) {
            return new ArchiveState(true, resourceArray);
        }
        return new ArchiveState(bl, resourceArray2);
    }

    protected Resource[][] grabResources(FileSet[] fileSetArray) {
        Resource[][] resourceArray = new Resource[fileSetArray.length][];
        int n = 0;
        while (n < fileSetArray.length) {
            Object object;
            boolean bl = true;
            if (fileSetArray[n] instanceof ZipFileSet) {
                object = (ZipFileSet)fileSetArray[n];
                boolean bl2 = bl = ((ZipFileSet)object).getPrefix(this.getProject()).equals("") && ((ZipFileSet)object).getFullpath(this.getProject()).equals("");
            }
            if ((object = fileSetArray[n].getDirectoryScanner(this.getProject())) instanceof ZipScanner) {
                ((ZipScanner)object).setEncoding(this.encoding);
            }
            Vector<Resource> vector = new Vector<Resource>();
            String[] stringArray = ((DirectoryScanner)object).getIncludedDirectories();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!"".equals(stringArray[0]) || !bl) {
                    vector.addElement(((DirectoryScanner)object).getResource(stringArray[n2]));
                }
                ++n2;
            }
            String[] stringArray2 = ((DirectoryScanner)object).getIncludedFiles();
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (!"".equals(stringArray2[0]) || !bl) {
                    vector.addElement(((DirectoryScanner)object).getResource(stringArray2[n3]));
                }
                ++n3;
            }
            resourceArray[n] = new Resource[vector.size()];
            vector.copyInto(resourceArray[n]);
            ++n;
        }
        return resourceArray;
    }

    protected void zipDir(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        if (this.addedDirs.get(string) != null) {
            return;
        }
        this.log("adding directory " + string, 3);
        this.addedDirs.put(string, string);
        if (!this.skipWriting) {
            ZipEntry zipEntry = new ZipEntry(string);
            if (file != null && file.exists()) {
                zipEntry.setTime(file.lastModified() + (long)(this.roundUp ? 1999 : 0));
            } else {
                zipEntry.setTime(System.currentTimeMillis() + (long)(this.roundUp ? 1999 : 0));
            }
            zipEntry.setSize(0L);
            zipEntry.setMethod(0);
            zipEntry.setCrc(EMPTY_CRC);
            zipEntry.setUnixMode(n);
            zipOutputStream.putNextEntry(zipEntry);
        }
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l, File file, int n) throws IOException {
        if (this.entries.contains(string)) {
            if (this.duplicate.equals("preserve")) {
                this.log(string + " already added, skipping", 2);
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new BuildException("Duplicate file " + string + " was found and the duplicate " + "attribute is 'fail'.");
            }
            this.log("duplicate file " + string + " found, adding.", 3);
        } else {
            this.log("adding entry " + string, 3);
        }
        this.entries.put(string, string);
        if (!this.skipWriting) {
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setTime(l);
            zipEntry.setMethod(this.doCompress ? 8 : 0);
            if (!zipOutputStream.isSeekable() && !this.doCompress) {
                Object object;
                long l2 = 0L;
                CRC32 cRC32 = new CRC32();
                if (!inputStream.markSupported()) {
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[8192];
                    int n2 = 0;
                    do {
                        l2 += (long)n2;
                        cRC32.update(byArray, 0, n2);
                        ((ByteArrayOutputStream)object).write(byArray, 0, n2);
                    } while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1);
                    inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                } else {
                    inputStream.mark(Integer.MAX_VALUE);
                    object = new byte[8192];
                    int n3 = 0;
                    do {
                        l2 += (long)n3;
                        cRC32.update((byte[])object, 0, n3);
                    } while ((n3 = inputStream.read((byte[])object, 0, ((Object)object).length)) != -1);
                    inputStream.reset();
                }
                zipEntry.setSize(l2);
                zipEntry.setCrc(cRC32.getValue());
            }
            zipEntry.setUnixMode(n);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[8192];
            int n4 = 0;
            do {
                if (n4 == 0) continue;
                zipOutputStream.write(byArray, 0, n4);
            } while ((n4 = inputStream.read(byArray, 0, byArray.length)) != -1);
        }
        this.addedFiles.addElement(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.getLocation());
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, zipOutputStream, string, file.lastModified() + (long)(this.roundUp ? 1999 : 0), null, n);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    protected final void addParentDirs(File file, String string, ZipOutputStream zipOutputStream, String string2, int n) throws IOException {
        if (!this.doFilesonly) {
            String string3;
            Stack<String> stack = new Stack<String>();
            int n2 = string.length();
            while ((n2 = string.lastIndexOf(47, n2 - 1)) != -1) {
                string3 = string.substring(0, n2 + 1);
                if (this.addedDirs.get(string2 + string3) != null) break;
                stack.push(string3);
            }
            while (!stack.isEmpty()) {
                string3 = (String)stack.pop();
                File file2 = null;
                file2 = file != null ? new File(file, string3) : new File(string3);
                this.zipDir(file2, zipOutputStream, string2 + string3, n);
            }
        }
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        Enumeration enumeration = this.filesetsFromGroupfilesets.elements();
        while (enumeration.hasMoreElements()) {
            ZipFileSet zipFileSet = (ZipFileSet)enumeration.nextElement();
            this.filesets.removeElement(zipFileSet);
        }
        this.filesetsFromGroupfilesets.removeAllElements();
    }

    public void reset() {
        this.filesets.removeAllElements();
        this.zipFile = null;
        this.baseDir = null;
        this.groupfilesets.removeAllElements();
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.emptyBehavior = "skip";
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected static final boolean isEmpty(Resource[][] resourceArray) {
        int n = 0;
        while (n < resourceArray.length) {
            if (resourceArray[n].length > 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected Resource[] selectFileResources(Resource[] resourceArray) {
        if (resourceArray.length == 0) {
            return resourceArray;
        }
        Vector<Resource> vector = new Vector<Resource>(resourceArray.length);
        int n = 0;
        while (n < resourceArray.length) {
            if (!resourceArray[n].isDirectory()) {
                vector.addElement(resourceArray[n]);
            } else {
                this.log("Ignoring directory " + resourceArray[n].getName() + " as only files will be added.", 3);
            }
            ++n;
        }
        if (vector.size() != resourceArray.length) {
            Object[] objectArray = new Resource[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return resourceArray;
    }

    public static class ArchiveState {
        private boolean outOfDate;
        private Resource[][] resourcesToAdd;

        ArchiveState(boolean bl, Resource[][] resourceArray) {
            this.outOfDate = bl;
            this.resourcesToAdd = resourceArray;
        }

        public boolean isOutOfDate() {
            return this.outOfDate;
        }

        public Resource[][] getResourcesToAdd() {
            return this.resourcesToAdd;
        }
    }

    public static class Duplicate
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "preserve", "fail"};
        }
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }
}

