/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;

class ChangeLogParser {
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final int GET_PREVIOUS_REV = 5;
    private static final SimpleDateFormat c_inputDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private String m_file;
    private String m_date;
    private String m_author;
    private String m_comment;
    private String m_revision;
    private String m_previousRevision;
    private int m_status = 1;
    private final Hashtable m_entries = new Hashtable();

    ChangeLogParser() {
    }

    CVSEntry[] getEntrySetAsArray() {
        CVSEntry[] cVSEntryArray = new CVSEntry[this.m_entries.size()];
        Enumeration enumeration = this.m_entries.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            cVSEntryArray[n++] = (CVSEntry)enumeration.nextElement();
        }
        return cVSEntryArray;
    }

    public void stdout(String string) {
        switch (this.m_status) {
            case 1: {
                this.reset();
                this.processFile(string);
                break;
            }
            case 4: {
                this.processRevision(string);
                break;
            }
            case 2: {
                this.processDate(string);
                break;
            }
            case 3: {
                this.processComment(string);
                break;
            }
            case 5: {
                this.processGetPreviousRevision(string);
            }
        }
    }

    private void processComment(String string) {
        String string2 = System.getProperty("line.separator");
        if (string.startsWith("======")) {
            int n = this.m_comment.length() - string2.length();
            this.m_comment = this.m_comment.substring(0, n);
            this.saveEntry();
            this.m_status = 1;
        } else if (string.startsWith("----------------------------")) {
            int n = this.m_comment.length() - string2.length();
            this.m_comment = this.m_comment.substring(0, n);
            this.m_status = 5;
        } else {
            this.m_comment = this.m_comment + string + string2;
        }
    }

    private void processFile(String string) {
        if (string.startsWith("Working file:")) {
            this.m_file = string.substring(14, string.length());
            this.m_status = 4;
        }
    }

    private void processRevision(String string) {
        if (string.startsWith("revision")) {
            this.m_revision = string.substring(9);
            this.m_status = 2;
        } else if (string.startsWith("======")) {
            this.m_status = 1;
        }
    }

    private void processDate(String string) {
        if (string.startsWith("date:")) {
            this.m_date = string.substring(6, 25);
            String string2 = string.substring(string.indexOf(";") + 1);
            this.m_author = string2.substring(10, string2.indexOf(";"));
            this.m_status = 3;
            this.m_comment = "";
        }
    }

    private void processGetPreviousRevision(String string) {
        if (!string.startsWith("revision")) {
            throw new IllegalStateException("Unexpected line from CVS: " + string);
        }
        this.m_previousRevision = string.substring(9);
        this.saveEntry();
        this.m_revision = this.m_previousRevision;
        this.m_status = 2;
    }

    private void saveEntry() {
        CVSEntry cVSEntry;
        String string = this.m_date + this.m_author + this.m_comment;
        if (!this.m_entries.containsKey(string)) {
            cVSEntry = new CVSEntry(this.parseDate(this.m_date), this.m_author, this.m_comment);
            this.m_entries.put(string, cVSEntry);
        } else {
            cVSEntry = (CVSEntry)this.m_entries.get(string);
        }
        cVSEntry.addFile(this.m_file, this.m_revision, this.m_previousRevision);
    }

    private Date parseDate(String string) {
        try {
            return c_inputDate.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private void reset() {
        this.m_file = null;
        this.m_date = null;
        this.m_author = null;
        this.m_comment = null;
        this.m_revision = null;
        this.m_previousRevision = null;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        c_inputDate.setTimeZone(timeZone);
    }
}

