/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogParser;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogWriter;
import org.apache.tools.ant.taskdefs.cvslib.CvsUser;
import org.apache.tools.ant.taskdefs.cvslib.CvsVersion;
import org.apache.tools.ant.taskdefs.cvslib.RedirectingStreamHandler;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;

public class ChangeLogTask
extends AbstractCvsTask {
    private File m_usersFile;
    private Vector m_cvsUsers = new Vector();
    private File m_dir;
    private File m_destfile;
    private Date m_start;
    private Date m_stop;
    private final Vector m_filesets = new Vector();

    public void setDir(File file) {
        this.m_dir = file;
    }

    public void setDestfile(File file) {
        this.m_destfile = file;
    }

    public void setUsersfile(File file) {
        this.m_usersFile = file;
    }

    public void addUser(CvsUser cvsUser) {
        this.m_cvsUsers.addElement(cvsUser);
    }

    public void setStart(Date date) {
        this.m_start = date;
    }

    public void setEnd(Date date) {
        this.m_stop = date;
    }

    public void setDaysinpast(int n) {
        long l = System.currentTimeMillis() - (long)n * 24L * 60L * 60L * 1000L;
        this.setStart(new Date(l));
    }

    public void addFileset(FileSet fileSet) {
        this.m_filesets.addElement(fileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File file = this.m_dir;
        try {
            Object[] objectArray;
            Object object;
            Object object2;
            Object object3;
            this.validate();
            Properties properties = new Properties();
            this.loadUserlist(properties);
            Enumeration enumeration = this.m_cvsUsers.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (CvsUser)enumeration.nextElement();
                ((CvsUser)object3).validate();
                properties.put(((CvsUser)object3).getUserID(), ((CvsUser)object3).getDisplayname());
            }
            this.setCommand("log");
            if (this.getTag() != null) {
                object3 = new CvsVersion();
                ((ProjectComponent)object3).setProject(this.getProject());
                ((Task)object3).setTaskName("cvsversion");
                ((AbstractCvsTask)object3).setCvsRoot(this.getCvsRoot());
                ((AbstractCvsTask)object3).setCvsRsh(this.getCvsRsh());
                ((AbstractCvsTask)object3).setPassfile(this.getPassFile());
                ((AbstractCvsTask)object3).setDest(this.m_dir);
                ((CvsVersion)object3).execute();
                if (((CvsVersion)object3).supportsCvsLogWithSOption()) {
                    this.addCommandArgument("-S");
                }
            }
            if (null != this.m_start) {
                object3 = new SimpleDateFormat("yyyy-MM-dd");
                object2 = ">=" + ((DateFormat)object3).format(this.m_start);
                this.addCommandArgument("-d");
                this.addCommandArgument((String)object2);
            }
            if (!this.m_filesets.isEmpty()) {
                object3 = this.m_filesets.elements();
                while (object3.hasMoreElements()) {
                    object2 = (FileSet)object3.nextElement();
                    object = ((AbstractFileSet)object2).getDirectoryScanner(this.getProject());
                    objectArray = ((DirectoryScanner)object).getIncludedFiles();
                    int n = 0;
                    while (n < objectArray.length) {
                        this.addCommandArgument(objectArray[n]);
                        ++n;
                    }
                }
            }
            object3 = new ChangeLogParser();
            object2 = new RedirectingStreamHandler((ChangeLogParser)object3);
            this.log(this.getCommand(), 3);
            this.setDest(this.m_dir);
            this.setExecuteStreamHandler((ExecuteStreamHandler)object2);
            super.execute();
            object = ((RedirectingStreamHandler)object2).getErrors();
            if (null != object) {
                this.log((String)object, 0);
            }
            objectArray = ((ChangeLogParser)object3).getEntrySetAsArray();
            CVSEntry[] cVSEntryArray = this.filterEntrySet((CVSEntry[])objectArray);
            this.replaceAuthorIdWithName(properties, cVSEntryArray);
            this.writeChangeLog(cVSEntryArray);
            Object var10_10 = null;
            this.m_dir = file;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.m_dir = file;
            throw throwable;
        }
    }

    private void validate() throws BuildException {
        if (null == this.m_dir) {
            this.m_dir = this.getProject().getBaseDir();
        }
        if (null == this.m_destfile) {
            String string = "Destfile must be set.";
            throw new BuildException("Destfile must be set.");
        }
        if (!this.m_dir.exists()) {
            String string = "Cannot find base dir " + this.m_dir.getAbsolutePath();
            throw new BuildException(string);
        }
        if (null != this.m_usersFile && !this.m_usersFile.exists()) {
            String string = "Cannot find user lookup list " + this.m_usersFile.getAbsolutePath();
            throw new BuildException(string);
        }
    }

    private void loadUserlist(Properties properties) throws BuildException {
        if (null != this.m_usersFile) {
            try {
                properties.load(new FileInputStream(this.m_usersFile));
            }
            catch (IOException iOException) {
                throw new BuildException(iOException.toString(), iOException);
            }
        }
    }

    private CVSEntry[] filterEntrySet(CVSEntry[] cVSEntryArray) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < cVSEntryArray.length) {
            object = cVSEntryArray[n];
            Date date = ((CVSEntry)object).getDate();
            if (!(null != this.m_start && this.m_start.after(date) || null != this.m_stop && this.m_stop.before(date))) {
                vector.addElement(object);
            }
            ++n;
        }
        object = new CVSEntry[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private void replaceAuthorIdWithName(Properties properties, CVSEntry[] cVSEntryArray) {
        int n = 0;
        while (n < cVSEntryArray.length) {
            CVSEntry cVSEntry = cVSEntryArray[n];
            if (properties.containsKey(cVSEntry.getAuthor())) {
                cVSEntry.setAuthor(properties.getProperty(cVSEntry.getAuthor()));
            }
            ++n;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeChangeLog(CVSEntry[] cVSEntryArray) throws BuildException {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(this.m_destfile);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        ChangeLogWriter changeLogWriter = new ChangeLogWriter();
        changeLogWriter.printChangeLog(printWriter, cVSEntryArray);
        Object var6_7 = null;
        if (null == fileOutputStream) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.getProject().log(unsupportedEncodingException.toString(), 0);
                Object var6_8 = null;
                if (null == fileOutputStream) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                throw new BuildException(iOException.toString(), iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (null == fileOutputStream) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

