/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.TimeZone;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import org.apache.tools.ant.taskdefs.cvslib.RCSFile;

class ChangeLogWriter {
    private static final SimpleDateFormat c_outputDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat c_outputTime = new SimpleDateFormat("HH:mm");

    ChangeLogWriter() {
    }

    public void printChangeLog(PrintWriter printWriter, CVSEntry[] cVSEntryArray) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<changelog>");
        int n = 0;
        while (n < cVSEntryArray.length) {
            CVSEntry cVSEntry = cVSEntryArray[n];
            this.printEntry(printWriter, cVSEntry);
            ++n;
        }
        printWriter.println("</changelog>");
        printWriter.flush();
        printWriter.close();
    }

    private void printEntry(PrintWriter printWriter, CVSEntry cVSEntry) {
        printWriter.println("\t<entry>");
        printWriter.println("\t\t<date>" + c_outputDate.format(cVSEntry.getDate()) + "</date>");
        printWriter.println("\t\t<time>" + c_outputTime.format(cVSEntry.getDate()) + "</time>");
        printWriter.println("\t\t<author><![CDATA[" + cVSEntry.getAuthor() + "]]></author>");
        Enumeration enumeration = cVSEntry.getFiles().elements();
        while (enumeration.hasMoreElements()) {
            RCSFile rCSFile = (RCSFile)enumeration.nextElement();
            printWriter.println("\t\t<file>");
            printWriter.println("\t\t\t<name>" + rCSFile.getName() + "</name>");
            printWriter.println("\t\t\t<revision>" + rCSFile.getRevision() + "</revision>");
            String string = rCSFile.getPreviousRevision();
            if (string != null) {
                printWriter.println("\t\t\t<prevrevision>" + string + "</prevrevision>");
            }
            printWriter.println("\t\t</file>");
        }
        printWriter.println("\t\t<msg><![CDATA[" + cVSEntry.getComment() + "]]></msg>");
        printWriter.println("\t</entry>");
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        c_outputDate.setTimeZone(timeZone);
        c_outputTime.setTimeZone(timeZone);
    }
}

