/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.email.Mailer;
import org.apache.tools.mail.MailMessage;

class PlainMailer
extends Mailer {
    PlainMailer() {
    }

    public void send() {
        try {
            MailMessage mailMessage = new MailMessage(this.host, this.port);
            mailMessage.from(this.from.toString());
            Enumeration enumeration = this.replyToList.elements();
            while (enumeration.hasMoreElements()) {
                mailMessage.replyto(enumeration.nextElement().toString());
            }
            enumeration = this.toList.elements();
            while (enumeration.hasMoreElements()) {
                mailMessage.to(enumeration.nextElement().toString());
            }
            enumeration = this.ccList.elements();
            while (enumeration.hasMoreElements()) {
                mailMessage.cc(enumeration.nextElement().toString());
            }
            enumeration = this.bccList.elements();
            while (enumeration.hasMoreElements()) {
                mailMessage.bcc(enumeration.nextElement().toString());
            }
            if (this.subject != null) {
                mailMessage.setSubject(this.subject);
            }
            mailMessage.setHeader("Date", this.getDate());
            if (this.message.getCharset() != null) {
                mailMessage.setHeader("Content-Type", this.message.getMimeType() + "; charset=\"" + this.message.getCharset() + "\"");
            } else {
                mailMessage.setHeader("Content-Type", this.message.getMimeType());
            }
            PrintStream printStream = mailMessage.getPrintStream();
            this.message.print(printStream);
            enumeration = this.files.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                this.attach(file, printStream);
            }
            mailMessage.sendAndClose();
        }
        catch (IOException iOException) {
            throw new BuildException("IO error sending mail", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attach(File file, PrintStream printStream) throws IOException {
        int n;
        if (!file.exists() || !file.canRead()) {
            throw new BuildException("File \"" + file.getName() + "\" does not exist or is not " + "readable.");
        }
        if (this.includeFileNames) {
            printStream.println();
            String string = file.getName();
            n = string.length();
            printStream.println(string);
            int n2 = 0;
            while (n2 < n) {
                printStream.print('=');
                ++n2;
            }
            printStream.println();
        }
        n = 1024;
        byte[] byArray = new byte[1024];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n3;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, byArray.length);
            while ((n3 = bufferedInputStream.read(byArray)) != -1) {
                printStream.write(byArray, 0, n3);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }
}

