/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Path
extends DataType
implements Cloneable {
    private Vector elements;
    public static Path systemClasspath = new Path(null, System.getProperty("java.class.path"));
    public static Path systemBootClasspath = new Path(null, System.getProperty("sun.boot.class.path"));

    public Path(Project project, String string) {
        this(project);
        this.createPathElement().setPath(string);
    }

    public Path(Project project) {
        this.setProject(project);
        this.elements = new Vector();
    }

    public void setLocation(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setLocation(file);
    }

    public void setPath(String string) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setPath(string);
    }

    public void setRefid(Reference reference) throws BuildException {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        this.elements.addElement(reference);
        super.setRefid(reference);
    }

    public PathElement createPathElement() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PathElement pathElement = new PathElement();
        this.elements.addElement(pathElement);
        return pathElement;
    }

    public void addFileset(FileSet fileSet) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(fileSet);
        this.setChecked(false);
    }

    public void addFilelist(FileList fileList) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(fileList);
        this.setChecked(false);
    }

    public void addDirset(DirSet dirSet) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(dirSet);
        this.setChecked(false);
    }

    public void add(Path path) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(path);
        this.setChecked(false);
    }

    public Path createPath() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Path path = new Path(this.getProject());
        this.elements.addElement(path);
        this.setChecked(false);
        return path;
    }

    public void append(Path path) {
        if (path == null) {
            return;
        }
        String[] stringArray = path.list();
        int n = 0;
        while (n < stringArray.length) {
            if (this.elements.indexOf(stringArray[n]) == -1) {
                this.elements.addElement(stringArray[n]);
            }
            ++n;
        }
    }

    public void addExisting(Path path) {
        this.addExisting(path, false);
    }

    public void addExisting(Path path, boolean bl) {
        String[] stringArray = path.list();
        File file = bl ? new File(System.getProperty("user.dir")) : null;
        int n = 0;
        while (n < stringArray.length) {
            File file2 = null;
            file2 = this.getProject() != null ? this.getProject().resolveFile(stringArray[n]) : new File(stringArray[n]);
            if (bl && !file2.exists()) {
                file2 = new File(file, stringArray[n]);
            }
            if (file2.exists()) {
                this.setLocation(file2);
            } else {
                this.log("dropping " + file2 + " from path as it doesn't exist", 3);
            }
            ++n;
        }
    }

    public String[] list() {
        Object object;
        Vector vector;
        if (!this.isChecked()) {
            vector = new Stack<Path>();
            ((Stack)vector).push(this);
            this.dieOnCircularReference((Stack)vector, this.getProject());
        }
        vector = new Vector(2 * this.elements.size());
        int n = 0;
        while (n < this.elements.size()) {
            File file;
            Object object2;
            object = this.elements.elementAt(n);
            if (object instanceof Reference && !((object = ((Reference)(object2 = (String[])object)).getReferencedObject(this.getProject())) instanceof Path)) {
                String string = ((Reference)object2).getRefId() + " doesn't denote a path " + object;
                throw new BuildException(string);
            }
            if (object instanceof String) {
                Path.addUnlessPresent(vector, (String)object);
            } else if (object instanceof PathElement) {
                object2 = ((PathElement)object).getParts();
                if (object2 == null) {
                    throw new BuildException("You must either set location or path on <pathelement>");
                }
                int n2 = 0;
                while (n2 < ((Object)object2).length) {
                    Path.addUnlessPresent(vector, (String)object2[n2]);
                    ++n2;
                }
            } else if (object instanceof Path) {
                object2 = (Path)object;
                if (((ProjectComponent)object2).getProject() == null) {
                    ((ProjectComponent)object2).setProject(this.getProject());
                }
                String[] stringArray = ((Path)object2).list();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    Path.addUnlessPresent(vector, stringArray[n3]);
                    ++n3;
                }
            } else if (object instanceof DirSet) {
                object2 = (DirSet)object;
                DirectoryScanner directoryScanner = ((AbstractFileSet)object2).getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedDirectories();
                file = ((AbstractFileSet)object2).getDir(this.getProject());
                Path.addUnlessPresent(vector, file, stringArray);
            } else if (object instanceof FileSet) {
                object2 = (FileSet)object;
                DirectoryScanner directoryScanner = ((AbstractFileSet)object2).getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                file = ((AbstractFileSet)object2).getDir(this.getProject());
                Path.addUnlessPresent(vector, file, stringArray);
            } else if (object instanceof FileList) {
                object2 = (FileList)object;
                String[] stringArray = ((FileList)object2).getFiles(this.getProject());
                File file2 = ((FileList)object2).getDir(this.getProject());
                Path.addUnlessPresent(vector, file2, stringArray);
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String toString() {
        String[] stringArray = this.list();
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0].toString());
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(File.pathSeparatorChar);
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] translatePath(Project project, String string) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return new String[0];
        }
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (pathTokenizer.hasMoreTokens()) {
            objectArray = pathTokenizer.nextToken();
            try {
                stringBuffer.append(Path.resolveFile(project, (String)objectArray));
            }
            catch (BuildException buildException) {
                project.log("Dropping path element " + (String)objectArray + " as it is not valid relative to the project", 3);
            }
            int n = 0;
            while (n < stringBuffer.length()) {
                Path.translateFileSep(stringBuffer, n);
                ++n;
            }
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer();
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String translateFile(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            Path.translateFileSep(stringBuffer, n);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static boolean translateFileSep(StringBuffer stringBuffer, int n) {
        if (stringBuffer.charAt(n) == '/' || stringBuffer.charAt(n) == '\\') {
            stringBuffer.setCharAt(n, File.separatorChar);
            return true;
        }
        return false;
    }

    public int size() {
        return this.list().length;
    }

    public Object clone() {
        try {
            Path path = (Path)super.clone();
            path.elements = (Vector)this.elements.clone();
            return path;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof Reference) {
                object = ((Reference)object).getReferencedObject(project);
            }
            if (!(object instanceof DataType)) continue;
            if (stack.contains(object)) {
                throw this.circularReference();
            }
            stack.push(object);
            ((DataType)object).dieOnCircularReference(stack, project);
            stack.pop();
        }
        this.setChecked(true);
    }

    private static String resolveFile(Project project, String string) {
        if (project != null) {
            File file = project.resolveFile(string);
            return file.getAbsolutePath();
        }
        return string;
    }

    private static void addUnlessPresent(Vector vector, String string) {
        if (vector.indexOf(string) == -1) {
            vector.addElement(string);
        }
    }

    private static void addUnlessPresent(Vector vector, File file, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            String string = file2.getAbsolutePath();
            Path.addUnlessPresent(vector, Path.translateFile(string));
            ++n;
        }
    }

    public Path concatSystemClasspath() {
        return this.concatSystemClasspath("last");
    }

    public Path concatSystemClasspath(String string) {
        String string2;
        Path path = new Path(this.getProject());
        String string3 = string;
        if (this.getProject() != null && (string2 = this.getProject().getProperty("build.sysclasspath")) != null) {
            string3 = string2;
        }
        if (string3.equals("only")) {
            path.addExisting(systemClasspath, true);
        } else if (string3.equals("first")) {
            path.addExisting(systemClasspath, true);
            path.addExisting(this);
        } else if (string3.equals("ignore")) {
            path.addExisting(this);
        } else {
            if (!string3.equals("last")) {
                this.log("invalid value for build.sysclasspath: " + string3, 1);
            }
            path.addExisting(this);
            path.addExisting(systemClasspath, true);
        }
        return path;
    }

    public void addJavaRuntime() {
        Object object;
        if ("Kaffe".equals(System.getProperty("java.vm.name"))) {
            object = new File(System.getProperty("java.home") + File.separator + "share" + File.separator + "kaffe");
            if (object.isDirectory()) {
                FileSet fileSet = new FileSet();
                fileSet.setDir((File)object);
                fileSet.setIncludes("*.jar");
                this.addFileset(fileSet);
            }
        } else if ("GNU libgcj".equals(System.getProperty("java.vm.name"))) {
            this.addExisting(systemBootClasspath);
        }
        if (System.getProperty("java.vendor").toLowerCase(Locale.US).indexOf("microsoft") >= 0) {
            object = new FileSet();
            object.setDir(new File(System.getProperty("java.home") + File.separator + "Packages"));
            object.setIncludes("*.ZIP");
            this.addFileset((FileSet)object);
        } else if (JavaEnvUtils.isJavaVersion("1.1")) {
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "classes.zip"));
        } else {
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
            object = new String[]{"jce", "jsse"};
            int n = 0;
            while (n < ((String[])object).length) {
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + object[n] + ".jar"));
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + object[n] + ".jar"));
                ++n;
            }
            String[] stringArray = new String[]{"core", "graphics", "security", "server", "xml"};
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + stringArray[n2] + ".jar"));
                ++n2;
            }
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "classes.jar"));
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "ui.jar"));
        }
    }

    public void addExtdirs(Path path) {
        String[] stringArray;
        if (path == null) {
            stringArray = System.getProperty("java.ext.dirs");
            if (stringArray != null) {
                path = new Path(this.getProject(), (String)stringArray);
            } else {
                return;
            }
        }
        stringArray = path.list();
        int n = 0;
        while (n < stringArray.length) {
            File file = this.getProject().resolveFile(stringArray[n]);
            if (file.exists() && file.isDirectory()) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(file);
                fileSet.setIncludes("*");
                this.addFileset(fileSet);
            }
            ++n;
        }
    }

    public class PathElement {
        private String[] parts;

        public void setLocation(File file) {
            this.parts = new String[]{Path.translateFile(file.getAbsolutePath())};
        }

        public void setPath(String string) {
            this.parts = Path.translatePath(Path.this.getProject(), string);
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

