/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.net.SocketPermission;
import java.security.UnresolvedPermission;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitException;

public class Permissions {
    private List grantedPermissions = new LinkedList();
    private List revokedPermissions = new LinkedList();
    private java.security.Permissions granted = null;
    private SecurityManager origSm = null;
    private boolean active = false;
    private boolean delegateToOldSM = false;

    public Permissions() {
    }

    public Permissions(boolean bl) {
        this.delegateToOldSM = bl;
    }

    public void addConfiguredGrant(Permission permission) {
        this.grantedPermissions.add(permission);
    }

    public void addConfiguredRevoke(Permission permission) {
        this.revokedPermissions.add(permission);
    }

    public void setSecurityManager() throws BuildException {
        this.origSm = System.getSecurityManager();
        this.init();
        System.setSecurityManager(new MySM());
        this.active = true;
    }

    private void init() throws BuildException {
        Object object;
        this.granted = new java.security.Permissions();
        ListIterator listIterator = this.revokedPermissions.listIterator();
        while (listIterator.hasNext()) {
            object = (Permission)listIterator.next();
            if (((Permission)object).getClassName() != null) continue;
            throw new BuildException("Revoked permission " + object + " does not contain a class.");
        }
        object = this.grantedPermissions.listIterator();
        while (object.hasNext()) {
            Permission permission = (Permission)object.next();
            if (permission.getClassName() == null) {
                throw new BuildException("Granted permission " + permission + " does not contain a class.");
            }
            UnresolvedPermission unresolvedPermission = new UnresolvedPermission(permission.getClassName(), permission.getName(), permission.getActions(), null);
            this.granted.add(unresolvedPermission);
        }
        this.granted.add(new SocketPermission("localhost:1024-", "listen"));
        this.granted.add(new PropertyPermission("java.version", "read"));
        this.granted.add(new PropertyPermission("java.vendor", "read"));
        this.granted.add(new PropertyPermission("java.vendor.url", "read"));
        this.granted.add(new PropertyPermission("java.class.version", "read"));
        this.granted.add(new PropertyPermission("os.name", "read"));
        this.granted.add(new PropertyPermission("os.version", "read"));
        this.granted.add(new PropertyPermission("os.arch", "read"));
        this.granted.add(new PropertyPermission("file.encoding", "read"));
        this.granted.add(new PropertyPermission("file.separator", "read"));
        this.granted.add(new PropertyPermission("path.separator", "read"));
        this.granted.add(new PropertyPermission("line.separator", "read"));
        this.granted.add(new PropertyPermission("java.specification.version", "read"));
        this.granted.add(new PropertyPermission("java.specification.vendor", "read"));
        this.granted.add(new PropertyPermission("java.specification.name", "read"));
        this.granted.add(new PropertyPermission("java.vm.specification.version", "read"));
        this.granted.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        this.granted.add(new PropertyPermission("java.vm.specification.name", "read"));
        this.granted.add(new PropertyPermission("java.vm.version", "read"));
        this.granted.add(new PropertyPermission("java.vm.vendor", "read"));
        this.granted.add(new PropertyPermission("java.vm.name", "read"));
    }

    public void restoreSecurityManager() {
        this.active = false;
        System.setSecurityManager(this.origSm);
    }

    private class MySM
    extends SecurityManager {
        private MySM() {
        }

        public void checkExit(int n) {
            RuntimePermission runtimePermission = new RuntimePermission("exitVM", null);
            try {
                this.checkPermission(runtimePermission);
            }
            catch (SecurityException securityException) {
                throw new ExitException(securityException.getMessage(), n);
            }
        }

        public void checkPermission(java.security.Permission permission) {
            if (Permissions.this.active) {
                if (Permissions.this.delegateToOldSM && !permission.getName().equals("exitVM")) {
                    boolean bl = false;
                    if (Permissions.this.granted.implies(permission)) {
                        bl = true;
                    }
                    this.checkRevoked(permission);
                    if (!bl && Permissions.this.origSm != null) {
                        Permissions.this.origSm.checkPermission(permission);
                    }
                } else {
                    if (!Permissions.this.granted.implies(permission)) {
                        throw new SecurityException("Permission " + permission + " was not granted.");
                    }
                    this.checkRevoked(permission);
                }
            }
        }

        private void checkRevoked(java.security.Permission permission) {
            ListIterator listIterator = Permissions.this.revokedPermissions.listIterator();
            while (listIterator.hasNext()) {
                if (!((Permission)listIterator.next()).matches(permission)) continue;
                throw new SecurityException("Permission " + permission + " was revoked.");
            }
        }
    }

    public static class Permission {
        private String className;
        private String name;
        private String actionString;
        private Set actions;

        public void setClass(String string) {
            this.className = string.trim();
        }

        public String getClassName() {
            return this.className;
        }

        public void setName(String string) {
            this.name = string.trim();
        }

        public String getName() {
            return this.name;
        }

        public void setActions(String string) {
            this.actionString = string;
            if (string.length() > 0) {
                this.actions = this.parseActions(string);
            }
        }

        public String getActions() {
            return this.actionString;
        }

        boolean matches(java.security.Permission permission) {
            if (!this.className.equals(permission.getClass().getName())) {
                return false;
            }
            if (this.name != null && (this.name.endsWith("*") ? !permission.getName().startsWith(this.name.substring(0, this.name.length() - 1)) : !this.name.equals(permission.getName()))) {
                return false;
            }
            if (this.actions != null) {
                Set set = this.parseActions(permission.getActions());
                int n = set.size();
                set.removeAll(this.actions);
                if (set.size() == n) {
                    return false;
                }
            }
            return true;
        }

        private Set parseActions(String string) {
            HashSet<String> hashSet = new HashSet<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals("")) continue;
                hashSet.add(string2);
            }
            return hashSet;
        }

        public String toString() {
            return "Permission: " + this.className + " (\"" + this.name + "\", \"" + this.actions + "\")";
        }
    }
}

