/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class PropertySet
extends DataType {
    private boolean dynamic = true;
    private boolean negate = false;
    private Set cachedNames;
    private Vector ptyRefs = new Vector();
    private Vector setRefs = new Vector();
    private Mapper _mapper;
    private boolean noAttributeSet = true;

    public void appendName(String string) {
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setName(string);
        this.addPropertyref(propertyRef);
    }

    public void appendRegex(String string) {
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setRegex(string);
        this.addPropertyref(propertyRef);
    }

    public void appendPrefix(String string) {
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setPrefix(string);
        this.addPropertyref(propertyRef);
    }

    public void appendBuiltin(BuiltinPropertySetName builtinPropertySetName) {
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setBuiltin(builtinPropertySetName);
        this.addPropertyref(propertyRef);
    }

    public void setMapper(String string, String string2, String string3) {
        Mapper mapper = this.createMapper();
        Mapper.MapperType mapperType = new Mapper.MapperType();
        mapperType.setValue(string);
        mapper.setFrom(string2);
        mapper.setTo(string3);
    }

    public void addPropertyref(PropertyRef propertyRef) {
        this.assertNotReference();
        this.ptyRefs.addElement(propertyRef);
    }

    public void addPropertyset(PropertySet propertySet) {
        this.assertNotReference();
        this.setRefs.addElement(propertySet);
    }

    public Mapper createMapper() {
        this.assertNotReference();
        if (this._mapper != null) {
            throw new BuildException("Too many <mapper>s!");
        }
        this._mapper = new Mapper(this.getProject());
        return this._mapper;
    }

    public void setDynamic(boolean bl) {
        this.assertNotReference();
        this.dynamic = bl;
    }

    public void setNegate(boolean bl) {
        this.assertNotReference();
        this.negate = bl;
    }

    public boolean getDynamic() {
        return this.isReference() ? this.getRef().dynamic : this.dynamic;
    }

    public Mapper getMapper() {
        return this.isReference() ? this.getRef()._mapper : this._mapper;
    }

    public Properties getProperties() {
        Object object;
        Object object2;
        Hashtable hashtable;
        Object object3 = null;
        Project project = this.getProject();
        Hashtable hashtable2 = hashtable = project == null ? System.getProperties() : project.getProperties();
        if (this.getDynamic() || this.cachedNames == null) {
            object3 = new HashSet();
            if (this.isReference()) {
                this.getRef().addPropertyNames((Set)object3, hashtable);
            } else {
                this.addPropertyNames((Set)object3, hashtable);
            }
            object2 = this.setRefs.elements();
            while (object2.hasMoreElements()) {
                object = (PropertySet)object2.nextElement();
                object3.addAll(((PropertySet)object).getProperties().keySet());
            }
            if (this.negate) {
                object = new HashSet(hashtable.keySet());
                ((AbstractSet)object).removeAll((Collection<?>)object3);
                object3 = object;
            }
            if (!this.getDynamic()) {
                this.cachedNames = object3;
            }
        } else {
            object3 = this.cachedNames;
        }
        object2 = null;
        object = this.getMapper();
        if (object != null) {
            object2 = ((Mapper)object).getImplementation();
        }
        Properties properties = new Properties();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string = (String)iterator.next();
            String string2 = (String)hashtable.get(string);
            if (object2 != null && (stringArray = object2.mapFileName(string)) != null) {
                string = stringArray[0];
            }
            properties.setProperty(string, string2);
        }
        return properties;
    }

    private void addPropertyNames(Set set, Hashtable hashtable) {
        Project project = this.getProject();
        Enumeration enumeration = this.ptyRefs.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            PropertyRef propertyRef = (PropertyRef)enumeration.nextElement();
            if (propertyRef.name != null) {
                if (project == null || project.getProperty(propertyRef.name) == null) continue;
                set.add(propertyRef.name);
                continue;
            }
            if (propertyRef.prefix != null) {
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (!((String)object).startsWith(propertyRef.prefix)) continue;
                    set.add(object);
                }
                continue;
            }
            if (propertyRef.regex != null) {
                object2 = new RegexpMatcherFactory();
                object = ((RegexpMatcherFactory)object2).newRegexpMatcher();
                object.setPattern(propertyRef.regex);
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    if (!object.matches(string)) continue;
                    set.add(string);
                }
                continue;
            }
            if (propertyRef.builtin != null) {
                if (propertyRef.builtin.equals("all")) {
                    set.addAll(hashtable.keySet());
                    continue;
                }
                if (propertyRef.builtin.equals("system")) {
                    set.addAll(System.getProperties().keySet());
                    continue;
                }
                if (propertyRef.builtin.equals("commandline")) {
                    set.addAll(this.getProject().getUserProperties().keySet());
                    continue;
                }
                throw new BuildException("Impossible: Invalid builtin attribute!");
            }
            throw new BuildException("Impossible: Invalid PropertyRef!");
        }
    }

    protected PropertySet getRef() {
        Object object;
        if (!this.isChecked()) {
            object = new Stack<PropertySet>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, this.getProject());
        }
        if (!((object = this.getRefid().getReferencedObject(this.getProject())) instanceof PropertySet)) {
            String string = this.getRefid().getRefId() + " doesn't denote a propertyset";
            throw new BuildException(string);
        }
        return (PropertySet)object;
    }

    public final void setRefid(Reference reference) {
        if (!this.noAttributeSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    protected final void assertNotReference() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.noAttributeSet = false;
    }

    public static class BuiltinPropertySetName
    extends EnumeratedAttribute {
        static final String ALL = "all";
        static final String SYSTEM = "system";
        static final String COMMANDLINE = "commandline";

        public String[] getValues() {
            return new String[]{ALL, SYSTEM, COMMANDLINE};
        }
    }

    public static class PropertyRef {
        private int count;
        private String name;
        private String regex;
        private String prefix;
        private String builtin;

        public void setName(String string) {
            this.assertValid("name", string);
            this.name = string;
        }

        public void setRegex(String string) {
            this.assertValid("regex", string);
            this.regex = string;
        }

        public void setPrefix(String string) {
            this.assertValid("prefix", string);
            this.prefix = string;
        }

        public void setBuiltin(BuiltinPropertySetName builtinPropertySetName) {
            String string = builtinPropertySetName.getValue();
            this.assertValid("builtin", string);
            this.builtin = string;
        }

        private void assertValid(String string, String string2) {
            if (string2 == null || string2.length() < 1) {
                throw new BuildException("Invalid attribute: " + string);
            }
            if (++this.count != 1) {
                throw new BuildException("Attributes name, regex, and prefix are mutually exclusive");
            }
        }

        public String toString() {
            return "name=" + this.name + ", regex=" + this.regex + ", prefix=" + this.prefix + ", builtin=" + this.builtin;
        }
    }
}

