/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;

public class PresentSelector
extends BaseSelector {
    private File targetdir = null;
    private Mapper mapperElement = null;
    private FileNameMapper map = null;
    private boolean destmustexist = true;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{presentselector targetdir: ");
        if (this.targetdir == null) {
            stringBuffer.append("NOT YET SET");
        } else {
            stringBuffer.append(this.targetdir.getName());
        }
        stringBuffer.append(" present: ");
        if (this.destmustexist) {
            stringBuffer.append("both");
        } else {
            stringBuffer.append("srconly");
        }
        if (this.map != null) {
            stringBuffer.append(this.map.toString());
        } else if (this.mapperElement != null) {
            stringBuffer.append(this.mapperElement.toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setTargetdir(File file) {
        this.targetdir = file;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper");
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void setPresent(FilePresence filePresence) {
        if (filePresence.getIndex() == 0) {
            this.destmustexist = false;
        }
    }

    public void verifySettings() {
        if (this.targetdir == null) {
            this.setError("The targetdir attribute is required.");
        }
        this.map = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
        if (this.map == null) {
            this.setError("Could not set <mapper> element.");
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        String[] stringArray = this.map.mapFileName(string);
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length != 1 || stringArray[0] == null) {
            throw new BuildException("Invalid destination file results for " + this.targetdir + " with filename " + string);
        }
        String string2 = stringArray[0];
        File file3 = new File(this.targetdir, string2);
        return file3.exists() == this.destmustexist;
    }

    public static class FilePresence
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"srconly", "both"};
        }
    }
}

